/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avrooutput;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.avro.transforms.avrooutput.AvroOutputData;
import org.apache.hop.avro.transforms.avrooutput.AvroOutputField;
import org.apache.hop.avro.transforms.avrooutput.AvroOutputMeta;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class AvroOutput
extends BaseTransform<AvroOutputMeta, AvroOutputData> {
    private static final Class<?> PKG = AvroOutputMeta.class;
    private List<AvroOutputField> avroOutputFields;
    private int outputFieldIndex;

    public AvroOutput(TransformMeta transformMeta, AvroOutputMeta meta, AvroOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private GenericRecord getRecord(Object[] r, String parentPath, Schema inputSchema) throws HopException {
        String parentName = "";
        if (parentPath != null) {
            parentName = parentPath;
        }
        Schema recordSchema = inputSchema;
        List unionSchemas = null;
        if (inputSchema.getType() == Schema.Type.UNION && (unionSchemas = inputSchema.getTypes()) != null) {
            for (int i = 0; i < unionSchemas.size(); ++i) {
                if (((Schema)unionSchemas.get(i)).getType() != Schema.Type.RECORD) continue;
                recordSchema = (Schema)unionSchemas.get(i);
                break;
            }
        }
        GenericData.Record result = new GenericData.Record(recordSchema);
        while (this.outputFieldIndex < this.avroOutputFields.size()) {
            AvroOutputField aof = this.avroOutputFields.get(this.outputFieldIndex);
            String avroName = aof.getAvroName();
            if (avroName.startsWith("$.")) {
                avroName = avroName.substring(2);
            }
            if (parentName != null && parentName.length() != 0 && !avroName.startsWith(parentName + ".")) break;
            if (parentName != null && parentName.length() > 0) {
                avroName = avroName.substring(parentName.length() + 1);
            }
            if (avroName.contains(".")) {
                String currentAvroPath = avroName.substring(0, avroName.indexOf("."));
                Schema childSchema = recordSchema.getField(currentAvroPath).schema();
                Object childPath = parentName + "." + currentAvroPath;
                if (parentName == null || parentName.length() == 0) {
                    childPath = currentAvroPath;
                }
                GenericRecord fieldRecord = this.getRecord(r, (String)childPath, childSchema);
                result.put(currentAvroPath, (Object)fieldRecord);
                continue;
            }
            Schema.Field avroField = recordSchema.getField(avroName);
            Object value = this.getValue(r, ((AvroOutputMeta)this.meta).getOutputFields().get(this.outputFieldIndex), ((AvroOutputData)this.data).fieldNrs[this.outputFieldIndex], avroField);
            if (value != null) {
                result.put(avroName, value);
            }
            ++this.outputFieldIndex;
        }
        return result;
    }

    public Schema createAvroSchema(List<AvroOutputField> avroFields, String parentPath) throws HopException {
        Object doc = ((AvroOutputMeta)this.meta).getDoc();
        String recordName = ((AvroOutputMeta)this.meta).getRecordName();
        String namespace = ((AvroOutputMeta)this.meta).getNamespace();
        if (parentPath.startsWith("$.")) {
            parentPath = parentPath.substring(2);
        }
        if (parentPath.endsWith(".")) {
            parentPath = parentPath.substring(0, parentPath.length() - 1);
        }
        if (!parentPath.isEmpty()) {
            doc = "Auto generated for path " + parentPath;
            recordName = parentPath.replaceAll("[^A-Za-z0-9\\_]", "_");
        }
        Schema result = Schema.createRecord((String)recordName, (String)doc, (String)namespace, (boolean)false);
        ArrayList<Schema.Field> resultFields = new ArrayList<Schema.Field>();
        for (int i = 0; i < avroFields.size(); ++i) {
            Schema outSchema;
            if (avroFields.get(i) == null) continue;
            AvroOutputField field = avroFields.get(i);
            String avroName = field.getAvroName();
            if (avroName.startsWith("$.")) {
                avroName = avroName.substring(2);
            }
            String finalName = avroName;
            if (!parentPath.isEmpty()) {
                finalName = avroName.substring(parentPath.length() + 1);
            }
            if (finalName.contains(".")) {
                Schema subSchema;
                StringBuilder builder = new StringBuilder();
                if (!parentPath.isEmpty()) {
                    builder.append(parentPath).append(".");
                }
                builder.append(finalName.substring(0, finalName.indexOf("."))).append(".");
                String subPath = builder.toString();
                ArrayList<AvroOutputField> subFields = new ArrayList<AvroOutputField>();
                subFields.add(field);
                boolean nullable = field.isNullable();
                for (int e = i + 1; e < avroFields.size(); ++e) {
                    if (avroFields.get(e) == null) continue;
                    AvroOutputField subFieldCandidate = avroFields.get(e);
                    String candidateName = subFieldCandidate.getAvroName();
                    if (candidateName.startsWith("$.")) {
                        candidateName = candidateName.substring(2);
                    }
                    if (!candidateName.startsWith(subPath)) continue;
                    if (nullable) {
                        nullable = subFieldCandidate.isNullable();
                    }
                    subFields.add(subFieldCandidate);
                    avroFields.remove(e);
                    --e;
                }
                subPath = subPath.substring(0, subPath.length() - 1);
                Schema outSchema2 = subSchema = this.createAvroSchema(subFields, subPath);
                if (nullable) {
                    Schema unionSchema;
                    Schema nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
                    ArrayList<Schema> unionList = new ArrayList<Schema>();
                    unionList.add(nullSchema);
                    unionList.add(subSchema);
                    outSchema2 = unionSchema = Schema.createUnion(unionList);
                }
                Schema.Field schemaField = new Schema.Field(finalName.substring(0, finalName.indexOf(".")), outSchema2, null, null);
                resultFields.add(schemaField);
                continue;
            }
            Schema fieldSchema = Schema.create((Schema.Type)field.getAvroSchemaType());
            if (field.isNullable()) {
                Schema nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
                ArrayList<Schema> unionSchema = new ArrayList<Schema>();
                unionSchema.add(nullSchema);
                unionSchema.add(fieldSchema);
                outSchema = Schema.createUnion(unionSchema);
            } else {
                outSchema = fieldSchema;
            }
            Schema.Field outField = new Schema.Field(finalName, outSchema, null, null);
            resultFields.add(outField);
        }
        result.setFields(resultFields);
        return result;
    }

    public void writeSchemaFile() throws HopException {
        ArrayList<AvroOutputField> fields = new ArrayList<AvroOutputField>();
        for (AvroOutputField avroField : ((AvroOutputMeta)this.meta).getOutputFields()) {
            fields.add(avroField);
        }
        ((AvroOutputData)this.data).avroSchema = this.createAvroSchema(fields, "");
        if (this.log.isDetailed()) {
            this.logDetailed("Automatically generated Avro schema.");
        }
        if (((AvroOutputMeta)this.meta).isWriteSchemaFile()) {
            if (this.log.isDetailed()) {
                this.logDetailed("Writing schema file.");
            }
            try {
                String schemaFileName = this.buildFilename(this.resolve(((AvroOutputMeta)this.meta).getSchemaFileName()));
                if (((AvroOutputMeta)this.meta).isCreateParentFolder()) {
                    this.logDetailed("Creating parent folder for schema file");
                    this.createParentFolder(schemaFileName);
                }
                OutputStream outputStream = this.getOutputStream(schemaFileName, false);
                if (this.log.isDetailed()) {
                    this.logDetailed("Opening output stream in default encoding");
                }
                BufferedOutputStream schemaWriter = new BufferedOutputStream(outputStream, 5000);
                if (this.log.isDetailed()) {
                    this.logDetailed("Opened new file with name [" + schemaFileName + "]");
                }
                ((OutputStream)schemaWriter).write(((AvroOutputData)this.data).avroSchema.toString(true).getBytes());
                ((OutputStream)schemaWriter).close();
                if (this.log.isDetailed()) {
                    this.logDetailed("Closed schema file with name [" + schemaFileName + "]");
                }
            }
            catch (Exception e) {
                throw new HopException("Error opening new file : " + e.toString());
            }
        }
    }

    public synchronized boolean processRow() throws HopException {
        boolean result = true;
        Object[] r = this.getRow();
        if (this.first) {
            this.first = false;
            this.avroOutputFields = ((AvroOutputMeta)this.meta).getOutputFields();
            this.createFileAndSchema();
            if (r != null) {
                ((AvroOutputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((AvroOutputMeta)this.meta).getFields(((AvroOutputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((AvroOutputData)this.data).fieldNrs = new int[this.avroOutputFields.size()];
                for (int i = 0; i < this.avroOutputFields.size(); ++i) {
                    if (!this.avroOutputFields.get(i).validate()) continue;
                    ((AvroOutputData)this.data).fieldNrs[i] = ((AvroOutputData)this.data).outputRowMeta.indexOfValue(this.avroOutputFields.get(i).getName());
                    if (((AvroOutputData)this.data).fieldNrs[i] >= 0) continue;
                    throw new HopException("Field [" + this.avroOutputFields.get(i).getName() + "] couldn't be found in the input stream!");
                }
            }
        }
        if (r == null) {
            this.closeOutput();
            this.setOutputDone();
            return false;
        }
        this.outputFieldIndex = 0;
        GenericRecord row = this.getRecord(r, null, ((AvroOutputData)this.data).avroSchema);
        try {
            if (((AvroOutputMeta)this.meta).getOutputType().equals(AvroOutputMeta.OUTPUT_TYPES[0])) {
                ((AvroOutputData)this.data).dataFileWriter.append((Object)row);
            } else if (((AvroOutputMeta)this.meta).getOutputType().equals(AvroOutputMeta.OUTPUT_TYPES[1])) {
                ((AvroOutputData)this.data).datumWriter.write((Object)row, (Encoder)((AvroOutputData)this.data).binaryEncoder);
                ((AvroOutputData)this.data).binaryEncoder.flush();
                ((AvroOutputData)this.data).byteArrayOutputStream.flush();
                RowDataUtil.addValueData((Object[])r, (int)(((AvroOutputData)this.data).outputRowMeta.size() - 1), (Object)((AvroOutputData)this.data).byteArrayOutputStream.toByteArray());
                ((AvroOutputData)this.data).byteArrayOutputStream.close();
                ((AvroOutputData)this.data).byteArrayOutputStream.reset();
            } else if (((AvroOutputMeta)this.meta).getOutputType().equals(AvroOutputMeta.OUTPUT_TYPES[2])) {
                ((AvroOutputData)this.data).datumWriter.write((Object)row, (Encoder)((AvroOutputData)this.data).jsonEncoder);
                ((AvroOutputData)this.data).jsonEncoder.flush();
                ((AvroOutputData)this.data).byteArrayOutputStream.flush();
                RowDataUtil.addValueData((Object[])r, (int)(((AvroOutputData)this.data).outputRowMeta.size() - 1), (Object)((AvroOutputData)this.data).byteArrayOutputStream.toString());
                ((AvroOutputData)this.data).byteArrayOutputStream.close();
                ((AvroOutputData)this.data).byteArrayOutputStream.reset();
            }
        }
        catch (IOException i) {
            throw new HopException((Throwable)i);
        }
        this.putRow(((AvroOutputData)this.data).outputRowMeta, r);
        if (this.checkFeedback(this.getLinesOutput())) {
            this.logBasic("linenr " + this.getLinesOutput());
        }
        return result;
    }

    private void createFileAndSchema() throws HopException {
        block10: {
            try {
                if (((AvroOutputMeta)this.meta).isCreateSchemaFile()) {
                    this.logDetailed("Generating Avro schema.");
                    this.writeSchemaFile();
                } else {
                    this.logDetailed("Reading Avro schema from file.");
                    try {
                        ((AvroOutputData)this.data).avroSchema = new Schema.Parser().parse(new File(((AvroOutputMeta)this.meta).getSchemaFileName()));
                    }
                    catch (Exception e) {
                        this.logError("Error parsing schema file", e);
                    }
                }
                ((AvroOutputData)this.data).datumWriter = new GenericDatumWriter(((AvroOutputData)this.data).avroSchema);
                if (((AvroOutputMeta)this.meta).getOutputType().equals(AvroOutputMeta.OUTPUT_TYPES[1])) {
                    ((AvroOutputData)this.data).encoderFactory = new EncoderFactory();
                    ((AvroOutputData)this.data).byteArrayOutputStream = new ByteArrayOutputStream();
                    ((AvroOutputData)this.data).binaryEncoder = ((AvroOutputData)this.data).encoderFactory.binaryEncoder((OutputStream)((AvroOutputData)this.data).byteArrayOutputStream, null);
                    break block10;
                }
                if (((AvroOutputMeta)this.meta).getOutputType().equals(AvroOutputMeta.OUTPUT_TYPES[0])) {
                    ((AvroOutputData)this.data).dataFileWriter = new DataFileWriter(((AvroOutputData)this.data).datumWriter);
                    if (!Utils.isEmpty((CharSequence)((AvroOutputMeta)this.meta).getCompressionType()) && !((AvroOutputMeta)this.meta).getCompressionType().equalsIgnoreCase("none")) {
                        ((AvroOutputData)this.data).dataFileWriter.setCodec(CodecFactory.fromString((String)((AvroOutputMeta)this.meta).getCompressionType()));
                    }
                    this.openNewFile(((AvroOutputMeta)this.meta).getFileName());
                    ((AvroOutputData)this.data).dataFileWriter.create(((AvroOutputData)this.data).avroSchema, ((AvroOutputData)this.data).writer);
                    break block10;
                }
                if (((AvroOutputMeta)this.meta).getOutputType().equals(AvroOutputMeta.OUTPUT_TYPES[2])) {
                    ((AvroOutputData)this.data).encoderFactory = new EncoderFactory();
                    ((AvroOutputData)this.data).byteArrayOutputStream = new ByteArrayOutputStream();
                    ((AvroOutputData)this.data).jsonEncoder = ((AvroOutputData)this.data).encoderFactory.jsonEncoder(((AvroOutputData)this.data).avroSchema, (OutputStream)((AvroOutputData)this.data).byteArrayOutputStream);
                    break block10;
                }
                throw new HopException("Invalid output type " + ((AvroOutputMeta)this.meta).getOutputType());
            }
            catch (IOException ex) {
                throw new HopException("Could not open Avro writer", (Throwable)ex);
            }
        }
    }

    private void closeOutput() throws HopException {
        if (((AvroOutputMeta)this.meta).getOutputType().equals(AvroOutputMeta.OUTPUT_TYPES[1])) {
            try {
                ((AvroOutputData)this.data).binaryEncoder = null;
                ((AvroOutputData)this.data).jsonEncoder = null;
                if (((AvroOutputData)this.data).byteArrayOutputStream != null) {
                    ((AvroOutputData)this.data).byteArrayOutputStream.close();
                }
                ((AvroOutputData)this.data).encoderFactory = null;
            }
            catch (Exception ex) {
                throw new HopException("Error cleaning up transform", (Throwable)ex);
            }
        } else if (((AvroOutputMeta)this.meta).getOutputType().equals(AvroOutputMeta.OUTPUT_TYPES[0])) {
            this.closeFile();
        }
        ((AvroOutputData)this.data).datumWriter = null;
        ((AvroOutputData)this.data).avroSchema = null;
    }

    public Object getValue(Object[] r, AvroOutputField outputField, int inputFieldIndex, Schema.Field fieldSchema) throws HopException {
        Object value;
        switch (outputField.getAvroType()) {
            case 4: {
                value = ((AvroOutputData)this.data).outputRowMeta.getInteger(r, inputFieldIndex).intValue();
                break;
            }
            case 6: {
                value = ((AvroOutputData)this.data).outputRowMeta.getString(r, inputFieldIndex);
                break;
            }
            case 5: {
                value = ((AvroOutputData)this.data).outputRowMeta.getInteger(r, inputFieldIndex);
                break;
            }
            case 3: {
                value = Float.valueOf(((AvroOutputData)this.data).outputRowMeta.getNumber(r, inputFieldIndex).floatValue());
                break;
            }
            case 2: {
                value = ((AvroOutputData)this.data).outputRowMeta.getNumber(r, inputFieldIndex);
                break;
            }
            case 1: {
                value = ((AvroOutputData)this.data).outputRowMeta.getBoolean(r, inputFieldIndex);
                break;
            }
            case 7: {
                Schema schema = this.getFirstEnumSchema(fieldSchema);
                String fieldValue = ((AvroOutputData)this.data).outputRowMeta.getString(r, inputFieldIndex);
                value = new GenericData.EnumSymbol(schema, fieldValue);
                break;
            }
            default: {
                throw new HopException("Avro type " + outputField.getAvroTypeDesc() + " is not supported for field " + outputField.getAvroName() + ".");
            }
        }
        return value;
    }

    private Schema getFirstEnumSchema(Schema.Field field) {
        Schema fieldSchema = field.schema();
        Schema.Type fieldType = fieldSchema.getType();
        if (fieldType == Schema.Type.ENUM) {
            return fieldSchema;
        }
        if (fieldType == Schema.Type.UNION) {
            List subSchemas = fieldSchema.getTypes();
            for (Schema subSchema : subSchemas) {
                if (subSchema.getType() != Schema.Type.ENUM) continue;
                return subSchema;
            }
        }
        return field.schema();
    }

    public String buildFilename(String filename) {
        return ((AvroOutputMeta)this.meta).buildFilename(filename, (IVariables)this, this.getCopy(), this.getPartitionId(), ((AvroOutputData)this.data).isBeamContext(), this.log.getLogChannelId(), ((AvroOutputData)this.data).getBeamBundleNr());
    }

    public void openNewFile(String baseFilename) throws HopException {
        if (baseFilename == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"AvroOutput.Exception.FileNameNotSet", (String[])new String[0]));
        }
        ((AvroOutputData)this.data).writer = null;
        String filename = this.buildFilename(this.resolve(baseFilename));
        try {
            if (((AvroOutputMeta)this.meta).isCreateParentFolder()) {
                this.createParentFolder(filename);
            }
            OutputStream outputStream = this.getOutputStream(filename, false);
            if (this.log.isDetailed()) {
                this.logDetailed("Opening output stream in default encoding");
            }
            ((AvroOutputData)this.data).writer = new BufferedOutputStream(outputStream, 5000);
            if (this.log.isDetailed()) {
                this.logDetailed("Opened new file with name [" + filename + "]");
            }
        }
        catch (Exception e) {
            throw new HopException("Error opening new file : " + e.toString());
        }
        if (((AvroOutputMeta)this.meta).isAddToResultFilenames()) {
            ResultFile resultFile = new ResultFile(0, this.getFileObject(filename), this.getPipelineMeta().getName(), this.getTransformName());
            resultFile.setComment(BaseMessages.getString(PKG, (String)"AvroOutput.AddResultFile", (String[])new String[0]));
            this.addResultFile(resultFile);
        }
    }

    private boolean closeFile() {
        boolean retval = false;
        try {
            if (((AvroOutputData)this.data).writer != null) {
                ((AvroOutputData)this.data).writer.flush();
                if (this.log.isDebug()) {
                    this.logDebug("Closing output stream");
                }
                if (((AvroOutputData)this.data).dataFileWriter != null) {
                    ((AvroOutputData)this.data).dataFileWriter.close();
                }
                ((AvroOutputData)this.data).writer = null;
                ((AvroOutputData)this.data).dataFileWriter = null;
                if (this.log.isDebug()) {
                    this.logDebug("Closed output stream");
                }
            }
            ((AvroOutputData)this.data).datumWriter = null;
            ((AvroOutputData)this.data).avroSchema = null;
            retval = true;
        }
        catch (Exception e) {
            this.logError("Exception trying to close file: ", e);
            this.setErrors(1L);
            retval = false;
        }
        return retval;
    }

    public boolean init() {
        return super.init();
    }

    public void dispose() {
        if (((AvroOutputData)this.data).writer != null) {
            this.closeFile();
        }
        ((AvroOutputData)this.data).datumWriter = null;
        ((AvroOutputData)this.data).avroSchema = null;
        super.dispose();
    }

    public void startBundle() throws HopException {
        if (!this.first) {
            this.createFileAndSchema();
        }
    }

    public void batchComplete() throws HopException {
        if (!((AvroOutputData)this.data).isBeamContext()) {
            this.closeOutput();
        }
    }

    public void finishBundle() throws HopException {
        this.closeOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParentFolder(String filename) throws Exception {
        block13: {
            FileObject parentfolder = null;
            try {
                parentfolder = this.getFileObject(filename).getParent();
                if (parentfolder.exists()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"AvroOutput.Log.ParentFolderExist", (Object[])new Object[]{parentfolder.getName()}));
                    }
                    break block13;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"AvroOutput.Log.ParentFolderNotExist", (Object[])new Object[]{parentfolder.getName()}));
                }
                if (((AvroOutputMeta)this.meta).isCreateParentFolder()) {
                    parentfolder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"AvroOutput.Log.ParentFolderCreated", (Object[])new Object[]{parentfolder.getName()}));
                    }
                    break block13;
                }
                throw new HopException(BaseMessages.getString(PKG, (String)"AvroOutput.Log.ParentFolderNotExistCreateIt", (Object[])new Object[]{parentfolder.getName(), filename}));
            }
            finally {
                if (parentfolder != null) {
                    try {
                        parentfolder.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected FileObject getFileObject(String vfsFilename) throws HopFileException {
        return HopVfs.getFileObject((String)vfsFilename);
    }

    protected OutputStream getOutputStream(String vfsFilename, boolean append) throws HopFileException {
        return HopVfs.getOutputStream((String)vfsFilename, (boolean)append);
    }
}

