/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceCopier;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.SequenceWrapper;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.QNameValue;

public class QueryResult {
    public static String RESULT_NS = "http://saxon.sf.net/xquery-results";

    private QueryResult() {
    }

    public static DocumentInfo wrap(SequenceIterator sequenceIterator, Configuration configuration) throws XPathException {
        PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
        TinyBuilder tinyBuilder = new TinyBuilder();
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(tinyBuilder);
        NamespaceReducer namespaceReducer2 = namespaceReducer;
        namespaceReducer2.setPipelineConfiguration(pipelineConfiguration);
        tinyBuilder.setPipelineConfiguration(pipelineConfiguration);
        QueryResult.sendWrappedSequence(sequenceIterator, namespaceReducer2);
        return (DocumentInfo)tinyBuilder.getCurrentRoot();
    }

    public static void sendWrappedSequence(SequenceIterator sequenceIterator, Receiver receiver) throws XPathException {
        SequenceCopier.copySequence(sequenceIterator, new SequenceWrapper(receiver));
    }

    public static void serialize(NodeInfo nodeInfo, Result result, Properties properties, Configuration configuration) throws XPathException {
        PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
        int n = nodeInfo.getNodeKind();
        if (n != 9 && n != 1) {
            throw new DynamicError("Node to be serialized must be a Document or Element node");
        }
        DocumentSender documentSender = new DocumentSender(nodeInfo);
        Receiver receiver = SerializerFactory.getReceiver(result, pipelineConfiguration, properties);
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(receiver);
        namespaceReducer.setPipelineConfiguration(pipelineConfiguration);
        documentSender.send(namespaceReducer);
    }

    public static void serializeSequence(SequenceIterator sequenceIterator, Configuration configuration, OutputStream outputStream, Properties properties) throws XPathException {
        Item item;
        PrintWriter printWriter;
        String string = properties.getProperty("encoding");
        if (string == null) {
            string = "UTF-8";
        }
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DynamicError(unsupportedEncodingException);
        }
        block8: while ((item = sequenceIterator.next()) != null) {
            if (item instanceof NodeInfo) {
                switch (((NodeInfo)item).getNodeKind()) {
                    case 1: 
                    case 9: {
                        QueryResult.serialize((NodeInfo)item, new StreamResult(printWriter), properties, configuration);
                        printWriter.println("");
                        continue block8;
                    }
                    case 2: {
                        printWriter.println(((NodeInfo)item).getLocalPart() + "=\"" + item.getStringValue() + '\"');
                        continue block8;
                    }
                    case 8: {
                        printWriter.println("<!--" + item.getStringValue() + "-->");
                        continue block8;
                    }
                    case 7: {
                        printWriter.println("<?" + ((NodeInfo)item).getLocalPart() + ' ' + item.getStringValue() + "?>");
                        continue block8;
                    }
                }
                printWriter.println(item.getStringValue());
                continue;
            }
            if (item instanceof QNameValue) {
                printWriter.println(((QNameValue)item).getClarkName());
                continue;
            }
            printWriter.println(item.getStringValue());
        }
        printWriter.flush();
    }
}

