/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.search.BaseSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;
import org.apache.hop.core.variables.DescribedVariable;

@SearchableAnalyserPlugin(id="DescribedVariableSearchableAnalyser", name="Search in a described variable")
public class DescribedVariableSearchableAnalyser
extends BaseSearchableAnalyser<DescribedVariable>
implements ISearchableAnalyser<DescribedVariable> {
    public Class<DescribedVariable> getSearchableClass() {
        return DescribedVariable.class;
    }

    public List<ISearchResult> search(ISearchable<DescribedVariable> searchable, ISearchQuery searchQuery) {
        DescribedVariable describedVariable = (DescribedVariable)searchable.getSearchableObject();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "variable name", describedVariable.getName(), describedVariable.getName());
        this.matchProperty(searchable, results, searchQuery, "variable value", describedVariable.getValue(), describedVariable.getName());
        this.matchProperty(searchable, results, searchQuery, "variable description", describedVariable.getDescription(), describedVariable.getName());
        return results;
    }
}

