/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.sampler.plugins.random;

import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerStoreBase;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.execution.sampler.plugins.random.RandomRowsExecutionDataSampler;

public class RandomRowsExecutionDataSamplerStore
extends ExecutionDataSamplerStoreBase<RandomRowsExecutionDataSamplerStore>
implements IExecutionDataSamplerStore {
    public static final String EXECUTION_DATA_SAMPLE_RANDOM_OUTPUT = "RandomOutput";
    private RandomRowsExecutionDataSampler dataSampler;

    public RandomRowsExecutionDataSamplerStore(RandomRowsExecutionDataSampler dataSampler, ExecutionDataSamplerMeta samplerMeta, IRowMeta rowMeta, List<Object[]> rows, int maxRows) {
        super(samplerMeta, rowMeta, rows, maxRows);
        this.dataSampler = dataSampler;
    }

    public RandomRowsExecutionDataSamplerStore(RandomRowsExecutionDataSampler dataSampler, ExecutionDataSamplerMeta samplerMeta) {
        this(dataSampler, samplerMeta, null, null, 0);
    }

    @Override
    public void init(IVariables variables, IRowMeta inputRowMeta, IRowMeta outputRowMeta) {
        super.init(variables, inputRowMeta, outputRowMeta);
        this.maxRows = Const.toInt((String)variables.resolve(this.dataSampler.getSampleSize()), (int)0);
    }

    @Override
    public RandomRowsExecutionDataSamplerStore getStore() {
        return this;
    }

    @Override
    public Map<String, RowBuffer> getSamples() {
        return Map.of(this.getKeyForStore(EXECUTION_DATA_SAMPLE_RANDOM_OUTPUT, this.samplerMeta), new RowBuffer(this.rowMeta, this.rows));
    }

    @Override
    public Map<String, ExecutionDataSetMeta> getSamplesMetadata() {
        String setKey = this.getKeyForStore(EXECUTION_DATA_SAMPLE_RANDOM_OUTPUT, this.samplerMeta);
        String description = "Random rows of " + this.getSamplerMeta().getTransformName() + "." + this.getSamplerMeta().getCopyNr();
        ExecutionDataSetMeta meta = new ExecutionDataSetMeta(setKey, this.samplerMeta.getLogChannelId(), this.samplerMeta.getTransformName(), this.samplerMeta.getCopyNr(), description);
        return Map.of(setKey, meta);
    }

    public RandomRowsExecutionDataSampler getDataSampler() {
        return this.dataSampler;
    }

    public void setDataSampler(RandomRowsExecutionDataSampler dataSampler) {
        this.dataSampler = dataSampler;
    }

    @Override
    public ExecutionDataSamplerMeta getSamplerMeta() {
        return this.samplerMeta;
    }
}

