/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import java.io.IOException;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.spark.structuredstreaming.translation.SparkTransformOverrides;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TranslationContext;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipelineTranslator
extends Pipeline.PipelineVisitor.Defaults {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineTranslator.class);
    protected TranslationContext translationContext;

    public static void replaceTransforms(Pipeline pipeline, StreamingOptions options) {
        pipeline.replaceAll(SparkTransformOverrides.getDefaultOverrides(options.isStreaming()));
    }

    public static void detectTranslationMode(Pipeline pipeline, StreamingOptions options) {
        TranslationModeDetector detector = new TranslationModeDetector();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)detector);
        if (detector.getTranslationMode().equals((Object)TranslationMode.STREAMING)) {
            options.setStreaming(true);
        }
    }

    protected abstract <InT extends PInput, OutT extends POutput, TransformT extends PTransform<InT, OutT>> @Nullable TransformTranslator<InT, OutT, TransformT> getTransformTranslator(@Nullable TransformT var1);

    private <InT extends PInput, OutT extends POutput, TransformT extends PTransform<InT, OutT>> void applyTransformTranslator(TransformHierarchy.Node node, TransformT transform, TransformTranslator<InT, OutT, TransformT> transformTranslator) {
        AppliedPTransform appliedTransform = node.toAppliedPTransform(this.getPipeline());
        try {
            transformTranslator.translate(transform, appliedTransform, this.translationContext);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void translate(Pipeline pipeline) {
        LOG.debug("starting translation of the pipeline using {}", (Object)((Object)((Object)this)).getClass().getName());
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)this);
    }

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        PTransform transform = node.getTransform();
        TransformTranslator transformTranslator = this.getTransformTranslator(transform);
        if (transformTranslator != null) {
            LOG.info("Translating composite: {}", (Object)node.getFullName());
            this.applyTransformTranslator(node, transform, transformTranslator);
            return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
        }
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        LOG.info("Translating primitive: {}", (Object)node.getFullName());
        PTransform transform = node.getTransform();
        TransformTranslator transformTranslator = this.getTransformTranslator(transform);
        if (transformTranslator == null) {
            String transformUrn = PTransformTranslation.urnForTransform((PTransform)node.getTransform());
            throw new UnsupportedOperationException("The transform " + transformUrn + " is currently not supported.");
        }
        this.applyTransformTranslator(node, transform, transformTranslator);
    }

    public TranslationContext getTranslationContext() {
        return this.translationContext;
    }

    private static class TranslationModeDetector
    extends Pipeline.PipelineVisitor.Defaults {
        private static final Logger LOG = LoggerFactory.getLogger(TranslationModeDetector.class);
        private TranslationMode translationMode;

        TranslationModeDetector(TranslationMode defaultMode) {
            this.translationMode = defaultMode;
        }

        TranslationModeDetector() {
            this(TranslationMode.BATCH);
        }

        TranslationMode getTranslationMode() {
            return this.translationMode;
        }

        public void visitValue(PValue value, TransformHierarchy.Node producer) {
            if (this.translationMode.equals((Object)TranslationMode.BATCH) && value instanceof PCollection && ((PCollection)value).isBounded() == PCollection.IsBounded.UNBOUNDED) {
                LOG.info("Found unbounded PCollection {}. Switching to streaming execution.", (Object)value.getName());
                this.translationMode = TranslationMode.STREAMING;
            }
        }
    }

    private static enum TranslationMode {
        BATCH,
        STREAMING;

    }
}

