/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis.serde;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.beam.sdk.io.kinesis.serde.AwsModule;

public class AwsSerializableUtils {
    public static String serialize(AWSCredentialsProvider awsCredentialsProvider) {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return om.writeValueAsString((Object)awsCredentialsProvider);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("AwsCredentialsProvider can not be serialized to Json", e);
        }
    }

    public static AWSCredentialsProvider deserialize(String awsCredentialsProviderSerialized) {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return (AWSCredentialsProvider)om.readValue(awsCredentialsProviderSerialized, AWSCredentialsProvider.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("AwsCredentialsProvider can not be deserialized from Json", e);
        }
    }
}

