/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.execution.builder;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.neo4j.execution.builder.BaseCypherBuilder;

public class CypherQueryBuilder
extends BaseCypherBuilder {
    private CypherQueryBuilder() {
        this.cypher.append("MATCH");
    }

    public static CypherQueryBuilder of() {
        return new CypherQueryBuilder();
    }

    public CypherQueryBuilder withLabelAndKey(String nodeAlias, String label, String key, Object keyValue) {
        this.cypher.append("(").append(nodeAlias).append(":").append(label).append(" {").append(key).append(" : $").append(key).append(" }) ");
        this.parameters.put(key, keyValue);
        return this;
    }

    public CypherQueryBuilder withLabelAndKeys(String nodeAlias, String label, Map<String, Object> keyValueMap) {
        this.cypher.append("(").append(nodeAlias).append(":").append(label).append(" {");
        boolean firstKey = true;
        for (String key : keyValueMap.keySet()) {
            String param = nodeAlias + "_" + key;
            Object value = keyValueMap.get(key);
            if (firstKey) {
                firstKey = false;
            } else {
                this.cypher.append(", ");
            }
            this.cypher.append(key).append(" : $").append(param);
            this.parameters.put(param, value);
        }
        this.cypher.append(" }) ");
        return this;
    }

    public CypherQueryBuilder withLabelWithoutKey(String nodeAlias, String label) {
        this.cypher.append("(").append(nodeAlias).append(":").append(label).append(") ");
        return this;
    }

    public CypherQueryBuilder withReturnValues(String nodeAlias, String ... properties) {
        for (String property : properties) {
            this.withReturnValue(nodeAlias, property, null);
        }
        return this;
    }

    protected CypherQueryBuilder withReturnValue(String nodeAlias, String property, String asName) {
        if (this.firstReturn) {
            this.firstReturn = false;
            this.cypher.append("RETURN ");
        } else {
            this.cypher.append(", ");
        }
        this.cypher.append(nodeAlias).append(".").append(property).append(" ");
        if (StringUtils.isNotEmpty((String)asName)) {
            this.cypher.append("as ").append(asName).append(" ");
        }
        return this;
    }

    public CypherQueryBuilder withWhereIsNull(String nodeAlias, String property) {
        this.cypher.append("WHERE ").append(nodeAlias).append(".").append(property).append(" IS NULL ");
        return this;
    }

    public CypherQueryBuilder withLimit(int limit) {
        if (limit > 0) {
            this.cypher.append("LIMIT ").append(limit).append(" ");
        }
        return this;
    }

    public CypherQueryBuilder withOrderBy(String nodeAlias, String property, boolean ascending) {
        this.cypher.append("ORDER BY ").append(nodeAlias).append(".").append(property).append(" ").append(ascending ? " " : "DESC ");
        return this;
    }

    public CypherQueryBuilder withMatch(String nodeAlias, String nodeLabel, Map<String, Object> nodeKeys) {
        this.cypher.append("MATCH(").append(nodeAlias).append(":").append(nodeLabel).append(" {");
        boolean firstKey = true;
        for (String otherKey : nodeKeys.keySet()) {
            if (firstKey) {
                firstKey = false;
            } else {
                this.cypher.append(", ");
            }
            String parameter = nodeAlias + "_" + otherKey;
            Object value = nodeKeys.get(otherKey);
            this.cypher.append(otherKey).append(" : $").append(parameter);
            this.parameters.put(parameter, value);
        }
        this.cypher.append(" }) ");
        return this;
    }

    public CypherQueryBuilder withRelationship(String alias1, String alias2, String relationshipLabel) {
        this.cypher.append("MATCH(").append(alias1).append(")-[rel:").append(relationshipLabel).append("]->(").append(alias2).append(") ");
        return this;
    }
}

