/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTable1202;
import com.ibm.as400.access.ConvTable1208;
import com.ibm.as400.access.ConvTableAsciiMap;
import com.ibm.as400.access.ConvTableBidiMap;
import com.ibm.as400.access.ConvTableDoubleMap;
import com.ibm.as400.access.ConvTableJavaMap;
import com.ibm.as400.access.ConvTableMixedMap;
import com.ibm.as400.access.ConvTableSingleMap;
import com.ibm.as400.access.ConvTableUnicodeBigMap;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.Trace;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class ConvTableReader
extends InputStreamReader {
    private BufferedInputStream is_ = null;
    private int ccsid_ = -1;
    private ConvTable table_ = null;
    private BidiConversionProperties properties_ = new BidiConversionProperties();
    static final int DB_MODE = 1;
    static final int SB_MODE = 2;
    private int mode_ = 2;
    private static final int SB_TABLE = 10;
    private static final int DB_TABLE = 11;
    private static final int MB_TABLE = 12;
    private static final int JV_TABLE = 13;
    private static final int UTF8_TABLE = 14;
    private int tableType_ = 10;
    private char[] cache_ = new char[1024];
    private byte[] b_cache_ = new byte[2562];
    private boolean isCachedByte_ = false;
    private byte cachedByte_ = 0;
    private byte[] leftovers = new byte[3];
    private int leftoverCount = 0;
    private int nextRead_ = 0;
    private int nextWrite_ = 0;
    boolean isXML_ = false;
    private boolean isFirstRead_ = true;

    public ConvTableReader(InputStream inputStream) throws UnsupportedEncodingException {
        super(inputStream);
        this.is_ = new BufferedInputStream(inputStream);
        this.initializeCcsid();
        this.initializeTable();
    }

    public ConvTableReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        super(inputStream, string);
        this.is_ = new BufferedInputStream(inputStream);
        this.initializeCcsid();
        this.initializeTable();
    }

    public ConvTableReader(InputStream inputStream, int n) throws UnsupportedEncodingException {
        super(inputStream);
        if (n < 0 || n > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n);
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.is_ = new BufferedInputStream(inputStream);
        this.ccsid_ = n;
        this.initializeTable();
    }

    public ConvTableReader(InputStream inputStream, int n, boolean bl) throws UnsupportedEncodingException {
        this(inputStream, n);
        this.isXML_ = bl;
    }

    public ConvTableReader(InputStream inputStream, int n, int n2) throws UnsupportedEncodingException {
        this(inputStream, n, new BidiConversionProperties(n2));
    }

    public ConvTableReader(InputStream inputStream, int n, int n2, boolean bl) throws UnsupportedEncodingException {
        this(inputStream, n, new BidiConversionProperties(n2));
        this.isXML_ = bl;
    }

    public ConvTableReader(InputStream inputStream, int n, BidiConversionProperties bidiConversionProperties) throws UnsupportedEncodingException {
        super(inputStream);
        if (n < 0 || n > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n);
            throw new ExtendedIllegalArgumentException("ccsid", 4);
        }
        this.is_ = new BufferedInputStream(inputStream);
        this.ccsid_ = n;
        this.properties_ = bidiConversionProperties;
        this.initializeTable();
    }

    public ConvTableReader(InputStream inputStream, int n, int n2, int n3) throws UnsupportedEncodingException {
        this(inputStream, n, n2);
        if (n3 < 1) {
            Trace.log(2, "Value of parameter 'cacheSize' is not valid:", n3);
            throw new ExtendedIllegalArgumentException("cacheSize", 4);
        }
        this.cache_ = new char[n3];
        this.b_cache_ = new byte[(n3 * 5 + 3) / 2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.table_ == null) {
                return;
            }
            this.table_ = null;
            this.cache_ = null;
            this.b_cache_ = null;
            super.close();
            this.is_.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillCache() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            this.checkOpen();
            if (this.nextRead_ >= this.nextWrite_) {
                int n2;
                int n3 = 0;
                if (Trace.traceOn_) {
                    Trace.log(5, "Filling cache for reader " + this.ccsid_ + "/" + this.tableType_ + " [" + this.toString() + "]: " + this.nextRead_ + "," + this.nextWrite_ + "," + this.cache_.length);
                }
                if (this.tableType_ == 10 || this.tableType_ == 13) {
                    n3 = this.is_.read(this.b_cache_, 0, this.cache_.length);
                } else if (this.tableType_ == 11) {
                    if (this.isCachedByte_) {
                        n3 = this.is_.read(this.b_cache_, 1, this.cache_.length - 1);
                        if (n3 == -1) {
                            if (Trace.traceOn_) {
                                Trace.log(5, "Cache not filled, end of stream reached.");
                            }
                            return false;
                        }
                        this.b_cache_[0] = this.cachedByte_;
                        if (n3 % 2 == 0) {
                            this.cachedByte_ = this.b_cache_[n3];
                            this.isCachedByte_ = true;
                        } else {
                            this.isCachedByte_ = false;
                        }
                    } else {
                        n3 = this.is_.read(this.b_cache_, 0, this.cache_.length);
                        if (n3 > 0 && n3 % 2 != 0) {
                            this.cachedByte_ = this.b_cache_[n3 - 1];
                            this.isCachedByte_ = true;
                            --n3;
                        }
                    }
                } else if (this.tableType_ == 12) {
                    n2 = 0;
                    if (this.mode_ == 1) {
                        this.b_cache_[n3++] = 14;
                        if (this.isCachedByte_) {
                            this.b_cache_[n3++] = this.cachedByte_;
                            this.isCachedByte_ = false;
                        }
                    }
                    if ((n = this.is_.read(this.b_cache_, n3, this.cache_.length - 1)) == -1 && n3 == 0) {
                        if (Trace.traceOn_) {
                            Trace.log(5, "Cache not filled, end of stream reached.");
                        }
                        return false;
                    }
                    if (n > -1) {
                        n3 += n;
                    }
                    boolean bl = false;
                    for (int i = 0; i < n3; ++i) {
                        if (this.mode_ == 2) {
                            if (this.b_cache_[i] != 14) continue;
                            this.mode_ = 1;
                            continue;
                        }
                        if (this.b_cache_[i] == 15) {
                            this.mode_ = 2;
                            bl = false;
                            continue;
                        }
                        bl = !bl;
                    }
                    if (this.mode_ == 1) {
                        if (bl) {
                            this.cachedByte_ = this.b_cache_[--n3];
                            this.isCachedByte_ = true;
                        }
                        this.b_cache_[n3++] = 15;
                    }
                } else if (this.tableType_ == 14) {
                    if (this.leftoverCount > 0) {
                        System.arraycopy(this.leftovers, 0, this.b_cache_, 0, this.leftoverCount);
                        n3 = this.is_.read(this.b_cache_, this.leftoverCount, this.cache_.length - this.leftoverCount);
                        n3 = n3 == -1 ? this.leftoverCount : n3 + this.leftoverCount;
                    } else {
                        n3 = this.is_.read(this.b_cache_, 0, this.cache_.length);
                    }
                    if (n3 == -1) {
                        if (Trace.traceOn_) {
                            Trace.log(5, "Cache not filled, end of stream reached.");
                        }
                        return false;
                    }
                    if (n3 < this.cache_.length) {
                        this.leftoverCount = 0;
                    } else {
                        n2 = this.cache_.length - 1;
                        if ((this.b_cache_[n2] & 0x80) == 0) {
                            this.leftoverCount = 0;
                        } else if ((this.b_cache_[n2] & 0xC0) == 192) {
                            this.leftoverCount = 1;
                            this.leftovers[0] = this.b_cache_[n2];
                        } else if (n2 > 0 && (this.b_cache_[n2 - 1] & 0xE0) == 224) {
                            this.leftoverCount = 2;
                            System.arraycopy(this.b_cache_, n2 - 1, this.leftovers, 0, this.leftoverCount);
                        } else if (n2 > 1 && (this.b_cache_[n2 - 2] & 0xF0) == 240) {
                            this.leftoverCount = 3;
                            System.arraycopy(this.b_cache_, n2 - 2, this.leftovers, 0, this.leftoverCount);
                        } else {
                            this.leftoverCount = 0;
                        }
                        n3 -= this.leftoverCount;
                    }
                } else {
                    if (Trace.traceOn_) {
                        Trace.log(2, "Unknown table type during conversion: " + this.tableType_);
                    }
                    throw new InternalErrorException(6);
                }
                if (n3 == -1) {
                    if (Trace.traceOn_) {
                        Trace.log(5, "Cache not filled, end of stream reached.");
                    }
                    return false;
                }
                String string = this.table_.byteArrayToString(this.b_cache_, 0, n3, this.properties_);
                this.nextWrite_ = string.length();
                string.getChars(0, this.nextWrite_, this.cache_, 0);
                this.nextRead_ = 0;
                if (Trace.traceOn_) {
                    Trace.log(5, "Filled cache for reader: " + this.nextRead_ + "," + this.nextWrite_ + "," + this.cache_.length, ConvTable.dumpCharArray(this.cache_, this.nextWrite_));
                }
            }
            if (this.nextRead_ >= this.nextWrite_) {
                return this.fillCache();
            }
            if (this.isXML_ && this.isFirstRead_) {
                String string = String.copyValueOf(this.cache_, 0, this.nextWrite_);
                int n4 = string.length();
                try {
                    string = JDUtilities.stripXMLDeclaration(string);
                    string.getChars(0, string.length(), this.cache_, 0);
                    n = n4 - string.length();
                    this.nextWrite_ -= n;
                    this.isFirstRead_ = false;
                }
                catch (SQLException sQLException) {
                    this.nextRead_ = 0;
                    this.nextWrite_ = 6;
                    this.fillCache();
                }
            }
            return true;
        }
    }

    public int getByteCacheSize() {
        return this.b_cache_.length;
    }

    public int getCacheSize() {
        return this.cache_.length;
    }

    public int getCcsid() {
        return this.ccsid_;
    }

    public String getEncoding() {
        if (this.ccsid_ == -1) {
            return super.getEncoding();
        }
        return ConversionMaps.ccsidToEncoding(this.ccsid_);
    }

    private void initializeCcsid() {
        String string;
        String string2 = super.getEncoding();
        if (string2 != null && (string = ConversionMaps.encodingToCcsidString(string2)) != null) {
            this.ccsid_ = Integer.parseInt(string);
        }
    }

    private void initializeTable() throws UnsupportedEncodingException {
        try {
            this.table_ = this.ccsid_ == -1 ? ConvTable.getTable(this.getEncoding()) : ConvTable.getTable(this.ccsid_, null);
            if (this.table_ instanceof ConvTableSingleMap || this.table_ instanceof ConvTableBidiMap || this.table_ instanceof ConvTableAsciiMap) {
                this.tableType_ = 10;
            } else if (this.table_ instanceof ConvTableDoubleMap || this.table_ instanceof ConvTable1202 || this.table_ instanceof ConvTableUnicodeBigMap) {
                this.tableType_ = 11;
            } else if (this.table_ instanceof ConvTableMixedMap) {
                this.tableType_ = 12;
            } else if (this.table_ instanceof ConvTableJavaMap) {
                this.tableType_ = 13;
            } else if (this.table_ instanceof ConvTable1208) {
                this.tableType_ = 14;
            } else {
                if (Trace.traceOn_) {
                    Trace.log(2, "Unknown conversion table type: " + this.table_.getClass());
                }
                throw new InternalErrorException(6);
            }
            if (Trace.traceOn_) {
                Trace.log(5, "ConvTableReader initialized with CCSID " + this.ccsid_ + ", encoding " + this.getEncoding() + ", string type " + this.properties_.getBidiStringType() + ", and table type " + this.tableType_ + ".");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.traceOn_) {
                Trace.log(2, "The specified CCSID is not supported in the current JVM nor by the Toolbox: " + this.ccsid_ + "/" + this.getEncoding(), (Throwable)unsupportedEncodingException);
            }
            throw unsupportedEncodingException;
        }
    }

    private void checkOpen() throws IOException {
        if (this.table_ == null) {
            this.is_.available();
            throw new IOException();
        }
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.fillCache()) {
                return this.cache_[this.nextRead_++];
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray) throws IOException {
        if (cArray == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        if (cArray.length == 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.fillCache()) {
                int n = cArray.length > this.nextWrite_ - this.nextRead_ ? this.nextWrite_ - this.nextRead_ : cArray.length;
                System.arraycopy(this.cache_, this.nextRead_, cArray, 0, n);
                this.nextRead_ += n;
                return n;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            Trace.log(2, "Parameter 'buffer' is null.");
            throw new NullPointerException("buffer");
        }
        if (n2 == 0) {
            return 0;
        }
        if (n < 0 || n >= cArray.length) {
            Trace.log(2, "Value of parameter 'offset' is not valid:", n);
            throw new ExtendedIllegalArgumentException("offset", 4);
        }
        if (n2 < 0 || n + n2 > cArray.length) {
            Trace.log(2, "Specified length would overflow buffer:", n2);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.fillCache()) {
                int n3 = n2 > this.nextWrite_ - this.nextRead_ ? this.nextWrite_ - this.nextRead_ : n2;
                System.arraycopy(this.cache_, this.nextRead_, cArray, n, n3);
                this.nextRead_ += n3;
                return n3;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(int n) throws IOException {
        if (n < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (n == 0) {
            return "";
        }
        Object object = this.lock;
        synchronized (object) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.fillCache()) {
                while (this.fillCache() && stringBuffer.length() < n) {
                    stringBuffer.append(this.cache_, this.nextRead_++, 1);
                }
                return stringBuffer.toString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.table_ == null) {
                return super.ready();
            }
            return this.nextRead_ < this.nextWrite_ || this.is_.available() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        if (l < 0L) {
            Trace.log(2, "Value of parameter 'length' is not valid: " + l);
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (l == 0L) {
            return 0L;
        }
        long l2 = 0L;
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            char[] cArray = new char[l < (long)this.cache_.length ? (int)l : this.cache_.length];
            int n = this.read(cArray);
            l2 += (long)n;
            while (n > 0 && l2 < l) {
                n = this.read(cArray);
                if (n <= 0) continue;
                l2 += (long)n;
            }
            if (this.isXML_ && (long)n != l2 && l > l2 - (long)n) {
                this.nextRead_ = (int)(l - (l2 - (long)n));
            }
        }
        return l2;
    }
}

