/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.access.Trace;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class MicroDataInputStream {
    DataInputStream in_;

    public MicroDataInputStream(InputStream inputStream) throws IOException {
        this.in_ = new DataInputStream(inputStream);
    }

    public boolean readBoolean() throws IOException {
        boolean bl = this.in_.readBoolean();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + bl);
        }
        return bl;
    }

    public byte readByte() throws IOException {
        byte by = this.in_.readByte();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + by);
        }
        return by;
    }

    public void readBytes(byte[] byArray) throws IOException {
        this.in_.readFully(byArray);
        if (Trace.isTraceOn()) {
            Trace.log(6, "  " + Thread.currentThread().getName() + " in > ", byArray);
        }
    }

    public double readDouble() throws IOException {
        double d = this.in_.readDouble();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + d);
        }
        return d;
    }

    public float readFloat() throws IOException {
        float f = this.in_.readFloat();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + f);
        }
        return f;
    }

    public int readInt() throws IOException {
        int n = this.in_.readInt();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + Integer.toHexString(n));
        }
        return n;
    }

    public long readLong() throws IOException {
        long l = this.in_.readLong();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + l);
        }
        return l;
    }

    public short readShort() throws IOException {
        short s = this.in_.readShort();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + s);
        }
        return s;
    }

    public String readString() throws IOException {
        return this.readUTF();
    }

    public String readUTF() throws IOException {
        String string = this.in_.readUTF();
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " in  > " + string);
        }
        return string;
    }

    public int skipBytes(int n) throws IOException {
        return this.in_.skipBytes(n);
    }
}

