/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.KeyedWorkItems;
import org.apache.beam.runners.core.OutputAndTimeBoundedSplittableProcessElementInvoker;
import org.apache.beam.runners.core.OutputWindowedValue;
import org.apache.beam.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.runners.core.SplittableProcessElementInvoker;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.TimerInternalsFactory;
import org.apache.beam.runners.flink.translation.wrappers.streaming.DoFnOperator;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplittableDoFnOperator<InputT, OutputT, RestrictionT>
extends DoFnOperator<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> {
    private static final Logger LOG = LoggerFactory.getLogger(SplittableDoFnOperator.class);
    private transient ScheduledExecutorService executorService;

    public SplittableDoFnOperator(DoFn<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> doFn, String stepName, Coder<WindowedValue<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>>> windowedInputCoder, Map<TupleTag<?>, Coder<?>> outputCoders, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, DoFnOperator.OutputManagerFactory<OutputT> outputManagerFactory, WindowingStrategy<?, ?> windowingStrategy, Map<Integer, PCollectionView<?>> sideInputTagMapping, Collection<PCollectionView<?>> sideInputs, PipelineOptions options, Coder<?> keyCoder, KeySelector<WindowedValue<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>>, ?> keySelector) {
        super(doFn, stepName, windowedInputCoder, outputCoders, mainOutputTag, additionalOutputTags, outputManagerFactory, windowingStrategy, sideInputTagMapping, sideInputs, options, keyCoder, keySelector, DoFnSchemaInformation.create(), Collections.emptyMap());
    }

    @Override
    protected DoFnRunner<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> createWrappingDoFnRunner(DoFnRunner<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> wrappedRunner, StepContext stepContext) {
        return wrappedRunner;
    }

    @Override
    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        Preconditions.checkState((boolean)(this.doFn instanceof SplittableParDoViaKeyedWorkItems.ProcessFn));
        StateInternalsFactory stateInternalsFactory = key -> this.keyedStateInternals;
        TimerInternalsFactory timerInternalsFactory = key -> this.timerInternals;
        this.executorService = Executors.newSingleThreadScheduledExecutor(Executors.defaultThreadFactory());
        ((SplittableParDoViaKeyedWorkItems.ProcessFn)this.doFn).setStateInternalsFactory(stateInternalsFactory);
        ((SplittableParDoViaKeyedWorkItems.ProcessFn)this.doFn).setTimerInternalsFactory(timerInternalsFactory);
        ((SplittableParDoViaKeyedWorkItems.ProcessFn)this.doFn).setSideInputReader(this.sideInputReader);
        ((SplittableParDoViaKeyedWorkItems.ProcessFn)this.doFn).setProcessElementInvoker((SplittableProcessElementInvoker)new OutputAndTimeBoundedSplittableProcessElementInvoker(this.doFn, this.serializedOptions.get(), new OutputWindowedValue<OutputT>(){

            public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
                SplittableDoFnOperator.this.outputManager.output(SplittableDoFnOperator.this.mainOutputTag, WindowedValue.of(output, (Instant)timestamp, windows, (PaneInfo)pane));
            }

            public <AdditionalOutputT> void outputWindowedValue(TupleTag<AdditionalOutputT> tag, AdditionalOutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
                SplittableDoFnOperator.this.outputManager.output(tag, WindowedValue.of(output, (Instant)timestamp, windows, (PaneInfo)pane));
            }
        }, this.sideInputReader, this.executorService, 10000, Duration.standardSeconds((long)10L), this::getBundleFinalizer));
    }

    @Override
    protected void fireTimer(TimerInternals.TimerData timer) {
        this.timerInternals.onFiredOrDeletedTimer(timer);
        if (timer.getDomain().equals((Object)TimeDomain.EVENT_TIME)) {
            return;
        }
        this.doFnRunner.processElement(WindowedValue.valueInGlobalWindow((Object)KeyedWorkItems.timersWorkItem((Object)((byte[])this.keyedStateInternals.getKey()), Collections.singletonList(timer))));
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.executorService.shutdown();
        long shutdownTimeout = Duration.standardSeconds((long)10L).getMillis();
        try {
            if (!this.executorService.awaitTermination(shutdownTimeout, TimeUnit.MILLISECONDS)) {
                LOG.debug("The scheduled executor service did not properly terminate. Shutting it down now.");
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Could not properly await the termination of the scheduled executor service.", (Throwable)e);
            this.executorService.shutdownNow();
        }
    }
}

