/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;

public final class CertificateTool {
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";

    public static void saveX509Cert(String certStr, File certFile) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(certFile));){
            writer.write(BEGIN_CERT);
            writer.newLine();
            writer.write(certStr);
            writer.newLine();
            writer.write(END_CERT);
            writer.newLine();
        }
    }

    public static void saveX509Cert(Certificate cert, File certFile) throws GeneralSecurityException, IOException {
        CertificateTool.saveX509Cert(new Certificate[]{cert}, certFile);
    }

    public static void saveX509Cert(Certificate[] certs, File certFile) throws GeneralSecurityException, IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(certFile));){
            for (Certificate cert : certs) {
                String certStr = Base64.getEncoder().encodeToString(cert.getEncoded()).replaceAll("(.{64})", "$1\n");
                writer.write(BEGIN_CERT);
                writer.newLine();
                writer.write(certStr);
                writer.newLine();
                writer.write(END_CERT);
                writer.newLine();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadX509Cert(File certFile, KeyStore keyStore) throws GeneralSecurityException, IOException {
        Throwable throwable = null;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(certFile));){
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            int certCount = 0;
            while (inputStream.available() > 0) {
                try {
                    Certificate cert = certFactory.generateCertificate(inputStream);
                    CertificateTool.loadX509Cert(cert, "neo4j.javadriver.trustedcert." + ++certCount, keyStore);
                }
                catch (CertificateException e) {
                    if (e.getCause() != null && e.getCause().getMessage().equals("Empty input")) {
                        if (inputStream == null) return;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                                return;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            return;
                        } else {
                            inputStream.close();
                        }
                        return;
                    }
                    try {
                        throw new IOException("Failed to load certificate from `" + certFile.getAbsolutePath() + "`: " + certCount + " : " + e.getMessage(), e);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                        return;
                    }
                }
            }
        }
    }

    public static void loadX509Cert(X509Certificate[] certificates, KeyStore keyStore) throws GeneralSecurityException, IOException {
        for (int i = 0; i < certificates.length; ++i) {
            CertificateTool.loadX509Cert(certificates[i], "neo4j.javadriver.trustedcert." + i, keyStore);
        }
    }

    public static void loadX509Cert(Certificate cert, String certAlias, KeyStore keyStore) throws KeyStoreException {
        keyStore.setCertificateEntry(certAlias, cert);
    }

    public static String X509CertToString(String cert) {
        String cert64CharPerLine = cert.replaceAll("(.{64})", "$1\n");
        return "-----BEGIN CERTIFICATE-----\n" + cert64CharPerLine + "\n" + END_CERT + "\n";
    }

    private CertificateTool() {
    }
}

