/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.profiling.ExecutionDataProfile;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEnginePluginType;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.GuiCompositeWidgetsAdapter;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="This dialog allows you to configure the various pipeline run configurations")
public class PipelineRunConfigurationEditor
extends MetadataEditor<PipelineRunConfiguration> {
    private static final Class<?> PKG = PipelineRunConfigurationEditor.class;
    private final PipelineRunConfiguration runConfiguration;
    private final PipelineRunConfiguration workingConfiguration;
    private Text wName;
    private Text wDescription;
    private Button wDefault;
    private MetaSelectionLine<ExecutionInfoLocation> wExecutionInfoLocation;
    private MetaSelectionLine<ExecutionDataProfile> wProfile;
    private ComboVar wPluginType;
    private Composite wPluginSpecificComp;
    private ScrolledComposite wsPluginSpecificComp;
    private GuiCompositeWidgets guiCompositeWidgets;
    private Map<String, IPipelineEngineRunConfiguration> metaMap;
    private TableView wVariables;
    private AtomicBoolean busyChangingPluginType = new AtomicBoolean(false);

    public PipelineRunConfigurationEditor(HopGui hopGui, MetadataManager<PipelineRunConfiguration> manager, PipelineRunConfiguration runConfiguration) {
        super(hopGui, manager, runConfiguration);
        this.runConfiguration = runConfiguration;
        this.workingConfiguration = new PipelineRunConfiguration(runConfiguration);
        this.metaMap = this.populateMetaMap();
        if (this.workingConfiguration.getEngineRunConfiguration() != null) {
            this.metaMap.put(this.workingConfiguration.getEngineRunConfiguration().getEnginePluginName(), this.workingConfiguration.getEngineRunConfiguration());
        }
    }

    private Map<String, IPipelineEngineRunConfiguration> populateMetaMap() {
        this.metaMap = new HashMap<String, IPipelineEngineRunConfiguration>();
        List plugins = PluginRegistry.getInstance().getPlugins(PipelineEnginePluginType.class);
        for (IPlugin plugin : plugins) {
            try {
                IPipelineEngine engine = (IPipelineEngine)PluginRegistry.getInstance().loadClass(plugin, IPipelineEngine.class);
                IPipelineEngineRunConfiguration engineRunConfiguration = engine.createDefaultPipelineEngineRunConfiguration();
                engineRunConfiguration.setEnginePluginId(plugin.getIds()[0]);
                engineRunConfiguration.setEnginePluginName(plugin.getName());
                this.metaMap.put(engineRunConfiguration.getEnginePluginName(), engineRunConfiguration);
            }
            catch (Exception e) {
                HopGui.getInstance().getLog().logError("Error instantiating pipeline run configuration plugin", (Throwable)e);
            }
        }
        return this.metaMap;
    }

    @Override
    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = props.getMargin();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        CTabFolder wTabFolder = new CTabFolder(parent, 2048);
        PropsUi.setLook((Widget)wTabFolder);
        CTabItem wMainTab = new CTabItem(wTabFolder, 0);
        wMainTab.setFont(GuiResource.getInstance().getFontDefault());
        wMainTab.setText(BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.MainTab.TabTitle", (String[])new String[0]));
        wMainTab.setImage(GuiResource.getInstance().getImageRun());
        ScrolledComposite wMainSComp = new ScrolledComposite((Composite)wTabFolder, 768);
        wMainSComp.setLayout((Layout)new FillLayout());
        Composite wMainComp = new Composite((Composite)wMainSComp, 0);
        PropsUi.setLook((Widget)wMainComp);
        FormLayout mainLayout = new FormLayout();
        mainLayout.marginWidth = 3;
        mainLayout.marginHeight = 3;
        wMainComp.setLayout((Layout)mainLayout);
        Label wlName = new Label(wMainComp, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.label.name", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(wMainComp, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Object lastControl = this.wName;
        Label wlDescription = new Label(wMainComp, 131072);
        PropsUi.setLook((Widget)wlDescription);
        wlDescription.setText(BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.label.Description", (String[])new String[0]));
        FormData fdlDescription = new FormData();
        fdlDescription.top = new FormAttachment((Control)lastControl, margin);
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(middle, -margin);
        wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(wMainComp, 18436);
        PropsUi.setLook((Widget)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.top = new FormAttachment((Control)wlDescription, 0, 0x1000000);
        fdDescription.left = new FormAttachment(middle, 0);
        fdDescription.right = new FormAttachment(100, 0);
        this.wDescription.setLayoutData((Object)fdDescription);
        lastControl = this.wDescription;
        Label wlDefault = new Label(wMainComp, 131072);
        PropsUi.setLook((Widget)wlDefault);
        wlDefault.setText(BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.label.Default", (String[])new String[0]));
        FormData fdlDefault = new FormData();
        fdlDefault.top = new FormAttachment((Control)lastControl, margin);
        fdlDefault.left = new FormAttachment(0, 0);
        fdlDefault.right = new FormAttachment(middle, -margin);
        wlDefault.setLayoutData((Object)fdlDefault);
        this.wDefault = new Button(wMainComp, 16416);
        PropsUi.setLook((Widget)this.wDefault);
        FormData fdDefault = new FormData();
        fdDefault.top = new FormAttachment((Control)wlDefault, 0, 0x1000000);
        fdDefault.left = new FormAttachment(middle, 0);
        fdDefault.right = new FormAttachment(100, 0);
        this.wDefault.setLayoutData((Object)fdDefault);
        lastControl = wlDefault;
        this.wExecutionInfoLocation = new MetaSelectionLine<ExecutionInfoLocation>(this.manager.getVariables(), this.manager.getMetadataProvider(), ExecutionInfoLocation.class, wMainComp, 18436, BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.label.ExecutionInfoLocation", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.toolTip.ExecutionInfoLocation", (String[])new String[0]));
        PropsUi.setLook(this.wExecutionInfoLocation);
        FormData fdExecutionInfoLocation = new FormData();
        fdExecutionInfoLocation.top = new FormAttachment((Control)lastControl, margin);
        fdExecutionInfoLocation.left = new FormAttachment(0, 0);
        fdExecutionInfoLocation.right = new FormAttachment(100, 0);
        this.wExecutionInfoLocation.setLayoutData(fdExecutionInfoLocation);
        lastControl = this.wExecutionInfoLocation;
        this.wProfile = new MetaSelectionLine<ExecutionDataProfile>(this.manager.getVariables(), this.manager.getMetadataProvider(), ExecutionDataProfile.class, wMainComp, 18432, BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.label.ExecutionDataProfile", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.toolTip.ExecutionDataProfile", (String[])new String[0]));
        FormData fdProfile = new FormData();
        fdProfile.top = new FormAttachment((Control)lastControl, margin);
        fdProfile.left = new FormAttachment(0, 0);
        fdProfile.right = new FormAttachment(100, 0);
        this.wProfile.setLayoutData(fdProfile);
        lastControl = this.wProfile;
        Label wlPluginType = new Label(wMainComp, 131072);
        PropsUi.setLook((Widget)wlPluginType);
        wlPluginType.setText(BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.label.EngineType", (String[])new String[0]));
        FormData fdlPluginType = new FormData();
        fdlPluginType.top = new FormAttachment((Control)lastControl, margin);
        fdlPluginType.left = new FormAttachment(0, 0);
        fdlPluginType.right = new FormAttachment(middle, -margin);
        wlPluginType.setLayoutData((Object)fdlPluginType);
        this.wPluginType = new ComboVar(this.manager.getVariables(), wMainComp, 18436);
        PropsUi.setLook((Widget)this.wPluginType);
        this.wPluginType.setItems(this.getPluginTypes());
        FormData fdPluginType = new FormData();
        fdPluginType.top = new FormAttachment((Control)wlPluginType, 0, 0x1000000);
        fdPluginType.left = new FormAttachment(middle, 0);
        fdPluginType.right = new FormAttachment(100, 0);
        this.wPluginType.setLayoutData(fdPluginType);
        lastControl = this.wPluginType;
        this.wsPluginSpecificComp = new ScrolledComposite(wMainComp, 768);
        this.wsPluginSpecificComp.setLayout((Layout)new FormLayout());
        FormData fdsPluginSpecificComp = new FormData();
        fdsPluginSpecificComp.left = new FormAttachment(0, 0);
        fdsPluginSpecificComp.top = new FormAttachment((Control)lastControl, margin);
        fdsPluginSpecificComp.right = new FormAttachment(100, 0);
        fdsPluginSpecificComp.bottom = new FormAttachment(100, 0);
        this.wsPluginSpecificComp.setLayoutData((Object)fdsPluginSpecificComp);
        this.wPluginSpecificComp = new Composite((Composite)this.wsPluginSpecificComp, 8);
        PropsUi.setLook((Widget)this.wPluginSpecificComp);
        this.wPluginSpecificComp.setLayout((Layout)new FormLayout());
        FormData fdPluginSpecificComp = new FormData();
        fdPluginSpecificComp.left = new FormAttachment(0, 0);
        fdPluginSpecificComp.right = new FormAttachment(100, 0);
        fdPluginSpecificComp.top = new FormAttachment((Control)lastControl, margin);
        fdPluginSpecificComp.bottom = new FormAttachment(100, 0);
        this.wPluginSpecificComp.setLayoutData((Object)fdPluginSpecificComp);
        this.wsPluginSpecificComp.setContent((Control)this.wPluginSpecificComp);
        this.addGuiCompositeWidgets();
        this.wPluginSpecificComp.layout();
        this.wsPluginSpecificComp.setExpandHorizontal(true);
        this.wsPluginSpecificComp.setExpandVertical(true);
        Rectangle bounds = this.wPluginSpecificComp.getBounds();
        this.wsPluginSpecificComp.setMinWidth(bounds.width);
        this.wsPluginSpecificComp.setMinHeight(bounds.height);
        FormData fdMainComp = new FormData();
        fdMainComp.left = new FormAttachment(0, 0);
        fdMainComp.top = new FormAttachment(0, 0);
        fdMainComp.right = new FormAttachment(100, 0);
        fdMainComp.bottom = new FormAttachment(100, 0);
        wMainComp.setLayoutData((Object)fdMainComp);
        wMainComp.pack();
        Rectangle mainBounds = wMainComp.getBounds();
        wMainSComp.setContent((Control)wMainComp);
        wMainSComp.setExpandHorizontal(true);
        wMainSComp.setExpandVertical(true);
        wMainSComp.setMinWidth(mainBounds.width);
        wMainSComp.setMinHeight(mainBounds.height);
        wMainTab.setControl((Control)wMainSComp);
        CTabItem wVariablesTab = new CTabItem(wTabFolder, 0);
        wVariablesTab.setFont(GuiResource.getInstance().getFontDefault());
        wVariablesTab.setText(BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.VariablesTab.TabTitle", (String[])new String[0]));
        wVariablesTab.setImage(GuiResource.getInstance().getImageVariable());
        ScrolledComposite wVariablesSComp = new ScrolledComposite((Composite)wTabFolder, 768);
        wVariablesSComp.setLayout((Layout)new FillLayout());
        Composite wVariablesComp = new Composite((Composite)wVariablesSComp, 0);
        PropsUi.setLook((Widget)wVariablesComp);
        FormLayout variablesLayout = new FormLayout();
        variablesLayout.marginWidth = 0;
        variablesLayout.marginHeight = 0;
        wVariablesComp.setLayout((Layout)variablesLayout);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.Variables.Column.Name", (String[])new String[0]), 1), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.Variables.Column.Value", (String[])new String[0]), 1), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineRunConfigurationDialog.Variables.Column.Description", (String[])new String[0]), 1)};
        this.wVariables = new TableView(this.manager.getVariables(), wVariablesComp, 0, columns, this.workingConfiguration.getConfigurationVariables().size(), e -> this.setChanged(), props);
        PropsUi.setLook((Widget)this.wVariables);
        FormData fdVariables = new FormData();
        fdVariables.top = new FormAttachment(0, 0);
        fdVariables.left = new FormAttachment(0, 0);
        fdVariables.bottom = new FormAttachment(100, 0);
        fdVariables.right = new FormAttachment(100, 0);
        this.wVariables.setLayoutData(fdVariables);
        FormData fdVariablesComp = new FormData();
        fdVariablesComp.left = new FormAttachment(0, 0);
        fdVariablesComp.top = new FormAttachment(0, 0);
        fdVariablesComp.right = new FormAttachment(100, 0);
        fdVariablesComp.bottom = new FormAttachment(100, 0);
        wVariablesComp.setLayoutData((Object)fdVariablesComp);
        wVariablesComp.pack();
        Rectangle variablesBound = wVariablesComp.getBounds();
        wVariablesSComp.setContent((Control)wVariablesComp);
        wVariablesSComp.setExpandHorizontal(true);
        wVariablesSComp.setExpandVertical(true);
        wVariablesSComp.setMinWidth(variablesBound.width);
        wVariablesSComp.setMinHeight(variablesBound.height);
        wVariablesTab.setControl((Control)wVariablesSComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, -margin * 2);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.setWidgetsContent();
        this.resetChanged();
        wTabFolder.setSelection(0);
        Listener modifyListener = e -> this.setChanged();
        this.wName.addListener(24, modifyListener);
        this.wDescription.addListener(24, modifyListener);
        this.wDefault.addListener(13, modifyListener);
        this.wPluginType.addListener(24, modifyListener);
        this.wPluginType.addListener(24, e -> this.changeConnectionType());
        this.wProfile.getComboWidget().addListener(24, modifyListener);
        this.wProfile.getComboWidget().addListener(13, modifyListener);
        this.wExecutionInfoLocation.getComboWidget().addListener(24, modifyListener);
        this.wExecutionInfoLocation.getComboWidget().addListener(13, modifyListener);
    }

    private void addGuiCompositeWidgets() {
        for (Control child : this.wPluginSpecificComp.getChildren()) {
            child.dispose();
        }
        if (this.workingConfiguration.getEngineRunConfiguration() != null) {
            this.guiCompositeWidgets = new GuiCompositeWidgets(this.manager.getVariables());
            this.guiCompositeWidgets.createCompositeWidgets(this.workingConfiguration.getEngineRunConfiguration(), null, this.wPluginSpecificComp, "PipelineRunConfiguration-PluginSpecific-Options", null);
            this.guiCompositeWidgets.setWidgetsListener(new GuiCompositeWidgetsAdapter(){

                @Override
                public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                    PipelineRunConfigurationEditor.this.setChanged();
                }
            });
        }
    }

    private void changeConnectionType() {
        if (this.busyChangingPluginType.get()) {
            return;
        }
        this.busyChangingPluginType.set(true);
        this.getWidgetsContent(this.workingConfiguration);
        if (this.workingConfiguration.getEngineRunConfiguration() != null) {
            this.metaMap.put(this.workingConfiguration.getEngineRunConfiguration().getEnginePluginName(), this.workingConfiguration.getEngineRunConfiguration());
        }
        this.changeWorkingEngineConfiguration(this.workingConfiguration);
        this.addGuiCompositeWidgets();
        this.setWidgetsContent();
        this.busyChangingPluginType.set(false);
    }

    @Override
    public void save() throws HopException {
        this.changeWorkingEngineConfiguration(this.runConfiguration);
        super.save();
    }

    @Override
    public void setWidgetsContent() {
        this.wName.setText(Const.NVL((String)this.workingConfiguration.getName(), (String)""));
        this.wDescription.setText(Const.NVL((String)this.workingConfiguration.getDescription(), (String)""));
        this.wDefault.setSelection(this.workingConfiguration.isDefaultSelection());
        try {
            this.wExecutionInfoLocation.fillItems();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error getting the list of execution information locations", e);
        }
        this.wExecutionInfoLocation.setText(Const.NVL((String)this.workingConfiguration.getExecutionInfoLocationName(), (String)""));
        if (this.workingConfiguration.getEngineRunConfiguration() != null) {
            this.wPluginType.setText(Const.NVL((String)this.workingConfiguration.getEngineRunConfiguration().getEnginePluginName(), (String)""));
            this.guiCompositeWidgets.setWidgetsContents(this.workingConfiguration.getEngineRunConfiguration(), this.wPluginSpecificComp, "PipelineRunConfiguration-PluginSpecific-Options");
        } else {
            this.wPluginType.setText("");
        }
        try {
            this.wProfile.fillItems();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error retrieving execution info profile metadata", e);
        }
        this.wProfile.setText(Const.NVL((String)this.runConfiguration.getExecutionDataProfileName(), (String)""));
        for (int i = 0; i < this.workingConfiguration.getConfigurationVariables().size(); ++i) {
            DescribedVariable vvd = (DescribedVariable)this.workingConfiguration.getConfigurationVariables().get(i);
            TableItem item = this.wVariables.table.getItem(i);
            int col = 1;
            item.setText(col++, Const.NVL((String)vvd.getName(), (String)""));
            item.setText(col++, Const.NVL((String)vvd.getValue(), (String)""));
            item.setText(col++, Const.NVL((String)vvd.getDescription(), (String)""));
        }
        this.wVariables.setRowNums();
        this.wVariables.optWidth(true);
    }

    @Override
    public void getWidgetsContent(PipelineRunConfiguration meta) {
        meta.setName(this.wName.getText());
        meta.setDescription(this.wDescription.getText());
        meta.setDefaultSelection(this.wDefault.getSelection());
        meta.setExecutionInfoLocationName(this.wExecutionInfoLocation.getText());
        if (meta.getEngineRunConfiguration() != null && this.guiCompositeWidgets != null && !this.guiCompositeWidgets.getWidgetsMap().isEmpty()) {
            this.guiCompositeWidgets.getWidgetsContents(meta.getEngineRunConfiguration(), "PipelineRunConfiguration-PluginSpecific-Options");
        }
        meta.setExecutionDataProfileName(this.wProfile.getText());
        meta.getConfigurationVariables().clear();
        for (int i = 0; i < this.wVariables.nrNonEmpty(); ++i) {
            TableItem item = this.wVariables.getNonEmpty(i);
            String name = item.getText(1);
            String value = item.getText(2);
            String description = item.getText(3);
            meta.getConfigurationVariables().add(new DescribedVariable(name, value, description));
        }
    }

    private void changeWorkingEngineConfiguration(PipelineRunConfiguration meta) {
        String pluginName = this.wPluginType.getText();
        IPipelineEngineRunConfiguration engineRunConfiguration = this.metaMap.get(pluginName);
        if (engineRunConfiguration != null) {
            meta.setEngineRunConfiguration(engineRunConfiguration);
        } else {
            meta.setEngineRunConfiguration(null);
        }
    }

    private String[] getPluginTypes() {
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(PipelineEnginePluginType.class);
        String[] types = new String[plugins.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ((IPlugin)plugins.get(i)).getName();
        }
        Arrays.sort(types, String.CASE_INSENSITIVE_ORDER);
        return types;
    }
}

