/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

public class MapControlClientPool
implements ControlClientPool {
    private final Map<String, CompletableFuture<InstructionRequestHandler>> clients = Maps.newConcurrentMap();

    public static MapControlClientPool create() {
        return new MapControlClientPool();
    }

    private MapControlClientPool() {
    }

    @Override
    public ControlClientPool.Source getSource() {
        return this::getClient;
    }

    @Override
    public ControlClientPool.Sink getSink() {
        return this::putClient;
    }

    private void putClient(String workerId, InstructionRequestHandler client) {
        CompletableFuture future = this.clients.computeIfAbsent(workerId, MapControlClientPool::createClientFuture);
        boolean success = future.complete(client);
        if (!success) {
            throw new IllegalStateException(String.format("Control client for worker id %s failed to compete", workerId));
        }
    }

    private InstructionRequestHandler getClient(String workerId, Duration timeout) throws ExecutionException, InterruptedException, TimeoutException {
        CompletableFuture future = this.clients.computeIfAbsent(workerId, MapControlClientPool::createClientFuture);
        future.get(timeout.getSeconds(), TimeUnit.SECONDS);
        InstructionRequestHandler client = (InstructionRequestHandler)future.get();
        this.clients.remove(workerId);
        return client;
    }

    private static CompletableFuture<InstructionRequestHandler> createClientFuture(String unused) {
        return new CompletableFuture<InstructionRequestHandler>();
    }
}

