/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MetadataCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReadableFileCoder
extends StructuredCoder<FileIO.ReadableFile> {
    private final Coder<MatchResult.Metadata> metadataCoder;

    public static ReadableFileCoder of(Coder<MatchResult.Metadata> metadataCoder) {
        return new ReadableFileCoder(metadataCoder);
    }

    public static ReadableFileCoder of() {
        return new ReadableFileCoder(MetadataCoder.of());
    }

    public Coder<MatchResult.Metadata> getMetadataCoder() {
        return this.metadataCoder;
    }

    private ReadableFileCoder(Coder<MatchResult.Metadata> metadataCoder) {
        this.metadataCoder = metadataCoder;
    }

    @Override
    public void encode(FileIO.ReadableFile value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws CoderException, IOException {
        this.getMetadataCoder().encode(value.getMetadata(), outStream);
        VarIntCoder.of().encode(value.getCompression().ordinal(), outStream);
    }

    @Override
    public FileIO.ReadableFile decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws CoderException, IOException {
        MatchResult.Metadata metadata = this.getMetadataCoder().decode(inStream);
        Compression compression = Compression.values()[VarIntCoder.of().decode(inStream)];
        return new FileIO.ReadableFile(metadata, compression);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<? extends Coder<?>> getCoderArguments() {
        return Collections.singletonList(this.metadataCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        if (!this.getMetadataCoder().equals(MetadataCoder.of())) {
            ReadableFileCoder.verifyDeterministic(this, "Metadata coder must be deterministic", this.getMetadataCoder());
        }
    }
}

