/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import com.google.auto.value.AutoValue;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.beam.repackaged.direct_java.runners.local.StructuralKey;
import org.apache.beam.runners.direct.AutoValue_ImmutableListBundleFactory_CommittedImmutableListBundle;
import org.apache.beam.runners.direct.BundleFactory;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class ImmutableListBundleFactory
implements BundleFactory {
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableListBundleFactory FACTORY = new ImmutableListBundleFactory();

    public static @UnknownKeyFor @NonNull @Initialized ImmutableListBundleFactory create() {
        return FACTORY;
    }

    private ImmutableListBundleFactory() {
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createRootBundle() {
        return UncommittedImmutableListBundle.create(null, StructuralKey.empty());
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createBundle(@UnknownKeyFor @NonNull @Initialized PCollection<T> output) {
        return UncommittedImmutableListBundle.create(output, StructuralKey.empty());
    }

    @Override
    public <K, T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createKeyedBundle(@UnknownKeyFor @NonNull @Initialized StructuralKey<K> key, @UnknownKeyFor @NonNull @Initialized PCollection<T> output) {
        return UncommittedImmutableListBundle.create(output, key);
    }

    private static @UnknownKeyFor @NonNull @Initialized Instant minTimestamp(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> elements) {
        Instant minTs = BoundedWindow.TIMESTAMP_MAX_VALUE;
        for (WindowedValue<?> element : elements) {
            if (!element.getTimestamp().isBefore((ReadableInstant)minTs)) continue;
            minTs = element.getTimestamp();
        }
        return minTs;
    }

    @AutoValue
    static abstract class CommittedImmutableListBundle<@UnknownKeyFor T>
    implements CommittedBundle<T> {
        CommittedImmutableListBundle() {
        }

        public static <T> @UnknownKeyFor @NonNull @Initialized CommittedImmutableListBundle<T> create(@Nullable @UnknownKeyFor @Initialized PCollection<T> pcollection, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> committedElements, @UnknownKeyFor @NonNull @Initialized Instant minElementTimestamp, @UnknownKeyFor @NonNull @Initialized Instant synchronizedCompletionTime) {
            return new AutoValue_ImmutableListBundleFactory_CommittedImmutableListBundle<T>(pcollection, key, committedElements, minElementTimestamp, synchronizedCompletionTime);
        }

        @Override
        @Nonnull
        public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> iterator() {
            return this.getElements().iterator();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CommittedBundle<T> withElements(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> elements) {
            return CommittedImmutableListBundle.create(this.getPCollection(), this.getKey(), ImmutableList.copyOf(elements), ImmutableListBundleFactory.minTimestamp(elements), this.getSynchronizedProcessingOutputWatermark());
        }

        @Pure
        public final @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return System.identityHashCode(this);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public final @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            return this == obj;
        }
    }

    private static final class UncommittedImmutableListBundle<@UnknownKeyFor T>
    implements UncommittedBundle<T> {
        private final @UnknownKeyFor @NonNull @Initialized PCollection<T> pcollection;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key;
        private @UnknownKeyFor @NonNull @Initialized boolean committed = false;
        private // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ImmutableList.Builder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> elements;
        private @UnknownKeyFor @NonNull @Initialized Instant minSoFar = BoundedWindow.TIMESTAMP_MAX_VALUE;

        public static <T> @UnknownKeyFor @NonNull @Initialized UncommittedImmutableListBundle<T> create(@UnknownKeyFor @NonNull @Initialized PCollection<T> pcollection, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key) {
            return new UncommittedImmutableListBundle<T>(pcollection, key);
        }

        private UncommittedImmutableListBundle(@UnknownKeyFor @NonNull @Initialized PCollection<T> pcollection, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key) {
            this.pcollection = pcollection;
            this.key = key;
            this.elements = ImmutableList.builder();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> getPCollection() {
            return this.pcollection;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized UncommittedImmutableListBundle<T> add(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> element) {
            Preconditions.checkState((!this.committed ? 1 : 0) != 0, (String)"Can't add element %s to committed bundle in PCollection %s", element, this.pcollection);
            Preconditions.checkArgument((boolean)element.getTimestamp().isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE), (String)"Can't add an element past the end of time (%s), got timestamp %s", (Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)element.getTimestamp());
            this.elements.add(element);
            if (element.getTimestamp().isBefore((ReadableInstant)this.minSoFar)) {
                this.minSoFar = element.getTimestamp();
            }
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized CommittedBundle<T> commit(@UnknownKeyFor @NonNull @Initialized Instant synchronizedCompletionTime) {
            Preconditions.checkState((!this.committed ? 1 : 0) != 0, (String)"Can't commit already committed bundle %s", (Object)this);
            this.committed = true;
            ImmutableList committedElements = this.elements.build();
            return CommittedImmutableListBundle.create(this.pcollection, this.key, committedElements, this.minSoFar, synchronizedCompletionTime);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("Key", (Object)this.key.toString()).add("PCollection", this.pcollection).add("Elements", (Object)this.elements.build()).toString();
        }
    }
}

