/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.duckdb.DuckDBArray;
import org.duckdb.DuckDBColumnType;
import org.duckdb.DuckDBColumnTypeMetaData;
import org.duckdb.DuckDBResultSet;
import org.duckdb.DuckDBStruct;
import org.duckdb.JdbcUtils;
import org.duckdb.JsonNode;
import org.duckdb.StatementReturnType;

public class DuckDBResultSetMetaData
implements ResultSetMetaData {
    protected int param_count;
    protected int column_count;
    protected String[] column_names;
    protected String[] column_types_string;
    protected String[] column_types_details;
    protected DuckDBColumnType[] column_types;
    protected DuckDBColumnTypeMetaData[] column_types_meta;
    protected final StatementReturnType return_type;

    public DuckDBResultSetMetaData(int n, int n2, String[] stringArray, String[] stringArray2, String[] stringArray3, String string) {
        this.param_count = n;
        this.column_count = n2;
        this.column_names = stringArray;
        this.return_type = StatementReturnType.valueOf(string);
        this.column_types_string = stringArray2;
        this.column_types_details = stringArray3;
        ArrayList<DuckDBColumnType> arrayList = new ArrayList<DuckDBColumnType>(n2);
        ArrayList<DuckDBColumnTypeMetaData> arrayList2 = new ArrayList<DuckDBColumnTypeMetaData>(n2);
        for (String string2 : this.column_types_string) {
            arrayList.add(DuckDBResultSetMetaData.TypeNameToType(string2));
        }
        this.column_types = new DuckDBColumnType[n2];
        this.column_types = arrayList.toArray(this.column_types);
        for (String string2 : this.column_types_details) {
            if (DuckDBResultSetMetaData.TypeNameToType(string2) == DuckDBColumnType.DECIMAL) {
                arrayList2.add(DuckDBColumnTypeMetaData.parseColumnTypeMetadata(string2));
                continue;
            }
            arrayList2.add(null);
        }
        this.column_types_meta = arrayList2.toArray(new DuckDBColumnTypeMetaData[n2]);
    }

    public static DuckDBColumnType TypeNameToType(String string) {
        if (string.endsWith("[]")) {
            return DuckDBColumnType.LIST;
        }
        if (string.startsWith("DECIMAL")) {
            return DuckDBColumnType.DECIMAL;
        }
        if (string.equals("TIME WITH TIME ZONE")) {
            return DuckDBColumnType.TIME_WITH_TIME_ZONE;
        }
        if (string.equals("TIMESTAMP WITH TIME ZONE")) {
            return DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE;
        }
        if (string.startsWith("STRUCT")) {
            return DuckDBColumnType.STRUCT;
        }
        if (string.startsWith("MAP")) {
            return DuckDBColumnType.MAP;
        }
        if (string.startsWith("UNION")) {
            return DuckDBColumnType.UNION;
        }
        try {
            return DuckDBColumnType.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DuckDBColumnType.UNKNOWN;
        }
    }

    public StatementReturnType getReturnType() {
        return this.return_type;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.column_count;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        if (n > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return this.column_names[n - 1];
    }

    public static int type_to_int(DuckDBColumnType duckDBColumnType) throws SQLException {
        switch (duckDBColumnType) {
            case BOOLEAN: {
                return 16;
            }
            case TINYINT: {
                return -6;
            }
            case SMALLINT: {
                return 5;
            }
            case INTEGER: {
                return 4;
            }
            case BIGINT: {
                return -5;
            }
            case LIST: {
                return 2003;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 8;
            }
            case DECIMAL: {
                return 3;
            }
            case VARCHAR: {
                return 12;
            }
            case TIME: {
                return 92;
            }
            case DATE: {
                return 91;
            }
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: 
            case TIMESTAMP: 
            case TIMESTAMP_NS: {
                return 93;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return 2014;
            }
            case BLOB: {
                return 2004;
            }
        }
        return 2000;
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        if (n > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return DuckDBResultSetMetaData.type_to_int(this.column_types[n - 1]);
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        switch (this.column_types[n - 1]) {
            case BOOLEAN: {
                return Boolean.class.getName();
            }
            case TINYINT: {
                return Byte.class.getName();
            }
            case SMALLINT: 
            case UTINYINT: {
                return Short.class.getName();
            }
            case INTEGER: 
            case USMALLINT: {
                return Integer.class.getName();
            }
            case BIGINT: 
            case UINTEGER: {
                return Long.class.getName();
            }
            case HUGEINT: 
            case UBIGINT: {
                return BigInteger.class.getName();
            }
            case FLOAT: {
                return Float.class.getName();
            }
            case DOUBLE: {
                return Double.class.getName();
            }
            case DECIMAL: {
                return BigDecimal.class.getName();
            }
            case TIME: {
                return LocalTime.class.getName();
            }
            case TIME_WITH_TIME_ZONE: {
                return OffsetTime.class.getName();
            }
            case DATE: {
                return LocalDate.class.getName();
            }
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: 
            case TIMESTAMP: 
            case TIMESTAMP_NS: {
                return Timestamp.class.getName();
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return OffsetDateTime.class.getName();
            }
            case JSON: {
                return JsonNode.class.getName();
            }
            case BLOB: {
                return DuckDBResultSet.DuckDBBlobResult.class.getName();
            }
            case UUID: {
                return UUID.class.getName();
            }
            case LIST: {
                return DuckDBArray.class.getName();
            }
            case MAP: {
                return HashMap.class.getName();
            }
            case STRUCT: {
                return DuckDBStruct.class.getName();
            }
        }
        return String.class.getName();
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        if (n > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return this.column_types_string[n - 1];
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        return true;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return 1;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        return 0;
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        DuckDBColumnTypeMetaData duckDBColumnTypeMetaData = this.typeMetadataForColumn(n);
        if (duckDBColumnTypeMetaData == null) {
            return 0;
        }
        return duckDBColumnTypeMetaData.width;
    }

    @Override
    public int getScale(int n) throws SQLException {
        DuckDBColumnTypeMetaData duckDBColumnTypeMetaData = this.typeMetadataForColumn(n);
        if (duckDBColumnTypeMetaData == null) {
            return 0;
        }
        return duckDBColumnTypeMetaData.scale;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return JdbcUtils.unwrap(this, clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    private DuckDBColumnTypeMetaData typeMetadataForColumn(int n) throws SQLException {
        if (n > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return this.column_types_meta[n - 1];
    }
}

