/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.util.Locale;

public class ExecutionEnvironment {
    private ExecutionEnvironment() {
    }

    public static int getBestGuessAS400Ccsid() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Getting best guess CCSID.");
        }
        try {
            String ccsidString = SystemProperties.getProperty("com.ibm.as400.access.AS400.fallbackCCSID");
            if (ccsidString != null) {
                Trace.log(1, "Fallback CCSID specified:", ccsidString);
                try {
                    return Integer.parseInt(ccsidString);
                }
                catch (NumberFormatException e) {
                    Trace.log(2, "Ignoring invalid fallback CCSID value.", (Throwable)e);
                }
            } else {
                Trace.log(1, "Fallback CCSID not specified, using Locale.");
            }
            String localeString = Locale.getDefault().toString();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Default Locale: " + localeString);
            }
            while (true) {
                if ((ccsidString = (String)ConversionMaps.localeCcsidMap_.get(localeString)) != null) {
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "Best guess for Locale: " + localeString + ", CCSID: " + ccsidString);
                    }
                    return Integer.parseInt(ccsidString);
                }
                localeString = localeString.substring(0, localeString.lastIndexOf(95));
            }
        }
        catch (Exception e) {
            Trace.log(1, "Exception taking best guess CCSID, default to 37:", (Throwable)e);
            return 37;
        }
    }

    public static int getCcsid() {
        return 13488;
    }

    static int getCcsid(String encoding) {
        return Integer.parseInt((String)ConversionMaps.encodingCcsid_.get(encoding));
    }

    static String getEncoding(int ccsid) {
        return (String)ConversionMaps.ccsidEncoding_.get(String.valueOf(ccsid));
    }

    public static String getNlv(Locale locale) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Getting NLV.");
        }
        try {
            String localeString = locale.toString();
            if (Trace.isTraceOn()) {
                Trace.log(1, "NLV Locale: " + localeString);
            }
            while (true) {
                String nlvString;
                if ((nlvString = (String)ConversionMaps.localeNlvMap_.get(localeString)) != null) {
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "NLV for Locale: " + localeString + ", NLV: " + nlvString);
                    }
                    return nlvString;
                }
                localeString = localeString.substring(0, localeString.lastIndexOf(95));
            }
        }
        catch (Exception e) {
            Trace.log(1, "Exception getting NLV, default to 2924:", (Throwable)e);
            return "2924";
        }
    }
}

