/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Copyright;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.ToolboxLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Trace
implements Runnable {
    private static final String CLASSNAME = "com.ibm.as400.access.Trace";
    private static final int DEFAULT_MONITOR_PORT = 55555;
    static boolean traceOn_;
    static boolean traceInfo_;
    static boolean traceWarning_;
    static boolean traceError_;
    static boolean traceDiagnostic_;
    static boolean traceDatastream_;
    static boolean traceConversion_;
    static boolean traceProxy_;
    static boolean traceThread_;
    static boolean traceJDBC_;
    static boolean tracePCML_;
    static boolean showChars_;
    private static int mostRecentTracingChange_;
    private static final int TURNED_TRACE_ON = 1;
    private static final int TURNED_TRACE_OFF = 2;
    private static boolean aTraceCategoryHasBeenActivated_;
    private static String fileName_;
    private static PrintWriter destination_;
    private static boolean userSpecifiedDestination_;
    private static Hashtable printWriterHash_;
    private static Hashtable fileNameHash_;
    private static SimpleDateFormat timeStampFormatter_;
    public static final int DATASTREAM = 0;
    public static final int DIAGNOSTIC = 1;
    public static final int ERROR = 2;
    public static final int INFORMATION = 3;
    public static final int WARNING = 4;
    public static final int CONVERSION = 5;
    public static final int PROXY = 6;
    public static final int PCML = 7;
    public static final int JDBC = 8;
    public static final String LOGGER_NAME = "com.ibm.as400.access";
    private static ToolboxLogger logger_;
    private static boolean firstCallToFindLogger_;
    private static PrintWriter globalPw;
    private static final String[] HEX_BYTE_ARRAY;
    private static final String[] ASCII_BYTE_ARRAY;
    private static final String[] EBCDIC_BYTE_ARRAY;

    private Trace() {
    }

    public static String getFileName() {
        return fileName_;
    }

    public static String getFileName(Object component) {
        if (component == null) {
            throw new NullPointerException("component");
        }
        return (String)fileNameHash_.get(component);
    }

    public static PrintWriter getPrintWriter() {
        return destination_;
    }

    public static PrintWriter getPrintWriter(Object component) {
        if (component == null) {
            throw new NullPointerException("component");
        }
        return (PrintWriter)printWriterHash_.get(component);
    }

    public static final boolean isTraceAllOn() {
        return traceConversion_ && traceDatastream_ && traceDiagnostic_ && traceError_ && traceInfo_ && traceProxy_ && traceWarning_ && traceThread_ && traceJDBC_ && tracePCML_;
    }

    public static final boolean isTraceConversionOn() {
        return traceConversion_;
    }

    public static final boolean isTraceDatastreamOn() {
        return traceDatastream_;
    }

    public static final boolean isTraceDiagnosticOn() {
        return traceDiagnostic_;
    }

    public static final boolean isTraceErrorOn() {
        return traceError_;
    }

    public static final boolean isTraceInformationOn() {
        return traceInfo_;
    }

    public static final boolean isTraceJDBCOn() {
        return traceJDBC_;
    }

    public static final boolean isTraceOn() {
        return traceOn_;
    }

    public static final boolean isTraceOn(int category) {
        switch (category) {
            case 0: {
                return traceDatastream_;
            }
            case 1: {
                return traceDiagnostic_;
            }
            case 2: {
                return traceError_;
            }
            case 3: {
                return traceInfo_;
            }
            case 4: {
                return traceWarning_;
            }
            case 5: {
                return traceConversion_;
            }
            case 6: {
                return traceProxy_;
            }
            case 7: {
                return tracePCML_;
            }
            case 8: {
                return traceJDBC_;
            }
        }
        return false;
    }

    public static final boolean isTracePCMLOn() {
        return tracePCML_;
    }

    public static final boolean isTraceProxyOn() {
        return traceProxy_;
    }

    public static final boolean isTraceThreadOn() {
        return traceThread_;
    }

    public static final boolean isTraceWarningOn() {
        return traceWarning_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadTraceProperties() {
        String enabled;
        block11: {
            String file;
            String showCharsString;
            String categories0 = SystemProperties.getProperty("com.ibm.as400.access.Trace.categories");
            if (categories0 != null) {
                Trace.setTraceCategories(categories0);
                if (traceOn_) {
                    Trace.log(4, "Incorrect tracing property name specified: com.ibm.as400.access.Trace.categories");
                }
            }
            String categories = SystemProperties.getProperty("com.ibm.as400.access.Trace.category");
            if (categories0 == null || categories != null) {
                Trace.setTraceCategories(categories);
            }
            if ((showCharsString = SystemProperties.getProperty("com.ibm.as400.access.Trace.showChars")) != null && showCharsString.equalsIgnoreCase("true")) {
                showChars_ = true;
            }
            if ((file = SystemProperties.getProperty("com.ibm.as400.access.Trace.file")) != null) {
                try {
                    Trace.setFileName(file);
                    PrintWriter printWriter = destination_;
                    synchronized (printWriter) {
                        destination_.println("Toolbox for Java - JDBC 4.0 " + Copyright.version);
                        destination_.println(Trace.getJvmInfo());
                        destination_.println();
                        Trace.logLoadPath(CLASSNAME, Trace.activeTraceCategory());
                    }
                }
                catch (IOException e) {
                    if (!Trace.isTraceOn()) break block11;
                    String msg = "Trace file not valid: " + file;
                    System.err.println(msg);
                    e.printStackTrace(System.err);
                    Trace.log(4, msg, (Throwable)e);
                }
            }
        }
        if ((enabled = SystemProperties.getProperty("com.ibm.as400.access.Trace.enabled")) != null) {
            boolean value;
            traceOn_ = value = Boolean.valueOf(enabled).booleanValue();
        }
        Trace.startTraceMonitorIfNeeded();
        Trace.logLoadPath(CLASSNAME);
    }

    static final void logLoadPath(String className) {
        Trace.logLoadPath(className, -1);
    }

    static final void logLoadPath(String className, int category) {
        if ((category > -1 || traceDiagnostic_) && className != null) {
            String loadPath = null;
            try {
                String resourceName;
                URL resourceUrl;
                ClassLoader loader = Class.forName(className).getClassLoader();
                if (loader != null && (resourceUrl = loader.getResource(resourceName = className.replace('.', '/') + ".class")) != null) {
                    loadPath = resourceUrl.getPath();
                }
            }
            catch (Throwable t) {
                String message = "Unable to determine load path for class " + className;
                Trace.logData(null, 2, message, t);
            }
            String message = "Class " + className + " was loaded from " + loadPath;
            if (category > -1) {
                Trace.logData(null, category, message, null);
            } else {
                Trace.logData(null, 1, message, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logTimeStamp(Object component, PrintWriter pw) {
        if (component != null && component.toString() != null) {
            pw.print("[" + component.toString() + "]  ");
        }
        if (traceThread_) {
            pw.print(Thread.currentThread().toString());
            pw.print("  ");
        }
        SimpleDateFormat simpleDateFormat = timeStampFormatter_;
        synchronized (simpleDateFormat) {
            pw.print(timeStampFormatter_.format(new Date()));
        }
        pw.print("  ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logTimeStamp(Object component, StringBuffer buf) {
        if (component != null && component.toString() != null) {
            buf.append("[" + component.toString() + "]  ");
        }
        if (traceThread_) {
            buf.append(Thread.currentThread().toString());
            buf.append("  ");
        }
        SimpleDateFormat simpleDateFormat = timeStampFormatter_;
        synchronized (simpleDateFormat) {
            buf.append(timeStampFormatter_.format(new Date()));
        }
        buf.append("  ");
    }

    private static void logSource(Object source, StringBuffer buffer) {
        if (source == null) {
            return;
        }
        buffer.append('[');
        String simpleName = source.getClass().getName();
        int dotIndex = simpleName.lastIndexOf(46);
        if (dotIndex > 0) {
            simpleName = simpleName.substring(dotIndex + 1);
        }
        buffer.append(simpleName);
        buffer.append('@');
        buffer.append(source.hashCode());
        buffer.append("] ");
    }

    private static void logSource(Object source, PrintWriter writer) {
        if (source == null) {
            return;
        }
        writer.print('[');
        String simpleName = source.getClass().getName();
        int dotIndex = simpleName.lastIndexOf(46);
        if (dotIndex > 0) {
            simpleName = simpleName.substring(dotIndex + 1);
        }
        writer.print(simpleName);
        writer.print('@');
        writer.print(source.hashCode());
        writer.print("] ");
    }

    private static final void logData(Object component, int category, String message, Throwable e) {
        Trace.logData(component, category, null, message, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void logData(Object component, int category, Object source, String message, Throwable e) {
        if (traceOn_ && Trace.traceCategory(category) || Trace.findLogger() && logger_.isLoggable(category)) {
            if (message == null) {
                message = "(null)";
            }
            if (logger_ == null || userSpecifiedDestination_) {
                PrintWriter printWriter = destination_;
                synchronized (printWriter) {
                    if (component != null && Trace.getFileName(component) != null) {
                        Trace.logTimeStamp(component, destination_);
                        Trace.logSource(source, destination_);
                        destination_.println(message);
                    } else if (component == null) {
                        Trace.logTimeStamp(null, destination_);
                        Trace.logSource(source, destination_);
                        destination_.println(message);
                    }
                    if (e != null) {
                        e.printStackTrace(destination_);
                    } else if (category == 2) {
                        new Throwable().printStackTrace(destination_);
                    }
                }
                if (component != null) {
                    PrintWriter pw = (PrintWriter)printWriterHash_.get(component);
                    if (pw == null) {
                        if (globalPw == null) {
                            globalPw = new PrintWriter(System.out, true);
                        }
                        pw = globalPw;
                        printWriterHash_.put(component, pw);
                    }
                    PrintWriter printWriter2 = pw;
                    synchronized (printWriter2) {
                        Trace.logTimeStamp(component, pw);
                        Trace.logSource(source, pw);
                        pw.println(message);
                        if (e != null) {
                            e.printStackTrace(pw);
                        } else if (category == 2) {
                            new Throwable().printStackTrace(pw);
                        }
                    }
                }
            } else {
                StringBuffer buf = new StringBuffer();
                Trace.logTimeStamp(component, buf);
                Trace.logSource(source, buf);
                buf.append(message);
                if (e != null) {
                    logger_.log(category, buf.toString(), e);
                } else if (category == 2) {
                    logger_.log(category, buf.toString(), new Throwable());
                } else {
                    logger_.log(category, buf.toString());
                }
            }
        }
    }

    public static final void log(int category, String message) {
        Trace.logData(null, category, null, message, null);
    }

    public static final void log(int category, Object source, String message) {
        Trace.logData(null, category, source, message, null);
    }

    public static final void log(Object component, int category, String message) {
        Trace.logData(component, category, null, message, null);
    }

    public static final void log(Object component, int category, Object source, String message) {
        Trace.logData(component, category, source, message, null);
    }

    public static final void log(int category, String message, Throwable e) {
        Trace.logData(null, category, null, message, e);
    }

    public static final void log(int category, Object source, String message, Throwable e) {
        Trace.logData(null, category, source, message, e);
    }

    public static final void log(Object component, int category, String message, Throwable e) {
        Trace.logData(component, category, null, message, e);
    }

    public static final void log(int category, Throwable e) {
        if (e.getLocalizedMessage() == null) {
            Trace.log(category, "Exception does not contain a message.", e);
        } else {
            Trace.log(category, e.getLocalizedMessage(), e);
        }
    }

    public static final void log(Object component, int category, Throwable e) {
        if (e.getLocalizedMessage() == null) {
            Trace.log(component, category, "Exception does not contain a message.", e);
        } else {
            Trace.log(component, category, e.getLocalizedMessage(), e);
        }
    }

    public static final void log(int category, String message, int value) {
        if (message == null) {
            message = "(null)";
        }
        Trace.log(category, message + "  " + value);
    }

    public static final void log(int category, Object source, String message, int value) {
        if (message == null) {
            message = "(null)";
        }
        Trace.log(category, source, message + "  " + value);
    }

    public static final void log(int category, String message, String value) {
        if (message == null) {
            message = "(null)";
        }
        Trace.log(category, message + "  " + (value == null ? "(null)" : value));
    }

    public static final void log(Object component, int category, String message, int value) {
        if (message == null) {
            message = "(null)";
        }
        Trace.log(component, category, message + "  " + value);
    }

    static final void logSSL(int category, int sslCategory, int sslError, int sslInt1) {
        Trace.log(2, "An SSLException occurred, turn on DIAGNOSITC tracing to see the details.");
        Trace.log(category, "SSL Category: " + sslCategory);
        Trace.log(category, "SSL Error: " + sslError);
        Trace.log(category, "SSL Int1: " + sslInt1);
    }

    public static final void log(int category, String message, boolean value) {
        if (message == null) {
            message = "(null)";
        }
        Trace.log(category, message + "  " + value);
    }

    public static final void log(int category, Object source, String message, boolean value) {
        if (message == null) {
            message = "(null)";
        }
        Trace.log(category, source, message + "  " + value);
    }

    public static final void log(Object component, int category, String message, boolean value) {
        if (message == null) {
            message = "(null)";
        }
        Trace.log(component, category, message + "  " + value);
    }

    public static final void log(int category, String message, byte[] data) {
        if (data == null) {
            if (message == null) {
                message = "(null)";
            }
            Trace.log(category, message + "  (null)");
        } else {
            Trace.log(category, message, data, 0, data.length);
        }
    }

    public static final void log(int category, Object source, String message, byte[] data) {
        if (data == null) {
            if (message == null) {
                message = "(null)";
            }
            Trace.log(category, source, message + "  (null)");
        } else {
            Trace.log(category, source, message, data, 0, data.length);
        }
    }

    public static final void log(Object component, int category, String message, byte[] data) {
        if (data == null) {
            if (message == null) {
                message = "(null)";
            }
            Trace.log(component, category, message + "  (null)");
        } else {
            Trace.log(component, category, message, data, 0, data.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void log(int category, String message, byte[] data, int offset, int length) {
        if (traceOn_ && Trace.traceCategory(category) || Trace.findLogger() && logger_.isLoggable(category)) {
            if (logger_ == null || userSpecifiedDestination_) {
                PrintWriter printWriter = destination_;
                synchronized (printWriter) {
                    Trace.logTimeStamp(null, destination_);
                    if (message != null) {
                        destination_.println(message);
                    }
                    Trace.printByteArray(destination_, data, offset, length);
                    if (category == 2) {
                        new Throwable().printStackTrace(destination_);
                    }
                }
            } else {
                StringBuffer buf = new StringBuffer();
                Trace.logTimeStamp(null, buf);
                Trace.printByteArray(buf, data, offset, length);
                if (category == 2) {
                    logger_.log(category, buf.toString(), new Throwable());
                } else {
                    logger_.log(category, buf.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void log(int category, Object source, String message, byte[] data, int offset, int length) {
        if (traceOn_ && Trace.traceCategory(category) || Trace.findLogger() && logger_.isLoggable(category)) {
            if (logger_ == null || userSpecifiedDestination_) {
                PrintWriter printWriter = destination_;
                synchronized (printWriter) {
                    Trace.logTimeStamp(null, destination_);
                    Trace.logSource(source, destination_);
                    if (message != null) {
                        destination_.println(message);
                    }
                    Trace.printByteArray(destination_, data, offset, length);
                    if (category == 2) {
                        new Throwable().printStackTrace(destination_);
                    }
                }
            } else {
                StringBuffer buf = new StringBuffer();
                Trace.logTimeStamp(null, buf);
                Trace.logSource(source, buf);
                Trace.printByteArray(buf, data, offset, length);
                if (category == 2) {
                    logger_.log(category, buf.toString(), new Throwable());
                } else {
                    logger_.log(category, buf.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void log(Object component, int category, String message, byte[] data, int offset, int length) {
        if (message == null) {
            message = "(null)";
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (traceOn_ && Trace.traceCategory(category) || Trace.findLogger() && logger_.isLoggable(category)) {
            if (logger_ == null || userSpecifiedDestination_) {
                PrintWriter pw = (PrintWriter)printWriterHash_.get(component);
                if (pw == null) {
                    if (globalPw == null) {
                        globalPw = new PrintWriter(System.out, true);
                    }
                    pw = globalPw;
                    printWriterHash_.put(component, pw);
                }
                PrintWriter printWriter = pw;
                synchronized (printWriter) {
                    Trace.logTimeStamp(component, pw);
                    pw.println(message);
                    Trace.printByteArray(pw, data, offset, length);
                    if (category == 2) {
                        new Throwable().printStackTrace(pw);
                    }
                }
            }
            Trace.log(category, message, data, offset, length);
        }
    }

    static void printByteArray(PrintWriter pw, byte[] data, int offset, int length) {
        StringBuffer ebcdicInfo = null;
        StringBuffer asciiInfo = null;
        if (showChars_) {
            ebcdicInfo = new StringBuffer();
            asciiInfo = new StringBuffer();
        }
        if (data == null) {
            pw.println("(null)");
            return;
        }
        int i = 0;
        while (i < length) {
            pw.print(Trace.toHexString(data[offset]));
            pw.print(" ");
            if (ebcdicInfo != null && asciiInfo != null) {
                ebcdicInfo.append(Trace.toEbcdicString(data[offset]));
                asciiInfo.append(Trace.toAsciiString(data[offset]));
            }
            if ((i & 0xF) == 15) {
                if (ebcdicInfo != null && asciiInfo != null) {
                    pw.print(" | ");
                    pw.print(ebcdicInfo.toString());
                    pw.print(" | ");
                    pw.print(asciiInfo.toString());
                    pw.print(" |");
                    ebcdicInfo.setLength(0);
                    asciiInfo.setLength(0);
                }
                pw.println();
            }
            ++i;
            ++offset;
        }
        if ((length - 1 & 0xF) != 15) {
            if (ebcdicInfo != null && asciiInfo != null) {
                int extraPad;
                int i2;
                for (i2 = extraPad = length % 16; i2 < 16; ++i2) {
                    pw.print("   ");
                }
                pw.print(" | ");
                pw.print(ebcdicInfo.toString());
                for (i2 = extraPad; i2 < 16; ++i2) {
                    pw.print(" ");
                }
                pw.print(" | ");
                pw.print(asciiInfo.toString());
                for (i2 = extraPad; i2 < 16; ++i2) {
                    pw.print(" ");
                }
                pw.print(" |");
                ebcdicInfo.setLength(0);
                asciiInfo.setLength(0);
            }
            pw.println();
        }
    }

    static void printByteArray(StringBuffer buf, byte[] data) {
        Trace.printByteArray(buf, data, 0, data.length);
    }

    static void printByteArray(StringBuffer buf, byte[] data, int offset, int length) {
        if (data == null) {
            buf.append("(null)\n");
            return;
        }
        int i = 0;
        while (i < length) {
            buf.append(Trace.toHexString(data[offset]));
            buf.append(" ");
            if ((i & 0xF) == 15) {
                buf.append("\n");
            }
            ++i;
            ++offset;
        }
        if ((length - 1 & 0xF) != 15) {
            buf.append("\n");
        }
    }

    public static final String toHexString(byte b) {
        return HEX_BYTE_ARRAY[0xFF & b];
    }

    public static final String toAsciiString(byte b) {
        return ASCII_BYTE_ARRAY[0xFF & b];
    }

    public static final String toEbcdicString(byte b) {
        return EBCDIC_BYTE_ARRAY[0xFF & b];
    }

    public static final String toHexString(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(HEX_BYTE_ARRAY[0xFF & bytes[i]]);
        }
        return buf.toString();
    }

    public static void setTraceAllOn(boolean traceAll) {
        traceConversion_ = traceAll;
        traceDatastream_ = traceAll;
        traceDiagnostic_ = traceAll;
        traceError_ = traceAll;
        traceInfo_ = traceAll;
        traceJDBC_ = traceAll;
        tracePCML_ = traceAll;
        traceProxy_ = traceAll;
        traceThread_ = traceAll;
        traceWarning_ = traceAll;
        if (traceAll) {
            aTraceCategoryHasBeenActivated_ = true;
        }
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    public static void setTraceConversionOn(boolean traceConversion) {
        if (traceConversion_ != traceConversion) {
            traceConversion_ = traceConversion;
            if (traceConversion) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceDatastreamOn(boolean traceDatastream) {
        if (traceDatastream_ != traceDatastream) {
            traceDatastream_ = traceDatastream;
            if (traceDatastream) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceDiagnosticOn(boolean traceDiagnostic) {
        if (traceDiagnostic_ != traceDiagnostic) {
            traceDiagnostic_ = traceDiagnostic;
            if (traceDiagnostic) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceErrorOn(boolean traceError) {
        if (traceError_ != traceError) {
            traceError_ = traceError;
            if (traceError) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static synchronized void setFileName(String fileName) throws IOException {
        destination_.flush();
        if (fileName_ != null) {
            destination_.close();
        }
        if (fileName != null) {
            File file = new File(fileName);
            boolean fileExists = file.exists();
            if (!fileExists) {
                file.createNewFile();
            }
            boolean publicSet = file.setReadable(false, false);
            boolean ownerSet = file.setReadable(true, true);
            FileOutputStream os = new FileOutputStream(fileName, file.exists());
            destination_ = new PrintWriter(os, true);
            userSpecifiedDestination_ = true;
            fileName_ = fileName;
        } else {
            fileName_ = null;
            destination_ = new PrintWriter(System.out, true);
            userSpecifiedDestination_ = false;
        }
    }

    public static synchronized void setFileName(Object component, String fileName) throws IOException {
        String oldName;
        if (component == null) {
            throw new NullPointerException("component");
        }
        PrintWriter pw = (PrintWriter)printWriterHash_.remove(component);
        if (pw != null) {
            pw.flush();
        }
        if ((oldName = (String)fileNameHash_.remove(component)) != null && pw != null) {
            pw.close();
        }
        if (fileName != null) {
            File file = new File(fileName);
            FileOutputStream os = new FileOutputStream(fileName, file.exists());
            fileNameHash_.put(component, fileName);
            pw = new PrintWriter(os, true);
            printWriterHash_.put(component, pw);
        } else {
            if (globalPw == null) {
                globalPw = new PrintWriter(System.out, true);
            }
            pw = globalPw;
            printWriterHash_.put(component, pw);
        }
    }

    public static synchronized void setPrintWriter(PrintWriter obj) throws IOException {
        destination_.flush();
        if (fileName_ != null) {
            destination_.close();
            fileName_ = null;
        }
        if (obj != null) {
            destination_ = obj;
            userSpecifiedDestination_ = true;
        } else {
            destination_ = new PrintWriter(System.out, true);
            userSpecifiedDestination_ = false;
        }
    }

    public static synchronized void setPrintWriter(Object component, PrintWriter obj) throws IOException {
        String fileName;
        if (component == null) {
            throw new NullPointerException("component");
        }
        PrintWriter pw = (PrintWriter)printWriterHash_.remove(component);
        if (pw != null) {
            pw.flush();
        }
        if ((fileName = (String)fileNameHash_.remove(component)) != null) {
            pw.close();
        }
        if (obj != null) {
            pw = obj;
        } else {
            if (globalPw == null) {
                globalPw = new PrintWriter(System.out, true);
            }
            pw = globalPw;
        }
        printWriterHash_.put(component, pw);
    }

    public static void setTraceInformationOn(boolean traceInformation) {
        if (traceInfo_ != traceInformation) {
            traceInfo_ = traceInformation;
            if (traceInformation) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceJDBCOn(boolean traceJDBC) {
        if (traceJDBC_ != traceJDBC) {
            traceJDBC_ = traceJDBC;
            if (traceJDBC) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    private static final boolean findLogger() {
        if (firstCallToFindLogger_) {
            firstCallToFindLogger_ = false;
            if (logger_ == null && (logger_ = ToolboxLogger.getLogger()) != null && logger_.isLoggingOn()) {
                logger_.info("Toolbox for Java - JDBC 4.0  " + Copyright.version);
                logger_.info(Trace.getJvmInfo());
                if (mostRecentTracingChange_ != 2) {
                    traceOn_ = true;
                }
            }
        }
        return logger_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTraceOn(boolean traceOn) {
        if (traceOn_ != traceOn) {
            traceOn_ = traceOn;
            mostRecentTracingChange_ = traceOn ? 1 : 2;
            Trace.findLogger();
            if (!userSpecifiedDestination_) {
                destination_ = new PrintWriter(System.out, true);
            }
            if (traceOn_ && (logger_ == null || userSpecifiedDestination_)) {
                PrintWriter printWriter = destination_;
                synchronized (printWriter) {
                    destination_.println("Toolbox for Java - JDBC 4.0 " + Copyright.version);
                    destination_.println(Trace.getJvmInfo());
                }
            }
            if (logger_ != null && aTraceCategoryHasBeenActivated_) {
                logger_.setLevel();
                logger_.config("Toolbox for Java - " + Copyright.version);
            }
        }
    }

    private static String getJvmInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("java.home=");
        sb.append(System.getProperty("java.home"));
        sb.append(" java.vm.vendor=");
        sb.append(System.getProperty("java.vm.vendor"));
        sb.append(" java.vm.info=");
        sb.append(System.getProperty("java.vm.info"));
        sb.append(" java.runtime.version=");
        sb.append(System.getProperty("java.runtime.version"));
        sb.append(" java.fullversion=");
        sb.append(System.getProperty("java.fullversion"));
        sb.append(" java.vm.version=");
        sb.append(System.getProperty("java.vm.version"));
        sb.append(" java.version=");
        sb.append(System.getProperty("java.version"));
        sb.append(" os.name=");
        sb.append(System.getProperty("os.name"));
        sb.append(" os.version=");
        sb.append(System.getProperty("os.version"));
        return sb.toString();
    }

    public static void setTracePCMLOn(boolean tracePCML) {
        if (tracePCML_ != tracePCML) {
            tracePCML_ = tracePCML;
            if (tracePCML) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceProxyOn(boolean traceProxy) {
        if (traceProxy_ != traceProxy) {
            traceProxy_ = traceProxy;
            if (traceProxy) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceThreadOn(boolean traceThread) {
        if (traceThread_ != traceThread) {
            traceThread_ = traceThread;
            if (traceThread) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceWarningOn(boolean traceWarning) {
        if (traceWarning_ != traceWarning) {
            traceWarning_ = traceWarning;
            if (traceWarning) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    private static boolean traceCategory(int category) {
        boolean trace = false;
        switch (category) {
            case 3: {
                trace = traceInfo_;
                break;
            }
            case 4: {
                trace = traceWarning_;
                break;
            }
            case 2: {
                trace = traceError_;
                break;
            }
            case 1: {
                trace = traceDiagnostic_;
                break;
            }
            case 0: {
                trace = traceDatastream_;
                break;
            }
            case 5: {
                trace = traceConversion_;
                break;
            }
            case 6: {
                trace = traceProxy_;
                break;
            }
            case 7: {
                trace = tracePCML_;
                break;
            }
            case 8: {
                trace = traceJDBC_;
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException("category (" + Integer.toString(category) + ")", 2);
            }
        }
        return trace;
    }

    private static void startTraceMonitorIfNeeded() {
        String shouldMonitor = SystemProperties.getProperty("com.ibm.as400.access.Trace.monitor");
        if (shouldMonitor == null) {
            return;
        }
        if (Boolean.valueOf(shouldMonitor).equals(Boolean.TRUE)) {
            try {
                Thread monitor = new Thread((Runnable)new Trace(), "Toolbox Trace Monitor");
                monitor.setDaemon(true);
                monitor.start();
            }
            catch (Exception e) {
                System.err.println("Failed to start trace monitor: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
    }

    private static String handleTraceStatusChange(String command) {
        int index = command.indexOf(61);
        if (index < 0) {
            String msg = "Invalid trace command: " + command;
            System.err.println(msg);
            Trace.logData(null, 2, msg, null);
            return msg;
        }
        String property = command.substring(0, index);
        String value = command.substring(index + 1);
        if (value.length() == 0) {
            value = null;
        }
        if (property.equals("com.ibm.as400.access.Trace.category")) {
            Trace.setTraceCategories(value);
        } else if (property.equals("com.ibm.as400.access.Trace.file")) {
            if (value == null || !value.equals(fileName_)) {
                try {
                    Trace.setFileName(value);
                }
                catch (IOException e) {
                    String msg = "Failed to set file name to " + value + ": " + e.getMessage();
                    System.err.println(msg);
                    e.printStackTrace(System.err);
                    return msg;
                }
            }
        } else {
            return "Unrecognized command: " + command;
        }
        return "Command processed: " + command;
    }

    @Override
    public void run() {
        int port;
        try {
            String portNum = SystemProperties.getProperty("com.ibm.as400.access.Trace.monitorPort");
            port = portNum != null ? Integer.parseInt(portNum) : 55555;
        }
        catch (Exception e) {
            System.err.println("Failed to get TRACE_MONITOR_PORT property: " + e.getMessage());
            e.printStackTrace(System.err);
            return;
        }
        try {
            ServerSocket monitorSocket_ = new ServerSocket(port, 1);
            while (true) {
                Socket currentSocket = monitorSocket_.accept();
                BufferedReader in = new BufferedReader(new InputStreamReader(currentSocket.getInputStream()));
                PrintWriter out = new PrintWriter(currentSocket.getOutputStream(), true);
                String command = in.readLine();
                if (command != null) {
                    String result = Trace.handleTraceStatusChange(command);
                    out.println(result);
                }
                currentSocket.close();
            }
        }
        catch (Exception e) {
            System.err.println("Exception in trace monitor daemon: " + e.getMessage());
            e.printStackTrace(System.err);
            return;
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            Trace.printUsage();
        } else {
            int port = 0;
            try {
                port = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                System.err.println("Invalid port specified (" + args[1] + ")");
                e.printStackTrace(System.err);
                return;
            }
            try {
                for (int i = 2; i < args.length; ++i) {
                    Socket s = new Socket(args[0], port);
                    PrintWriter out = new PrintWriter(s.getOutputStream(), true);
                    BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    out.println(args[i]);
                    String result = in.readLine();
                    System.out.println(result);
                    s.close();
                }
            }
            catch (UnknownHostException e) {
                System.err.println("Host " + args[0] + " is not known.");
                e.printStackTrace(System.err);
            }
            catch (Exception e) {
                System.err.println("Exception contacting trace monitor: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Usage:  java com.ibm.as400.access.Trace [systemName] [monitorPort] [traceCommands]");
        System.out.println();
        System.out.println("  This assumes that the target JVM (the JVM in which the application of interest is running) has been started with the following Java system properties set: ");
        System.out.println("     com.ibm.as400.access.Trace.monitor=true     [REQUIRED]");
        System.out.println("     com.ibm.as400.access.Trace.monitorPort=xxx  [OPTIONAL]");
        System.out.println("");
        System.out.println("  If [monitorPort] is not specified, the monitor port number is set to 55555");
        System.out.println("");
        System.out.println("  [traceCommands] is one or more of (separated by spaces):");
        System.out.println("     com.ibm.as400.access.Trace.category=[listOfCategories]");
        System.out.println("        listOfCategories is a comma-delimited list of valid Toolbox trace categories");
        System.out.println();
        System.out.println("Example invocation:  java com.ibm.as400.access.Trace mysystem 55555 com.ibm.as400.access.Trace.category=error,warning com.ibm.as400.access.Trace.file=/tmp/out.txt");
    }

    private static void setTraceCategories(String categories) {
        if (categories != null) {
            StringTokenizer tokenizer = new StringTokenizer(categories, ", ;");
            if (!tokenizer.hasMoreTokens()) {
                Trace.setTraceOn(false);
            } else {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(false);
            while (tokenizer.hasMoreTokens()) {
                String category = tokenizer.nextToken();
                if (category.equalsIgnoreCase("datastream")) {
                    Trace.setTraceDatastreamOn(true);
                    continue;
                }
                if (category.equalsIgnoreCase("diagnostic")) {
                    Trace.setTraceDiagnosticOn(true);
                    continue;
                }
                if (category.equalsIgnoreCase("error")) {
                    Trace.setTraceErrorOn(true);
                    continue;
                }
                if (category.equalsIgnoreCase("information")) {
                    Trace.setTraceInformationOn(true);
                    continue;
                }
                if (category.equalsIgnoreCase("warning")) {
                    Trace.setTraceWarningOn(true);
                    continue;
                }
                if (category.equalsIgnoreCase("conversion")) {
                    Trace.setTraceConversionOn(true);
                    continue;
                }
                if (category.equalsIgnoreCase("proxy")) {
                    Trace.setTraceProxyOn(true);
                    continue;
                }
                if (category.equalsIgnoreCase("thread")) {
                    Trace.setTraceThreadOn(true);
                    continue;
                }
                if (category.equalsIgnoreCase("jdbc")) {
                    Trace.setTraceJDBCOn(true);
                    continue;
                }
                if (category.equalsIgnoreCase("pcml")) {
                    Trace.setTracePCMLOn(true);
                    continue;
                }
                if (category.equalsIgnoreCase("all")) {
                    Trace.setTraceAllOn(true);
                    continue;
                }
                if (category.equalsIgnoreCase("none")) {
                    Trace.setTraceOn(false);
                    continue;
                }
                if (!Trace.isTraceOn()) continue;
                Trace.log(4, "Trace category not valid: " + category);
            }
        } else {
            Trace.setTraceOn(false);
        }
    }

    static int activeTraceCategory() {
        if (traceError_) {
            return 2;
        }
        if (traceWarning_) {
            return 4;
        }
        if (traceInfo_) {
            return 3;
        }
        if (traceDiagnostic_) {
            return 1;
        }
        if (traceDatastream_) {
            return 0;
        }
        if (traceConversion_) {
            return 5;
        }
        if (traceProxy_) {
            return 6;
        }
        if (traceJDBC_) {
            return 8;
        }
        if (tracePCML_) {
            return 7;
        }
        return -1;
    }

    static {
        showChars_ = false;
        aTraceCategoryHasBeenActivated_ = false;
        fileName_ = null;
        destination_ = new PrintWriter(System.out, true);
        userSpecifiedDestination_ = false;
        printWriterHash_ = new Hashtable();
        fileNameHash_ = new Hashtable();
        timeStampFormatter_ = new SimpleDateFormat("EEE MMM d HH:mm:ss:SSS z yyyy");
        logger_ = null;
        firstCallToFindLogger_ = true;
        globalPw = null;
        Trace.loadTraceProperties();
        HEX_BYTE_ARRAY = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
        ASCII_BYTE_ARRAY = new String[]{".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", " ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", "."};
        EBCDIC_BYTE_ARRAY = new String[]{".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", "[", ".", "<", "(", "+", "!", "&", ".", ".", ".", ".", ".", ".", ".", ".", ".", "]", "$", "*", ")", ";", "^", "-", "/", ".", ".", ".", ".", ".", ".", ".", ".", "|", ",", "%", "_", ">", "?", ".", ".", ".", ".", ".", ".", ".", ".", ".", "`", ":", "#", "@", "'", "=", "\"", ".", "a", "b", "c", "d", "e", "f", "g", "h", "i", ".", ".", ".", ".", ".", ".", ".", "j", "k", "l", "m", "n", "o", "p", "q", "r", ".", ".", ".", ".", ".", ".", ".", ".", "s", "t", "u", "v", "w", "x", "y", "z", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", "{", "A", "B", "C", "D", "E", "F", "G", "H", "I", ".", ".", ".", ".", ".", ".", "}", "J", "K", "L", "M", "N", "O", "P", "Q", "R", ".", ".", ".", ".", ".", ".", "\\", ".", "S", "T", "U", "V", "W", "X", "Y", "Z", ".", ".", ".", ".", ".", ".", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", ".", ".", ".", ".", "."};
    }
}

