/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.DirFilter;
import com.ibm.as400.util.html.HTMLTreeElement;
import com.ibm.as400.util.servlet.ServletHyperlink;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class FileTreeElement
extends HTMLTreeElement
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    static final long serialVersionUID = 210948696422108527L;
    private File file_;
    private boolean populated_ = false;
    private String parameter_;
    private String shareName_;
    private String sharePath_;
    private int patternMatching_ = -1;

    public FileTreeElement() {
    }

    public FileTreeElement(File file) {
        this.setFile(file);
        this.setText(file.getName());
    }

    public FileTreeElement(File file, String parameter) {
        this.setFile(file);
        this.setText(file.getName());
        this.parameter_ = parameter;
    }

    public FileTreeElement(File file, String shareName, String sharePath) {
        this.setFile(file);
        this.setShareName(shareName);
        this.setSharePath(sharePath);
    }

    public FileTreeElement(File file, String shareName, String sharePath, String parameter) {
        this.setFile(file);
        this.setShareName(shareName);
        this.setSharePath(sharePath);
        this.parameter_ = parameter;
    }

    private void addProperties() {
        if (this.getTextUrl() != null) {
            ServletHyperlink sl = (ServletHyperlink)this.getTextUrl().clone();
            if (this.shareName_ != null) {
                String absPath = this.file_.getAbsolutePath().replace('\\', '/');
                if (this.sharePath_.charAt(0) != '/') {
                    absPath = absPath.substring(1);
                }
                if (Trace.isTraceOn()) {
                    Trace.log(3, "FileTree absolute path: " + absPath);
                    Trace.log(3, "FileTree share path:    " + this.sharePath_);
                }
                StringBuffer pathInfo = new StringBuffer(this.shareName_);
                String remainingPath = absPath.substring(this.sharePath_.length());
                if (remainingPath.length() > 0 && remainingPath.charAt(0) != '/') {
                    pathInfo.append('/');
                }
                pathInfo.append(remainingPath);
                if (this.parameter_ != null) {
                    Properties parms = sl.getProperties();
                    if (parms == null) {
                        parms = new Properties();
                    }
                    parms.put(this.parameter_, pathInfo.toString());
                    try {
                        sl.setProperties(parms);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    sl.setPathInfo(pathInfo.toString());
                }
            } else {
                String pathInfo = this.file_.getAbsolutePath().replace('\\', '/');
                if (this.parameter_ != null) {
                    Properties parms = sl.getProperties();
                    if (parms == null) {
                        parms = new Properties();
                    }
                    parms.put(this.parameter_, pathInfo);
                    try {
                        sl.setProperties(parms);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    sl.setPathInfo(pathInfo);
                }
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "FileTree path Info:    " + sl.getPathInfo());
            }
            try {
                sl.setText(this.file_.getName());
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.setTextUrl(sl);
        }
    }

    public File getFile() {
        return this.file_;
    }

    public String getShareName() {
        if (this.shareName_ == null) {
            return null;
        }
        return this.shareName_;
    }

    public String getSharePath() {
        if (this.sharePath_ == null) {
            return null;
        }
        return this.sharePath_;
    }

    @Override
    public boolean isLeaf() {
        if (this.getTextUrl() != null) {
            this.addProperties();
        }
        if (!this.populated_) {
            return this.file_.isFile();
        }
        return super.isLeaf();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public void selected(int hashcode) {
        if (hashcode == this.hashCode() && this.file_.isDirectory() && !this.populated_) {
            Object[] files;
            if (this.file_ instanceof IFSJavaFile) {
                block28: {
                    if (this.patternMatching_ != -1) {
                        try {
                            ((IFSJavaFile)this.file_).setPatternMatching(this.patternMatching_);
                        }
                        catch (IOException e) {
                            if (!Trace.isTraceOn()) break block28;
                            Trace.log(2, e);
                        }
                    }
                }
                File[] filesAndDirs = ((IFSJavaFile)this.file_).listFiles();
                Vector<File> dv = new Vector<File>();
                for (int i = 0; i < filesAndDirs.length; ++i) {
                    if (!filesAndDirs[i].isDirectory()) continue;
                    dv.addElement(filesAndDirs[i]);
                }
                files = new File[dv.size()];
                dv.copyInto(files);
            } else {
                String[] list = this.file_.list(new DirFilter());
                files = new File[list.length];
                for (int i = 0; i < list.length; ++i) {
                    files[i] = new File(this.file_, list[i]);
                }
            }
            for (int i = 0; i < files.length; ++i) {
                FileTreeElement node = this.shareName_ != null ? new FileTreeElement((File)files[i], this.shareName_, this.sharePath_, this.parameter_) : new FileTreeElement((File)files[i], this.parameter_);
                if (this.patternMatching_ != -1) {
                    node.setPatternMatching(this.patternMatching_);
                }
                if (this.getTextUrl() != null) {
                    ServletHyperlink sl = (ServletHyperlink)this.getTextUrl().clone();
                    if (this.shareName_ != null) {
                        String absPath = this.file_.getAbsolutePath().replace('\\', '/');
                        if (this.sharePath_.charAt(0) != '/') {
                            absPath = absPath.substring(1);
                        }
                        if (Trace.isTraceOn()) {
                            Trace.log(3, "FileTree absolute path: " + absPath);
                        }
                        StringBuffer pathInfo = new StringBuffer(this.shareName_);
                        String remainingPath = absPath.substring(this.sharePath_.length());
                        if (remainingPath.charAt(0) != '/') {
                            pathInfo.append('/');
                        }
                        pathInfo.append(remainingPath);
                        if (this.parameter_ != null) {
                            Properties parms = sl.getProperties();
                            if (parms == null) {
                                parms = new Properties();
                            }
                            parms.put(this.parameter_, pathInfo.toString());
                            try {
                                sl.setProperties(parms);
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else {
                            sl.setPathInfo(pathInfo.toString());
                        }
                    } else {
                        String pathInfo = ((File)files[i]).getAbsolutePath().replace('\\', '/');
                        if (this.parameter_ != null) {
                            Properties parms = sl.getProperties();
                            if (parms == null) {
                                parms = new Properties();
                            }
                            parms.put(this.parameter_, pathInfo);
                            try {
                                sl.setProperties(parms);
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else {
                            sl.setPathInfo(pathInfo);
                        }
                    }
                    try {
                        sl.setText(((File)files[i]).getName());
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    node.setTextUrl(sl);
                }
                node.setIconUrl((ServletHyperlink)this.getIconUrl().clone());
                this.addElement(node);
            }
            this.populated_ = true;
        }
        super.selected(hashcode);
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        File old = this.file_;
        this.file_ = file;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("file", old, this.file_);
        }
    }

    public void setShareName(String shareName) {
        if (shareName == null) {
            throw new NullPointerException("shareName");
        }
        String old = this.shareName_;
        this.shareName_ = shareName;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("shareName", old, this.shareName_);
        }
    }

    public void setSharePath(String sharePath) {
        if (sharePath == null) {
            throw new NullPointerException("sharePath");
        }
        String old = this.sharePath_;
        this.sharePath_ = sharePath;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("sharePath", old, this.sharePath_);
        }
    }

    public void setPatternMatching(int patternMatching) {
        if (patternMatching < 0 || patternMatching > 2) {
            throw new ExtendedIllegalArgumentException("patternMatching", 2);
        }
        this.patternMatching_ = patternMatching;
    }
}

