/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLTableCaption
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 8692666542126042315L;
    private HTMLTagElement element_;
    private String align_;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private transient VetoableChangeSupport vetos_;

    public HTMLTableCaption() {
    }

    public HTMLTableCaption(HTMLTagElement element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.element_ = element;
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public String getAlignment() {
        return this.align_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" dir=\"");
            buffer.append(this.dir_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    public HTMLTagElement getElement() {
        return this.element_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer buffer = new StringBuffer(" lang=\"");
            buffer.append(this.lang_);
            buffer.append("\"");
            return buffer.toString();
        }
        return "";
    }

    @Override
    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.element_ == null) {
            Trace.log(2, "Attempting to get tag before setting the 'element' parameter.");
            throw new ExtendedIllegalStateException("element", 4);
        }
        StringBuffer tag = new StringBuffer("<caption");
        if (this.align_ != null) {
            tag.append(" align=\"");
            tag.append(this.align_);
            tag.append("\"");
        }
        tag.append(this.getLanguageAttributeTag());
        tag.append(this.getDirectionAttributeTag());
        tag.append(this.getAttributeString());
        tag.append(">");
        tag.append(this.element_.getTag());
        tag.append("</caption>\n");
        return tag.toString();
    }

    @Override
    public String getFOTag() {
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        if (this.element_ == null) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting the 'element' parameter.");
            throw new ExtendedIllegalStateException("element", 4);
        }
        StringBuffer tag = new StringBuffer("");
        tag.append("<fo:block");
        if (this.align_ != null) {
            tag.append(" text-align=\"");
            if (this.align_.equals("center")) {
                tag.append("center\"");
            } else if (this.align_.equals("right")) {
                tag.append("end\"");
            } else if (this.align_.equals("left")) {
                tag.append("start\"");
            } else {
                tag.append("center\"");
            }
        }
        tag.append(this.getDirectionAttributeTag());
        tag.append(">");
        tag.append(this.element_.getFOTag());
        tag.append("</fo:block>\n");
        this.setUseFO(useFO);
        return tag.toString();
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setAlignment(String alignment) throws PropertyVetoException {
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        if (alignment.equalsIgnoreCase("bottom") || alignment.equalsIgnoreCase("top") || alignment.equalsIgnoreCase("left") || alignment.equalsIgnoreCase("right")) {
            String old = this.align_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", old, alignment);
            }
            this.align_ = alignment;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", old, alignment);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setElement(String text) throws PropertyVetoException {
        this.setElement(new HTMLText(text));
    }

    public void setElement(HTMLTagElement element) throws PropertyVetoException {
        if (element == null) {
            throw new NullPointerException("element");
        }
        HTMLTagElement old = this.element_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("element", old, element);
        }
        this.element_ = element;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("element", old, element);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

