/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLHyperlink;
import com.ibm.as400.util.html.HTMLTable;
import com.ibm.as400.util.html.HTMLTableCaption;
import com.ibm.as400.util.html.HTMLTableCell;
import com.ibm.as400.util.html.HTMLTableHeader;
import com.ibm.as400.util.html.HTMLTableRow;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import com.ibm.as400.util.html.LineLayoutFormPanel;
import com.ibm.as400.util.servlet.RowData;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import com.ibm.as400.util.servlet.SectionCompletedListener;
import com.ibm.as400.util.servlet.SectionCompletedSupport;
import com.ibm.as400.util.servlet.StringConverter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLFormConverter
extends StringConverter
implements Serializable,
HTMLConstants {
    static final long serialVersionUID = -6301275216248287290L;
    private HTMLTable htmlTable_ = new HTMLTable();
    private HTMLHyperlink[] links_;
    private transient Vector completedListeners_;
    private transient SectionCompletedSupport sectionCompletedSupport_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;

    public void addActionCompletedListener(ActionCompletedListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.completedListeners_ == null) {
            this.completedListeners_ = new Vector();
        }
        this.completedListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
        this.htmlTable_.addPropertyChangeListener(listener);
    }

    public void addSectionCompletedListener(SectionCompletedListener listener) {
        if (this.sectionCompletedSupport_ == null) {
            this.sectionCompletedSupport_ = new SectionCompletedSupport(this);
        }
        this.sectionCompletedSupport_.addSectionCompletedListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
        this.htmlTable_.addVetoableChangeListener(listener);
    }

    private Vector convertRowData(RowData rowdata, RowMetaData metadata) throws PropertyVetoException, RowDataException {
        HTMLTable table;
        if (metadata == null) {
            Trace.log(2, "The rowdata's metadata attribute is invalid.");
            throw new ExtendedIllegalStateException("rowdata metadata", 4);
        }
        Vector<HTMLTable> formList = new Vector<HTMLTable>();
        int numColumns = metadata.getColumnCount();
        HTMLTableHeader[] header = this.createFormHeader(metadata);
        if (rowdata.length() == 0) {
            table = this.createDefaultTable(header);
            formList.addElement(table);
            if (this.sectionCompletedSupport_ != null) {
                this.sectionCompletedSupport_.fireSectionCompleted(table.getTag());
            }
        } else {
            rowdata.beforeFirst();
        }
        while (rowdata.next()) {
            table = this.createDefaultTable(header);
            for (int column = 0; column < numColumns; ++column) {
                Object columnObject;
                HTMLTableRow row = table.getRow(column);
                HTMLTableCell cell = new HTMLTableCell();
                Vector properties = rowdata.getObjectProperties(column);
                if (properties != null) {
                    int propSize = properties.size();
                    for (int index = 0; index < propSize; ++index) {
                        if (!(properties.elementAt(index) instanceof HTMLTableCell)) continue;
                        cell = (HTMLTableCell)properties.elementAt(index);
                    }
                }
                if ((columnObject = rowdata.getObject(column)) == null) {
                    columnObject = new LineLayoutFormPanel();
                }
                try {
                    cell.setElement((HTMLTagElement)columnObject);
                }
                catch (ClassCastException e) {
                    cell.setElement(new HTMLText(columnObject.toString()));
                }
                if (metadata.getColumnAlignment(column) != null) {
                    cell.setHorizontalAlignment(metadata.getColumnAlignment(column));
                }
                if (metadata.getColumnDirection(column) != null) {
                    cell.setDirection(metadata.getColumnDirection(column));
                }
                row.addColumn(cell);
                table.setRow(row, column);
            }
            formList.addElement(table);
            if (this.sectionCompletedSupport_ == null) continue;
            this.sectionCompletedSupport_.fireSectionCompleted(table.getTag());
        }
        this.fireCompleted();
        return formList;
    }

    public HTMLTable[] convertToForms(RowData rowdata) throws PropertyVetoException, RowDataException {
        if (rowdata == null) {
            throw new NullPointerException("rowdata");
        }
        Vector tableVector = this.convertRowData(rowdata, rowdata.getMetaData());
        Object[] tables = new HTMLTable[tableVector.size()];
        tableVector.copyInto(tables);
        return tables;
    }

    private HTMLTable createDefaultTable(HTMLTableHeader[] header) {
        HTMLTable table = new HTMLTable();
        try {
            if (this.htmlTable_.getCaption() != null) {
                table.setCaption(this.htmlTable_.getCaption());
            }
            if (this.htmlTable_.getAlignment() != null) {
                table.setAlignment(this.htmlTable_.getAlignment());
            }
            table.setBorderWidth(this.htmlTable_.getBorderWidth());
            table.setCellPadding(this.htmlTable_.getCellPadding());
            table.setCellSpacing(this.htmlTable_.getCellSpacing());
            table.setWidth(this.htmlTable_.getWidth(), this.htmlTable_.isWidthInPercent());
            table.setHeaderInUse(false);
            if (this.htmlTable_.getLanguage() != null) {
                table.setLanguage(this.htmlTable_.getLanguage());
            }
            if (this.htmlTable_.getDirection() != null) {
                table.setDirection(this.htmlTable_.getDirection());
            }
            for (int column = 0; column < header.length; ++column) {
                HTMLTableRow row = new HTMLTableRow();
                row.addColumn(header[column]);
                table.addRow(row);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return table;
    }

    private HTMLTableHeader[] createFormHeader(RowMetaData metadata) throws PropertyVetoException, RowDataException {
        int numColumns = metadata.getColumnCount();
        HTMLTableHeader[] header = new HTMLTableHeader[numColumns];
        for (int column = 0; column < numColumns; ++column) {
            header[column] = new HTMLTableHeader();
            String columnName = "";
            try {
                columnName = metadata.getColumnLabel(column);
            }
            catch (NullPointerException e) {
                columnName = metadata.getColumnName(column);
            }
            if (this.links_ != null && this.links_[column] != null) {
                HTMLHyperlink link = this.links_[column];
                link.setText(columnName);
                header[column].setElement(link);
                continue;
            }
            HTMLText text = new HTMLText(columnName);
            header[column].setElement(text);
        }
        return header;
    }

    @Override
    String[] doConvert(RowData rowdata, RowMetaData metadata) throws PropertyVetoException, RowDataException {
        if (metadata == null) {
            throw new NullPointerException("metadata");
        }
        Vector forms = this.convertRowData(rowdata, metadata);
        String[] data = new String[forms.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((HTMLTable)forms.elementAt(i)).getTag();
        }
        return data;
    }

    private void fireCompleted() {
        if (this.completedListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.completedListeners_.clone();
        ActionCompletedEvent event = new ActionCompletedEvent(this);
        for (int i = 0; i < targets.size(); ++i) {
            ActionCompletedListener target = (ActionCompletedListener)targets.elementAt(i);
            target.actionCompleted(event);
        }
    }

    public String getAlignment() {
        return this.htmlTable_.getAlignment();
    }

    public int getBorderWidth() {
        return this.htmlTable_.getBorderWidth();
    }

    public HTMLTableCaption getCaption() {
        return this.htmlTable_.getCaption();
    }

    public int getCellPadding() {
        return this.htmlTable_.getCellPadding();
    }

    public int getCellSpacing() {
        return this.htmlTable_.getCellSpacing();
    }

    public String getDirection() {
        return this.htmlTable_.getDirection();
    }

    public HTMLHyperlink[] getHeaderHyperlinks() {
        return this.links_;
    }

    public String getLanguage() {
        return this.htmlTable_.getLanguage();
    }

    public HTMLHyperlink getObjectHyperlink(RowData rowdata, int column) {
        if (rowdata == null) {
            throw new NullPointerException("rowdata");
        }
        return this.getObjectHyperlink(rowdata, rowdata.getCurrentPosition(), column);
    }

    public HTMLHyperlink getObjectHyperlink(RowData rowdata, int row, int column) {
        if (rowdata == null) {
            throw new NullPointerException("rowdata");
        }
        HTMLHyperlink link = null;
        if (!rowdata.absolute(row)) {
            throw new ExtendedIllegalArgumentException("row", 4);
        }
        Vector properties = rowdata.getObjectProperties(column);
        if (properties != null) {
            int propSize = properties.size();
            for (int index = 0; index < propSize; ++index) {
                if (!(properties.elementAt(index) instanceof HTMLHyperlink)) continue;
                link = (HTMLHyperlink)properties.elementAt(index);
                break;
            }
        }
        return link;
    }

    public int getWidth() {
        return this.htmlTable_.getWidth();
    }

    public boolean isWidthInPercent() {
        return this.htmlTable_.isWidthInPercent();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeActionCompletedListener(ActionCompletedListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.completedListeners_ != null) {
            this.completedListeners_.removeElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
        this.htmlTable_.removePropertyChangeListener(listener);
    }

    public void removeSectionCompletedListener(SectionCompletedListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.sectionCompletedSupport_ != null) {
            this.sectionCompletedSupport_.removeSectionCompletedListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
        this.htmlTable_.removeVetoableChangeListener(listener);
    }

    public void setAlignment(String alignment) throws PropertyVetoException {
        this.htmlTable_.setAlignment(alignment);
    }

    public void setBorderWidth(int borderWidth) throws PropertyVetoException {
        this.htmlTable_.setBorderWidth(borderWidth);
    }

    public void setCaption(HTMLTableCaption caption) throws PropertyVetoException {
        this.htmlTable_.setCaption(caption);
    }

    public void setCellPadding(int cellPadding) throws PropertyVetoException {
        this.htmlTable_.setCellPadding(cellPadding);
    }

    public void setCellSpacing(int cellSpacing) throws PropertyVetoException {
        this.htmlTable_.setCellSpacing(cellSpacing);
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        this.htmlTable_.setDirection(dir);
    }

    public void setHeaderHyperlinks(HTMLHyperlink[] links) throws PropertyVetoException {
        if (links == null) {
            throw new NullPointerException("links");
        }
        HTMLHyperlink[] old = this.links_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("links", old, links);
        }
        this.links_ = links;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("links", old, links);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        this.htmlTable_.setLanguage(lang);
    }

    public void setObjectHyperlink(RowData rowdata, HTMLHyperlink link, int column) throws RowDataException {
        if (rowdata == null) {
            throw new NullPointerException("rowdata");
        }
        this.setObjectHyperlink(rowdata, link, rowdata.getCurrentPosition(), column);
    }

    public void setObjectHyperlink(RowData rowdata, HTMLHyperlink link, int row, int column) throws RowDataException {
        if (rowdata == null) {
            throw new NullPointerException("rowdata");
        }
        if (link == null) {
            throw new NullPointerException("link");
        }
        if (!rowdata.absolute(row)) {
            throw new ExtendedIllegalArgumentException("row", 4);
        }
        Vector<HTMLHyperlink> properties = rowdata.getObjectProperties(column);
        if (properties == null) {
            properties = new Vector<HTMLHyperlink>();
            properties.addElement(link);
        } else {
            HTMLHyperlink oldTag = null;
            int linkIndex = -1;
            int propSize = properties.size();
            for (int index = 0; index < propSize; ++index) {
                if (!(properties.elementAt(index) instanceof HTMLHyperlink)) continue;
                oldTag = (HTMLHyperlink)properties.elementAt(index);
                linkIndex = index;
                break;
            }
            if (oldTag == null) {
                properties.addElement(link);
            } else {
                properties.setElementAt(link, linkIndex);
            }
        }
        rowdata.setObjectProperties(properties, column);
    }

    public void setWidth(int width, boolean widthInPercent) throws PropertyVetoException {
        this.htmlTable_.setWidth(width, widthInPercent);
    }
}

