/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.AS400Array;
import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400Structure;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400UnsignedBin2;
import com.ibm.as400.access.AS400UnsignedBin4;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import com.ibm.as400.util.servlet.RowMetaDataType;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class RecordFormatMetaData
implements RowMetaData,
Serializable {
    static final long serialVersionUID = 5676240820170682074L;
    private RecordFormat recordFormat_;
    private transient String[] columnLabel_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private String[] columnAlignment_;
    private String[] columnDirection_;

    public RecordFormatMetaData() {
    }

    public RecordFormatMetaData(RecordFormat recordFormat) {
        try {
            this.setRecordFormat(recordFormat);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    @Override
    public String getColumnAlignment(int columnIndex) {
        this.validateRecordFormat("Attempting to get the column alignment");
        this.validateColumnIndex(columnIndex);
        return this.columnAlignment_[columnIndex];
    }

    @Override
    public String getColumnDirection(int columnIndex) {
        this.validateRecordFormat("Attempting to get the column direction");
        this.validateColumnIndex(columnIndex);
        return this.columnDirection_[columnIndex];
    }

    @Override
    public int getColumnCount() {
        if (this.recordFormat_ == null) {
            Trace.log(2, "Attempting to get the column count before setting the record format.");
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        return this.recordFormat_.getNumberOfFields();
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) {
        this.validateRecordFormat("Attempting to get the column display size");
        this.validateColumnIndex(columnIndex);
        FieldDescription fd = this.recordFormat_.getFieldDescription(columnIndex);
        return fd.getLength();
    }

    @Override
    public String getColumnLabel(int columnIndex) {
        this.validateRecordFormat("Attempting to get the column label");
        this.validateColumnIndex(columnIndex);
        String label = this.columnLabel_[columnIndex];
        if (label == null) {
            label = this.getColumnName(columnIndex);
        }
        this.columnLabel_[columnIndex] = label;
        return label;
    }

    @Override
    public String getColumnName(int columnIndex) {
        this.validateRecordFormat("Attempting to get the column name");
        this.validateColumnIndex(columnIndex);
        FieldDescription fd = this.recordFormat_.getFieldDescription(columnIndex);
        return fd.getFieldName();
    }

    @Override
    public int getColumnType(int columnIndex) {
        this.validateRecordFormat("Attempting to get the column type");
        this.validateColumnIndex(columnIndex);
        FieldDescription fd = this.recordFormat_.getFieldDescription(columnIndex);
        AS400DataType datatype = fd.getDataType();
        if (datatype instanceof AS400Bin2) {
            return 7;
        }
        if (datatype instanceof AS400Bin4) {
            return 5;
        }
        if (datatype instanceof AS400ByteArray) {
            return 1;
        }
        if (datatype instanceof AS400Float4) {
            return 4;
        }
        if (datatype instanceof AS400Float8) {
            return 3;
        }
        if (datatype instanceof AS400PackedDecimal) {
            return 2;
        }
        if (datatype instanceof AS400Structure) {
            return 1;
        }
        if (datatype instanceof AS400Array) {
            return 1;
        }
        if (datatype instanceof AS400Text) {
            return 8;
        }
        if (datatype instanceof AS400UnsignedBin2) {
            return 5;
        }
        if (datatype instanceof AS400UnsignedBin4) {
            return 6;
        }
        if (datatype instanceof AS400ZonedDecimal) {
            return 2;
        }
        return 1;
    }

    @Override
    public String getColumnTypeName(int columnIndex) {
        this.validateRecordFormat("Attempting to get the column type name");
        this.validateColumnIndex(columnIndex);
        FieldDescription fd = this.recordFormat_.getFieldDescription(columnIndex);
        AS400DataType datatype = fd.getDataType();
        if (datatype instanceof AS400Bin2) {
            return RowMetaDataType.getDataTypeName(7);
        }
        if (datatype instanceof AS400Bin4) {
            return RowMetaDataType.getDataTypeName(5);
        }
        if (datatype instanceof AS400ByteArray) {
            return RowMetaDataType.getDataTypeName(1);
        }
        if (datatype instanceof AS400Float4) {
            return RowMetaDataType.getDataTypeName(4);
        }
        if (datatype instanceof AS400Float8) {
            return RowMetaDataType.getDataTypeName(3);
        }
        if (datatype instanceof AS400PackedDecimal) {
            return RowMetaDataType.getDataTypeName(2);
        }
        if (datatype instanceof AS400Structure) {
            return RowMetaDataType.getDataTypeName(1);
        }
        if (datatype instanceof AS400Array) {
            return RowMetaDataType.getDataTypeName(1);
        }
        if (datatype instanceof AS400Text) {
            return RowMetaDataType.getDataTypeName(8);
        }
        if (datatype instanceof AS400UnsignedBin2) {
            return RowMetaDataType.getDataTypeName(5);
        }
        if (datatype instanceof AS400UnsignedBin4) {
            return RowMetaDataType.getDataTypeName(6);
        }
        if (datatype instanceof AS400ZonedDecimal) {
            return RowMetaDataType.getDataTypeName(2);
        }
        return RowMetaDataType.getDataTypeName(1);
    }

    @Override
    public int getPrecision(int columnIndex) {
        this.validateRecordFormat("Attempting to get the precision");
        this.validateColumnIndex(columnIndex);
        FieldDescription fd = this.recordFormat_.getFieldDescription(columnIndex);
        AS400DataType datatype = fd.getDataType();
        if (datatype instanceof AS400ZonedDecimal) {
            return ((AS400ZonedDecimal)datatype).getNumberOfDigits();
        }
        if (datatype instanceof AS400PackedDecimal) {
            return ((AS400PackedDecimal)datatype).getNumberOfDigits();
        }
        return 0;
    }

    public RecordFormat getRecordFormat() {
        return this.recordFormat_;
    }

    @Override
    public int getScale(int columnIndex) {
        this.validateRecordFormat("Attempting to get the scale");
        this.validateColumnIndex(columnIndex);
        FieldDescription fd = this.recordFormat_.getFieldDescription(columnIndex);
        AS400DataType datatype = fd.getDataType();
        if (datatype instanceof AS400ZonedDecimal) {
            return ((AS400ZonedDecimal)datatype).getNumberOfDecimalPositions();
        }
        if (datatype instanceof AS400PackedDecimal) {
            return ((AS400PackedDecimal)datatype).getNumberOfDecimalPositions();
        }
        return 0;
    }

    @Override
    public boolean isNumericData(int columnIndex) {
        return RowMetaDataType.isNumericData(this.getColumnType(columnIndex));
    }

    @Override
    public boolean isTextData(int columnIndex) {
        return RowMetaDataType.isTextData(this.getColumnType(columnIndex));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, RowDataException {
        in.defaultReadObject();
        if (this.recordFormat_ != null) {
            try {
                this.setRecordFormat(this.recordFormat_);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    @Override
    public void setColumnAlignment(int columnIndex, String alignment) {
        this.validateRecordFormat("Attempting to set the column alignment");
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        this.validateColumnIndex(columnIndex);
        if (!(alignment.equals("left") || alignment.equals("right") || alignment.equals("center") || alignment.equals("justify"))) {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
        this.columnAlignment_[columnIndex] = alignment;
    }

    @Override
    public void setColumnDirection(int columnIndex, String dir) {
        this.validateRecordFormat("Attempting to set the column directionl");
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        this.validateColumnIndex(columnIndex);
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        this.columnDirection_[columnIndex] = dir;
    }

    @Override
    public void setColumnLabel(int columnIndex, String label) {
        this.validateRecordFormat("Attempting to set the column label");
        if (label == null) {
            throw new NullPointerException("label");
        }
        this.validateColumnIndex(columnIndex);
        this.columnLabel_[columnIndex] = label;
    }

    public void setRecordFormat(RecordFormat recordFormat) throws PropertyVetoException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        RecordFormat old = this.recordFormat_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("recordFormat", old, recordFormat);
        }
        this.recordFormat_ = recordFormat;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("recordFormat", old, recordFormat);
        }
        int count = this.getColumnCount();
        this.columnLabel_ = new String[count];
        this.columnAlignment_ = new String[count];
        this.columnDirection_ = new String[count];
    }

    private void validateColumnIndex(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.recordFormat_.getNumberOfFields()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
    }

    private void validateRecordFormat(String action) {
        if (this.recordFormat_ == null) {
            Trace.log(2, action + " before setting the record format.");
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
    }
}

