/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.util.servlet.ResourceListMetaData;
import com.ibm.as400.util.servlet.RowData;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import java.io.Serializable;
import java.util.Vector;

public class ResourceListRowData
extends RowData
implements Serializable {
    static final long serialVersionUID = 1081925300369525536L;
    private ResourceListMetaData metadata_;
    private ResourceList resourceList_;
    private Object[] columnAttributeIDs_;
    private Exception lastException_;
    private boolean refreshed_;

    public ResourceListRowData() {
        this.setColumnAttributeIDs(new Object[0]);
    }

    public ResourceListRowData(ResourceList resourceList, Object[] columnAttributeIDs) {
        this();
        this.setMetaData(resourceList, columnAttributeIDs);
        this.setResourceList(resourceList);
        this.setColumnAttributeIDs(columnAttributeIDs);
    }

    public Object[] getColumnAttributeIDs() {
        return this.columnAttributeIDs_;
    }

    int getListLength() {
        try {
            if (this.resourceList_ == null) {
                return 0;
            }
            if (!this.refreshed_) {
                this.resourceList_.refreshStatus();
                this.refreshed_ = true;
            }
            return (int)this.resourceList_.getListLength();
        }
        catch (ResourceException e) {
            Trace.log(2, "Error getting resource length.", (Throwable)e);
            this.lastException_ = e;
            return 0;
        }
    }

    @Override
    public RowMetaData getMetaData() {
        return this.metadata_;
    }

    @Override
    public Object getObject(int columnIndex) throws RowDataException {
        try {
            Object attributeValue;
            if (this.lastException_ != null) {
                throw new RowDataException(this.lastException_);
            }
            if (this.columnAttributeIDs_ == null) {
                throw new NullPointerException("columnAttributeIDs");
            }
            if (this.columnAttributeIDs_.length == 0) {
                Trace.log(2, "Attempting to get the column object before setting the column attribute IDs.");
                throw new ExtendedIllegalStateException("columnAttributeIDs", 4);
            }
            this.validateRowList("Attempting to get the column object");
            this.validateListPosition("Attempting to get the current object");
            if (columnIndex < 0 || columnIndex >= this.columnAttributeIDs_.length) {
                throw new ExtendedIllegalArgumentException("columnIndex", 4);
            }
            this.resourceList_.open();
            if (!this.resourceList_.isResourceAvailable(columnIndex)) {
                this.resourceList_.waitForResource(columnIndex);
            }
            if (this.columnAttributeIDs_[columnIndex] == null) {
                return this.resourceList_.resourceAt(this.position_).getPresentation().getName();
            }
            ResourceMetaData meta = this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[columnIndex]);
            if (meta.getPossibleValuePresentation(attributeValue = this.resourceList_.resourceAt(this.position_).getAttributeValue(this.columnAttributeIDs_[columnIndex])) != null) {
                return meta.getPossibleValuePresentation(attributeValue).getName();
            }
            return attributeValue;
        }
        catch (ResourceException e) {
            throw new RowDataException(e);
        }
    }

    @Override
    public Vector getObjectProperties(int columnIndex) {
        this.validateRowList("Attempting to get the column object's properties");
        this.validateListPosition("Attempting to get the current object's properties");
        if (columnIndex < 0 || columnIndex >= this.columnAttributeIDs_.length) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        return new Vector();
    }

    public ResourceList getResourceList() {
        return this.resourceList_;
    }

    @Override
    public int length() {
        return this.getListLength();
    }

    public void setColumnAttributeIDs(Object[] columnAttributeIDs) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Setting the column attribute IDs.");
        }
        if (columnAttributeIDs == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        Object[] old = this.columnAttributeIDs_;
        this.columnAttributeIDs_ = columnAttributeIDs;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("columnAttributeIDs", old, columnAttributeIDs);
        }
        if (this.metadata_ == null) {
            this.metadata_ = new ResourceListMetaData();
        }
        this.metadata_.setColumnAttributeIDs(columnAttributeIDs);
    }

    void setMetaData(ResourceList resourceList, Object[] columnAttributeIDs) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        if (columnAttributeIDs == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        if (columnAttributeIDs.length == 0) {
            throw new ExtendedIllegalArgumentException("columnAttributeIDs", 4);
        }
        ResourceListMetaData old = this.metadata_;
        this.metadata_ = new ResourceListMetaData(resourceList, columnAttributeIDs);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("metadata", old, this.metadata_);
        }
    }

    public void setResourceList(ResourceList resourceList) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Setting the resource list.");
        }
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        ResourceList old = this.resourceList_;
        this.resourceList_ = resourceList;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("resourceList", old, resourceList);
        }
        if (this.metadata_ == null) {
            this.metadata_ = new ResourceListMetaData();
        }
        this.metadata_.setResourceList(resourceList);
    }
}

