/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ByteUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class ClickHouseByteUtils {
    private static final ByteUtils BU = new ByteUtils(ByteOrder.LITTLE_ENDIAN);

    private static int indexOfFull(byte[] bytes, int bpos, int blen, byte[] search, int spos, int slen) {
        int len = bpos + blen - slen + 1;
        block0: for (int i = bpos; i < len; ++i) {
            int l = slen;
            for (int j = 0; j < l; ++j) {
                if (bytes[i + j] != search[j + spos]) continue block0;
            }
            return i;
        }
        return -1;
    }

    private static int indexOfPartial(byte[] bytes, int bpos, int blen, byte[] search, int spos, int slen) {
        int matchedPos = -1;
        int len = bpos + blen;
        for (int i = bpos; i < len; ++i) {
            block3: {
                int l = Math.min(slen, len - i);
                for (int j = 0; j < l; ++j) {
                    if (bytes[i + j] == search[j + spos]) {
                        if (matchedPos != -1) continue;
                        matchedPos = i;
                        continue;
                    }
                    break block3;
                }
                return i;
            }
            matchedPos = -1;
        }
        return matchedPos;
    }

    public static boolean equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        return BU.equals(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex);
    }

    public static short getInt16(byte[] bytes, int offset) {
        return BU.getInt16(bytes, offset);
    }

    public static void setInt16(byte[] bytes, int offset, short value) {
        BU.setInt16(bytes, offset, value);
    }

    public static int getInt32(byte[] bytes, int offset) {
        return BU.getInt32(bytes, offset);
    }

    public static void setInt32(byte[] bytes, int offset, int value) {
        BU.setInt32(bytes, offset, value);
    }

    public static long getInt64(byte[] bytes, int offset) {
        return BU.getInt64(bytes, offset);
    }

    public static void setInt64(byte[] bytes, int offset, long value) {
        BU.setInt64(bytes, offset, value);
    }

    public static float getFloat32(byte[] bytes, int offset) {
        return BU.getFloat32(bytes, offset);
    }

    public static void setFloat32(byte[] bytes, int offset, float value) {
        BU.setFloat32(bytes, offset, value);
    }

    public static double getFloat64(byte[] bytes, int offset) {
        return BU.getFloat64(bytes, offset);
    }

    public static void setFloat64(byte[] bytes, int offset, double value) {
        BU.setFloat64(bytes, offset, value);
    }

    public static byte[] getOrCopy(ByteBuffer buffer, int length) {
        byte[] bytes;
        if (buffer == null || length <= 0) {
            return new byte[0];
        }
        if (buffer.hasArray() && length == buffer.capacity()) {
            bytes = buffer.array();
        } else {
            int position = buffer.position();
            bytes = new byte[length];
            buffer.get(bytes);
            ((Buffer)buffer).position(position);
        }
        return bytes;
    }

    public static int indexOf(byte[] bytes, byte[] search) {
        if (bytes == null || search == null) {
            return -1;
        }
        return ClickHouseByteUtils.indexOf(bytes, 0, bytes.length, search, 0, search.length, false);
    }

    public static int indexOf(byte[] bytes, int bpos, int blen, byte[] search, int spos, int slen) {
        return ClickHouseByteUtils.indexOf(bytes, bpos, blen, search, spos, slen, false);
    }

    public static int indexOf(byte[] bytes, int bpos, int blen, byte[] search, int spos, int slen, boolean partial) {
        if (bytes == null || search == null || bpos < 0 || blen <= 0 || spos < 0 || slen < 0 || bytes.length < bpos + blen || search.length < spos + slen || !partial && blen < slen) {
            return -1;
        }
        if (slen == 0) {
            return 0;
        }
        return partial ? ClickHouseByteUtils.indexOfPartial(bytes, bpos, blen, search, spos, slen) : ClickHouseByteUtils.indexOfFull(bytes, bpos, blen, search, spos, slen);
    }

    public static int getVarIntSize(int value) {
        int result = 0;
        do {
            ++result;
        } while ((value >>>= 7) != 0);
        return result;
    }

    public static int getVarLongSize(long value) {
        int result = 0;
        do {
            ++result;
        } while ((value >>>= 7) != 0L);
        return result;
    }

    public static int getVarInt(ByteBuffer buffer) {
        long result = 0L;
        int shift = 0;
        for (int i = 0; i < 9; ++i) {
            byte b = buffer.get();
            result |= (long)((b & 0x7F) << shift);
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return (int)result;
    }

    public static void setVarInt(ByteBuffer buffer, int value) {
        while ((value & 0xFFFFFF80) != 0) {
            buffer.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        buffer.put((byte)(value & 0x7F));
    }

    public static int readVarInt(InputStream input) throws IOException {
        long result = 0L;
        int shift = 0;
        for (int i = 0; i < 9; ++i) {
            int b = input.read();
            if (b == -1) {
                try {
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new EOFException();
            }
            result |= (long)((b & 0x7F) << shift);
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return (int)result;
    }

    public static void writeVarInt(OutputStream output, long value) throws IOException {
        for (int i = 0; i < 9; ++i) {
            byte b = (byte)(value & 0x7FL);
            if (value > 127L) {
                b = (byte)(b | 0x80);
            }
            output.write(b);
            if ((value >>= 7) != 0L) continue;
            return;
        }
    }

    private ClickHouseByteUtils() {
    }
}

