/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.logger;

import java.util.ArrayList;

public enum LogLevel {
    OFF,
    ERROR,
    INFO,
    FUNCTION,
    DEBUG;

    private static ArrayList<String> names;

    public static LogLevel getLogLevel(int level) {
        switch (level) {
            case 0: {
                return OFF;
            }
            case 1: {
                return ERROR;
            }
            case 2: {
                return INFO;
            }
            case 3: {
                return FUNCTION;
            }
            case 4: 
            case 5: 
            case 6: {
                return DEBUG;
            }
        }
        return OFF;
    }

    public static LogLevel getLogLevel(String level) {
        LogLevel logLevel = OFF;
        if (null == level || level.equals("")) {
            return logLevel;
        }
        if (level.equalsIgnoreCase("OFF")) {
            logLevel = OFF;
        } else if (level.equalsIgnoreCase("ERROR")) {
            logLevel = ERROR;
        } else if (level.equalsIgnoreCase("INFO")) {
            logLevel = INFO;
        } else if (level.equalsIgnoreCase("FUNCTION")) {
            logLevel = FUNCTION;
        } else if (level.equalsIgnoreCase("DEBUG") || level.equalsIgnoreCase("TRACE")) {
            logLevel = DEBUG;
        } else {
            try {
                logLevel = LogLevel.getLogLevel(Integer.parseInt(level));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return logLevel;
    }

    static {
        names = new ArrayList();
        names.add("OFF");
        names.add("ERROR");
        names.add("INFO");
        names.add("FUNCTION");
        names.add("DEBUG");
    }
}

