/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.ExecutorProvider;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.connection.AsyncStatementResult;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.common.base.Preconditions;

class AsyncStatementResultImpl
implements AsyncStatementResult {
    private final StatementResult.ResultType type;
    private final StatementResult.ClientSideStatementType clientSideStatementType;
    private final AsyncResultSet resultSet;
    private final ApiFuture<Long> updateCount;
    private final ApiFuture<Void> noResult;

    static AsyncStatementResult of(AsyncResultSet resultSet) {
        return new AsyncStatementResultImpl((AsyncResultSet)Preconditions.checkNotNull((Object)resultSet), null);
    }

    static AsyncStatementResult of(ApiFuture<Long> updateCount) {
        return new AsyncStatementResultImpl((ApiFuture<Long>)((ApiFuture)Preconditions.checkNotNull(updateCount)));
    }

    static AsyncStatementResult of(StatementResult clientSideStatementResult, ExecutorProvider executorProvider) {
        Preconditions.checkNotNull((Object)((Object)clientSideStatementResult.getClientSideStatementType()));
        Preconditions.checkNotNull((Object)executorProvider);
        if (clientSideStatementResult.getResultType() == StatementResult.ResultType.RESULT_SET) {
            return new AsyncStatementResultImpl(ResultSets.toAsyncResultSet(clientSideStatementResult.getResultSet(), executorProvider, new Options.QueryOption[0]), clientSideStatementResult.getClientSideStatementType());
        }
        return new AsyncStatementResultImpl(clientSideStatementResult.getClientSideStatementType(), (ApiFuture<Void>)ApiFutures.immediateFuture(null));
    }

    static AsyncStatementResult noResult(ApiFuture<Void> result) {
        return new AsyncStatementResultImpl(null, (ApiFuture<Void>)((ApiFuture)Preconditions.checkNotNull(result)));
    }

    private AsyncStatementResultImpl(AsyncResultSet resultSet, StatementResult.ClientSideStatementType clientSideStatementType) {
        this.type = StatementResult.ResultType.RESULT_SET;
        this.clientSideStatementType = clientSideStatementType;
        this.resultSet = resultSet;
        this.updateCount = null;
        this.noResult = null;
    }

    private AsyncStatementResultImpl(ApiFuture<Long> updateCount) {
        this.type = StatementResult.ResultType.UPDATE_COUNT;
        this.clientSideStatementType = null;
        this.resultSet = null;
        this.updateCount = updateCount;
        this.noResult = null;
    }

    private AsyncStatementResultImpl(StatementResult.ClientSideStatementType clientSideStatementType, ApiFuture<Void> result) {
        this.type = StatementResult.ResultType.NO_RESULT;
        this.clientSideStatementType = clientSideStatementType;
        this.resultSet = null;
        this.updateCount = null;
        this.noResult = result;
    }

    @Override
    public StatementResult.ResultType getResultType() {
        return this.type;
    }

    @Override
    public StatementResult.ClientSideStatementType getClientSideStatementType() {
        return this.clientSideStatementType;
    }

    @Override
    public ResultSet getResultSet() {
        return this.getResultSetAsync();
    }

    @Override
    public Long getUpdateCount() {
        return SpannerApiFutures.get(this.getUpdateCountAsync());
    }

    @Override
    public AsyncResultSet getResultSetAsync() {
        ConnectionPreconditions.checkState(this.resultSet != null, "This result does not contain a ResultSet");
        return this.resultSet;
    }

    @Override
    public ApiFuture<Long> getUpdateCountAsync() {
        ConnectionPreconditions.checkState(this.updateCount != null, "This result does not contain an update count");
        return this.updateCount;
    }

    @Override
    public ApiFuture<Void> getNoResultAsync() {
        ConnectionPreconditions.checkState(this.type == StatementResult.ResultType.NO_RESULT, "This result does not contain a 'no-result' result");
        return this.noResult;
    }
}

