/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.type.CqlVectorType;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.guava.common.base.Splitter;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import com.datastax.oss.driver.shaded.guava.common.collect.Streams;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class CqlVectorCodec<SubtypeT>
implements TypeCodec<CqlVector<SubtypeT>> {
    private final CqlVectorType cqlType;
    private final GenericType<CqlVector<SubtypeT>> javaType;
    private final TypeCodec<SubtypeT> subtypeCodec;

    public CqlVectorCodec(CqlVectorType cqlType, TypeCodec<SubtypeT> subtypeCodec) {
        this.cqlType = cqlType;
        this.subtypeCodec = subtypeCodec;
        this.javaType = GenericType.vectorOf(subtypeCodec.getJavaType());
    }

    @Override
    @NonNull
    public GenericType<CqlVector<SubtypeT>> getJavaType() {
        return this.javaType;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable CqlVector<SubtypeT> value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null || this.cqlType.getDimensions() <= 0) {
            return null;
        }
        ByteBuffer[] valueBuffs = new ByteBuffer[this.cqlType.getDimensions()];
        Iterator<SubtypeT> values = value.getValues().iterator();
        int allValueBuffsSize = 0;
        for (int i = 0; i < this.cqlType.getDimensions(); ++i) {
            ByteBuffer valueBuff = this.subtypeCodec.encode(values.next(), protocolVersion);
            allValueBuffsSize += valueBuff.limit();
            valueBuff.rewind();
            valueBuffs[i] = valueBuff;
        }
        assert (valueBuffs.length > 0);
        ByteBuffer rv = ByteBuffer.allocate(allValueBuffsSize);
        for (int i = 0; i < this.cqlType.getDimensions(); ++i) {
            rv.put(valueBuffs[i]);
        }
        rv.flip();
        return rv;
    }

    @Override
    @Nullable
    public CqlVector<SubtypeT> decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        int elementSize = Math.floorDiv(bytes.remaining(), this.cqlType.getDimensions());
        if (bytes.remaining() % this.cqlType.getDimensions() != 0) {
            throw new IllegalArgumentException(String.format("Expected elements of uniform size, observed %d elements with total bytes %d", this.cqlType.getDimensions(), bytes.remaining()));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.cqlType.getDimensions(); ++i) {
            ByteBuffer slice = bytes.slice();
            slice.limit(elementSize);
            builder.add(this.subtypeCodec.decode(slice, protocolVersion));
            bytes.position(bytes.position() + elementSize);
        }
        bytes.rewind();
        return CqlVector.builder().addAll(builder.build()).build();
    }

    @Override
    @NonNull
    public String format(@Nullable CqlVector<SubtypeT> value) {
        return value == null ? "NULL" : Iterables.toString(value.getValues());
    }

    @Override
    @Nullable
    public CqlVector<SubtypeT> parse(@Nullable String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        ImmutableList values = (ImmutableList)Streams.stream((Iterable)Splitter.on((String)", ").split((CharSequence)value.substring(1, value.length() - 1))).map(this.subtypeCodec::parse).collect(ImmutableList.toImmutableList());
        return CqlVector.builder().addAll(values).build();
    }
}

