/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Collections2;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SimpleSelector;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.Difference;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.serializers.MarshalException;
import org.github.jamm.Unmetered;

@Unmetered
public final class ColumnMetadata
extends ColumnSpecification
implements Selectable,
Comparable<ColumnMetadata> {
    public static final Comparator<Object> asymmetricColumnDataComparator = (a, b) -> ((ColumnData)a).column().compareTo((ColumnMetadata)b);
    public static final int NO_POSITION = -1;
    public final Kind kind;
    private final int position;
    private final Comparator<CellPath> cellPathComparator;
    private final Comparator<Object> asymmetricCellPathComparator;
    private final Comparator<? super Cell<?>> cellComparator;
    private int hash;
    private final long comparisonOrder;

    private static long comparisonOrder(Kind kind, boolean isComplex, long position, ColumnIdentifier name) {
        assert (position >= 0L && position < 4096L);
        return (long)kind.ordinal() << 61 | (isComplex ? 0x1000000000000000L : 0L) | position << 48 | name.prefixComparison >>> 16;
    }

    public static ColumnMetadata partitionKeyColumn(TableMetadata table, ByteBuffer name, AbstractType<?> type, int position) {
        return new ColumnMetadata(table, name, type, position, Kind.PARTITION_KEY);
    }

    public static ColumnMetadata partitionKeyColumn(String keyspace, String table, String name, AbstractType<?> type, int position) {
        return new ColumnMetadata(keyspace, table, ColumnIdentifier.getInterned(name, true), type, position, Kind.PARTITION_KEY);
    }

    public static ColumnMetadata clusteringColumn(TableMetadata table, ByteBuffer name, AbstractType<?> type, int position) {
        return new ColumnMetadata(table, name, type, position, Kind.CLUSTERING);
    }

    public static ColumnMetadata clusteringColumn(String keyspace, String table, String name, AbstractType<?> type, int position) {
        return new ColumnMetadata(keyspace, table, ColumnIdentifier.getInterned(name, true), type, position, Kind.CLUSTERING);
    }

    public static ColumnMetadata regularColumn(TableMetadata table, ByteBuffer name, AbstractType<?> type) {
        return new ColumnMetadata(table, name, type, -1, Kind.REGULAR);
    }

    public static ColumnMetadata regularColumn(String keyspace, String table, String name, AbstractType<?> type) {
        return new ColumnMetadata(keyspace, table, ColumnIdentifier.getInterned(name, true), type, -1, Kind.REGULAR);
    }

    public static ColumnMetadata staticColumn(TableMetadata table, ByteBuffer name, AbstractType<?> type) {
        return new ColumnMetadata(table, name, type, -1, Kind.STATIC);
    }

    public static ColumnMetadata staticColumn(String keyspace, String table, String name, AbstractType<?> type) {
        return new ColumnMetadata(keyspace, table, ColumnIdentifier.getInterned(name, true), type, -1, Kind.STATIC);
    }

    public ColumnMetadata(TableMetadata table, ByteBuffer name, AbstractType<?> type, int position, Kind kind) {
        this(table.keyspace, table.name, ColumnIdentifier.getInterned(name, UTF8Type.instance), type, position, kind);
    }

    @VisibleForTesting
    public ColumnMetadata(String ksName, String cfName, ColumnIdentifier name, AbstractType<?> type, int position, Kind kind) {
        super(ksName, cfName, name, type);
        assert (name != null && type != null && kind != null);
        assert (position == -1 == !kind.isPrimaryKeyKind());
        this.kind = kind;
        this.position = position;
        this.cellPathComparator = ColumnMetadata.makeCellPathComparator(kind, type);
        this.cellComparator = this.cellPathComparator == null ? ColumnData.comparator : (a, b) -> this.cellPathComparator.compare(a.path(), b.path());
        this.asymmetricCellPathComparator = this.cellPathComparator == null ? null : (a, b) -> this.cellPathComparator.compare(((Cell)a).path(), (CellPath)b);
        this.comparisonOrder = ColumnMetadata.comparisonOrder(kind, this.isComplex(), Math.max(0, position), name);
    }

    private static Comparator<CellPath> makeCellPathComparator(Kind kind, AbstractType<?> type) {
        if (kind.isPrimaryKeyKind() || !type.isMultiCell()) {
            return null;
        }
        ShortType nameComparator = type.isCollection() ? ((CollectionType)type).nameComparator() : ((UserType)type).nameComparator();
        return (path1, path2) -> {
            if (path1.size() == 0 || path2.size() == 0) {
                if (path1 == CellPath.BOTTOM) {
                    return path2 == CellPath.BOTTOM ? 0 : -1;
                }
                if (path1 == CellPath.TOP) {
                    return path2 == CellPath.TOP ? 0 : 1;
                }
                return path2 == CellPath.BOTTOM ? 1 : -1;
            }
            assert (path1.size() == 1 && path2.size() == 1);
            return nameComparator.compare(path1.get(0), path2.get(0));
        };
    }

    public ColumnMetadata copy() {
        return new ColumnMetadata(this.ksName, this.cfName, this.name, this.type, this.position, this.kind);
    }

    public ColumnMetadata withNewName(ColumnIdentifier newName) {
        return new ColumnMetadata(this.ksName, this.cfName, newName, this.type, this.position, this.kind);
    }

    public ColumnMetadata withNewType(AbstractType<?> newType) {
        return new ColumnMetadata(this.ksName, this.cfName, this.name, newType, this.position, this.kind);
    }

    public boolean isPartitionKey() {
        return this.kind == Kind.PARTITION_KEY;
    }

    public boolean isClusteringColumn() {
        return this.kind == Kind.CLUSTERING;
    }

    public boolean isStatic() {
        return this.kind == Kind.STATIC;
    }

    public boolean isRegular() {
        return this.kind == Kind.REGULAR;
    }

    public ClusteringOrder clusteringOrder() {
        if (!this.isClusteringColumn()) {
            return ClusteringOrder.NONE;
        }
        return this.type.isReversed() ? ClusteringOrder.DESC : ClusteringOrder.ASC;
    }

    public int position() {
        return this.position;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnMetadata)) {
            return false;
        }
        ColumnMetadata cd = (ColumnMetadata)o;
        return this.equalsWithoutType(cd) && this.type.equals(cd.type);
    }

    private boolean equalsWithoutType(ColumnMetadata other) {
        return this.name.equals(other.name) && this.kind == other.kind && this.position == other.position && this.ksName.equals(other.ksName) && this.cfName.equals(other.cfName);
    }

    Optional<Difference> compare(ColumnMetadata other) {
        if (!this.equalsWithoutType(other)) {
            return Optional.of(Difference.SHALLOW);
        }
        if (this.type.equals(other.type)) {
            return Optional.empty();
        }
        return this.type.asCQL3Type().toString().equals(other.type.asCQL3Type().toString()) ? Optional.of(Difference.DEEP) : Optional.of(Difference.SHALLOW);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = 31 + (this.ksName == null ? 0 : this.ksName.hashCode());
            result = 31 * result + (this.cfName == null ? 0 : this.cfName.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            this.hash = result = 31 * result + this.position;
        }
        return result;
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("kind", (Object)this.kind).add("position", this.position).toString();
    }

    public boolean isPrimaryKeyColumn() {
        return this.kind.isPrimaryKeyKind();
    }

    @Override
    public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
        return predicate.test(this);
    }

    @Override
    public boolean processesSelection() {
        return false;
    }

    public static Collection<ColumnIdentifier> toIdentifiers(Collection<ColumnMetadata> definitions) {
        return Collections2.transform(definitions, columnDef -> columnDef.name);
    }

    @Override
    public int compareTo(ColumnMetadata other) {
        if (this == other) {
            return 0;
        }
        if (this.comparisonOrder != other.comparisonOrder) {
            return Long.compare(this.comparisonOrder, other.comparisonOrder);
        }
        return this.name.compareTo(other.name);
    }

    public Comparator<CellPath> cellPathComparator() {
        return this.cellPathComparator;
    }

    public Comparator<Object> asymmetricCellPathComparator() {
        return this.asymmetricCellPathComparator;
    }

    public Comparator<? super Cell<?>> cellComparator() {
        return this.cellComparator;
    }

    public boolean isComplex() {
        return this.cellPathComparator != null;
    }

    public boolean isSimple() {
        return !this.isComplex();
    }

    public CellPath.Serializer cellPathSerializer() {
        return CollectionType.cellPathSerializer;
    }

    public <V> void validateCell(Cell<V> cell) {
        if (cell.isTombstone()) {
            if (cell.valueSize() > 0) {
                throw new MarshalException("A tombstone should not have a value");
            }
            if (cell.path() != null) {
                this.validateCellPath(cell.path());
            }
        } else if (this.type.isUDT()) {
            ((UserType)this.type).validateCell(cell);
        } else {
            this.type.validateCellValue(cell.value(), cell.accessor());
            if (cell.path() != null) {
                this.validateCellPath(cell.path());
            }
        }
    }

    private void validateCellPath(CellPath path) {
        if (!this.isComplex()) {
            throw new MarshalException("Only complex cells should have a cell path");
        }
        assert (this.type.isMultiCell());
        if (this.type.isCollection()) {
            ((CollectionType)this.type).nameComparator().validate(path.get(0));
        } else {
            ((UserType)this.type).nameComparator().validate(path.get(0));
        }
    }

    public void appendCqlTo(CqlBuilder builder) {
        builder.append(this.name).append(' ').append(this.type);
        if (this.isStatic()) {
            builder.append(" static");
        }
    }

    public static String toCQLString(Iterable<ColumnMetadata> defs) {
        return ColumnMetadata.toCQLString(defs.iterator());
    }

    public static String toCQLString(Iterator<ColumnMetadata> defs) {
        if (!defs.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(defs.next().name.toCQLString());
        while (defs.hasNext()) {
            sb.append(", ").append(defs.next().name.toCQLString());
        }
        return sb.toString();
    }

    public void appendNameAndOrderTo(CqlBuilder builder) {
        builder.append(this.name.toCQLString()).append(' ').append(this.clusteringOrder().toString());
    }

    public AbstractType<?> cellValueType() {
        assert (!(this.type instanceof UserType) || !this.type.isMultiCell());
        return this.type instanceof CollectionType && this.type.isMultiCell() ? ((CollectionType)this.type).valueComparator() : this.type;
    }

    public boolean isCounterColumn() {
        if (this.type instanceof CollectionType) {
            return ((CollectionType)this.type).valueComparator().isCounter();
        }
        return this.type.isCounter();
    }

    @Override
    public Selector.Factory newSelectorFactory(TableMetadata table, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) throws InvalidRequestException {
        return SimpleSelector.newFactory(this, this.addAndGetIndex(this, defs));
    }

    @Override
    public AbstractType<?> getExactTypeIfKnown(String keyspace) {
        return this.type;
    }

    public static enum Kind {
        PARTITION_KEY,
        CLUSTERING,
        REGULAR,
        STATIC;


        public boolean isPrimaryKeyKind() {
            return this == PARTITION_KEY || this == CLUSTERING;
        }
    }

    public static enum ClusteringOrder {
        ASC,
        DESC,
        NONE;

    }
}

