/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BitConverters;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FloatCoder
extends AtomicCoder<Float> {
    private static final @UnknownKeyFor @NonNull @Initialized FloatCoder INSTANCE = new FloatCoder();
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Float> TYPE_DESCRIPTOR = new TypeDescriptor<Float>(){};

    public static @UnknownKeyFor @NonNull @Initialized FloatCoder of() {
        return INSTANCE;
    }

    private FloatCoder() {
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized Float value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Float");
        }
        new DataOutputStream(outStream).writeFloat(value.floatValue());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Float decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        try {
            return Float.valueOf(Float.intBitsToFloat(BitConverters.readBigEndianInt(inStream)));
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Floating point encodings are not guaranteed to be deterministic.");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized Float value) {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Float> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized Float value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Float");
        }
        return 4L;
    }
}

