/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import java.util.List;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.FileStagingOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.Validation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface PortablePipelineOptions
extends PipelineOptions,
FileStagingOptions {
    @Description(value="Job service endpoint to use. Should be in the form of address and port, e.g. localhost:3000")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized String getJobEndpoint();

    public void setJobEndpoint(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Job service request timeout in seconds. The timeout determines the max time the driver program will wait to get a response from the job server. NOTE: the timeout does not apply to the actual pipeline run time. The driver program will still wait for job completion indefinitely.")
    @Default.Integer(value=60)
    public @UnknownKeyFor @NonNull @Initialized int getJobServerTimeout();

    public void setJobServerTimeout(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Set the default environment type for running user code. Possible options are DOCKER and PROCESS.")
    public @Nullable @UnknownKeyFor @Initialized String getDefaultEnvironmentType();

    public void setDefaultEnvironmentType(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Set environment configuration for running the user code.\n For DOCKER: Url for the docker image.\n For PROCESS: json of the form {\"os\": \"<OS>\", \"arch\": \"<ARCHITECTURE>\", \"command\": \"<process to execute>\", \"env\":{\"<Environment variables 1>\": \"<ENV_VAL>\"} }. All fields in the json are optional except command.")
    public @Nullable @UnknownKeyFor @Initialized String getDefaultEnvironmentConfig();

    public void setDefaultEnvironmentConfig(@Nullable @UnknownKeyFor @Initialized String var1);

    @Description(value="Sets the number of sdk worker processes that will run on each worker node. Default is 1. If 0, it will be automatically set by the runner by looking at different parameters (e.g. number of CPU cores on the worker machine).")
    @Default.Integer(value=1)
    public @UnknownKeyFor @NonNull @Initialized int getSdkWorkerParallelism();

    public void setSdkWorkerParallelism(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Duration in milliseconds for environment cache within a job. 0 means no caching.")
    @Default.Integer(value=0)
    public @UnknownKeyFor @NonNull @Initialized int getEnvironmentCacheMillis();

    public void setEnvironmentCacheMillis(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Duration in milliseconds for environment expiration. 0 means no expiration.")
    @Default.Integer(value=0)
    public @UnknownKeyFor @NonNull @Initialized int getEnvironmentExpirationMillis();

    public void setEnvironmentExpirationMillis(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Specifies if bundles should be distributed to the next available free SDK worker. By default SDK workers are pinned to runner tasks for the duration of the pipeline. This option can help for pipelines with long and skewed bundle execution times to increase throughput and improve worker utilization.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized boolean getLoadBalanceBundles();

    public void setLoadBalanceBundles(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="The output path for the executable file to be created.")
    public @Nullable @UnknownKeyFor @Initialized String getOutputExecutablePath();

    public void setOutputExecutablePath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Options for configuring the default environment of portable workers. This environment will be used for all executable stages except for external transforms. Recognized options depend on the value of defaultEnvironmentType:\nDOCKER: docker_container_image (optional), e.g. 'apache/beam_java8_sdk:latest'. If unset, will default to the latest official release of the Beam Java SDK corresponding to your Java runtime version (8 or 11).\nEXTERNAL: external_service_address (required), e.g. 'localhost:50000'\nPROCESS: process_command (required), process_variables (optional). process_command must be the location of an executable file that starts a Beam SDK worker. process_variables is a comma-separated list of environment variable assignments which will be set before running the process, e.g. 'FOO=a,BAR=b'\n\nenvironmentOptions and defaultEnvironmentConfig are mutually exclusive. Prefer environmentOptions.")
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getEnvironmentOptions();

    public void setEnvironmentOptions(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

    public static @UnknownKeyFor @NonNull @Initialized String getEnvironmentOption(@UnknownKeyFor @NonNull @Initialized PortablePipelineOptions options, @UnknownKeyFor @NonNull @Initialized String environmentOptionName) {
        List<String> environmentOptions = options.getEnvironmentOptions();
        if (environmentOptions == null) {
            return "";
        }
        for (String environmentEntry : environmentOptions) {
            String[] tokens = environmentEntry.split(environmentOptionName + "=", -1);
            if (tokens.length <= 1) continue;
            return tokens[1];
        }
        return "";
    }

    @Description(value="If {@literal true} and PipelineOption tempLocation is set, save a heap dump before shutting down the JVM due to GC thrashing or out of memory. The heap will be dumped to local disk and then uploaded to the tempLocation.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized boolean getEnableHeapDumps();

    public void setEnableHeapDumps(@UnknownKeyFor @NonNull @Initialized boolean var1);
}

