/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.classic;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.support.BasicHttpServerExpectationDecorator;
import org.apache.hc.core5.http.io.support.BasicHttpServerRequestHandler;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.testing.classic.LoggingBHttpServerConnectionFactory;
import org.apache.hc.core5.testing.classic.LoggingExceptionListener;
import org.apache.hc.core5.testing.classic.LoggingHttp1StreamListener;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public class ClassicTestServer {
    private final SSLContext sslContext;
    private final SocketConfig socketConfig;
    private final List<RequestRouter.Entry<HttpRequestHandler>> routeEntries;
    private final AtomicReference<HttpServer> serverRef;
    private Http1Config http1Config;
    private HttpProcessor httpProcessor;
    private Decorator<HttpServerRequestHandler> handlerDecorator;

    public ClassicTestServer(SSLContext sslContext, SocketConfig socketConfig) {
        this.sslContext = sslContext;
        this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
        this.routeEntries = new ArrayList<RequestRouter.Entry<HttpRequestHandler>>();
        this.serverRef = new AtomicReference();
    }

    public ClassicTestServer(SocketConfig socketConfig) {
        this(null, socketConfig);
    }

    public ClassicTestServer() {
        this(null, null);
    }

    @Deprecated
    public void registerHandler(String pattern, HttpRequestHandler handler) {
        this.register(pattern, handler);
    }

    @Deprecated
    public void registerHandlerVirtual(String hostname, String pattern, HttpRequestHandler handler) {
        this.register(hostname, pattern, handler);
    }

    private HttpServer ensureRunning() {
        HttpServer server = this.serverRef.get();
        Asserts.check((server != null ? 1 : 0) != 0, (String)"Server is not running");
        return server;
    }

    private void ensureNotRunning() {
        HttpServer server = this.serverRef.get();
        Asserts.check((server == null ? 1 : 0) != 0, (String)"Server is already running");
    }

    public void register(String uriPattern, HttpRequestHandler handler) {
        Args.notNull((Object)uriPattern, (String)"URI pattern");
        Args.notNull((Object)handler, (String)"Request handler");
        this.ensureNotRunning();
        this.routeEntries.add((RequestRouter.Entry<HttpRequestHandler>)new RequestRouter.Entry(uriPattern, (Object)handler));
    }

    public void register(String hostname, String uriPattern, HttpRequestHandler handler) {
        Args.notNull((Object)hostname, (String)"Hostname");
        Args.notNull((Object)uriPattern, (String)"URI pattern");
        Args.notNull((Object)handler, (String)"Request handler");
        this.ensureNotRunning();
        this.routeEntries.add((RequestRouter.Entry<HttpRequestHandler>)new RequestRouter.Entry(hostname, uriPattern, (Object)handler));
    }

    public void configure(Http1Config http1Config) {
        this.ensureNotRunning();
        this.http1Config = http1Config;
    }

    public void configure(HttpProcessor httpProcessor) {
        this.ensureNotRunning();
        this.httpProcessor = httpProcessor;
    }

    public void configure(Decorator<HttpServerRequestHandler> handlerDecorator) {
        this.ensureNotRunning();
        this.handlerDecorator = handlerDecorator;
    }

    public int getPort() {
        HttpServer server = this.ensureRunning();
        return server.getLocalPort();
    }

    public InetAddress getInetAddress() {
        HttpServer server = this.ensureRunning();
        return server.getInetAddress();
    }

    @Deprecated
    public void start(Http1Config http1Config, HttpProcessor httpProcessor, Decorator<HttpServerRequestHandler> handlerDecorator) throws IOException {
        this.configure(http1Config);
        this.configure(httpProcessor);
        this.configure(handlerDecorator);
        this.start();
    }

    public void start() throws IOException {
        if (this.serverRef.get() == null) {
            BasicHttpServerRequestHandler handler = new BasicHttpServerRequestHandler((HttpRequestMapper)RequestRouter.create((URIAuthority)RequestRouter.LOCAL_AUTHORITY, (UriPatternType)UriPatternType.URI_PATTERN, this.routeEntries, (BiFunction)RequestRouter.LOCAL_AUTHORITY_RESOLVER, null));
            HttpService httpService = new HttpService(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), (HttpServerRequestHandler)(this.handlerDecorator != null ? (HttpServerRequestHandler)this.handlerDecorator.decorate((Object)handler) : new BasicHttpServerExpectationDecorator((HttpServerRequestHandler)handler)), (ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE, (Http1StreamListener)LoggingHttp1StreamListener.INSTANCE);
            HttpServer server = new HttpServer(0, httpService, null, this.socketConfig, null, (HttpConnectionFactory)new LoggingBHttpServerConnectionFactory(this.sslContext != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id, this.http1Config != null ? this.http1Config : Http1Config.DEFAULT, CharCodingConfig.DEFAULT), this.sslContext, null, (ExceptionListener)LoggingExceptionListener.INSTANCE);
            if (this.serverRef.compareAndSet(null, server)) {
                server.start();
            }
        } else {
            throw new IllegalStateException("Server already running");
        }
    }

    public void shutdown(CloseMode closeMode) {
        HttpServer server = this.serverRef.getAndSet(null);
        if (server != null) {
            server.close(closeMode);
        }
    }
}

