/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlQualifiedName;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SqlCreateViewCommand
implements SqlCommand {
    private String schemaName;
    private String viewName;
    private String viewSql;
    private boolean replace;

    public SqlCreateViewCommand() {
    }

    public SqlCreateViewCommand(String schemaName, String viewName, String viewSql, boolean replace) {
        this.schemaName = schemaName;
        this.viewName = viewName;
        this.viewSql = viewSql;
        this.replace = replace;
    }

    public String viewName() {
        return this.viewName;
    }

    public String viewSql() {
        return this.viewSql;
    }

    public boolean replace() {
        return this.replace;
    }

    public SqlCreateViewCommand replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    @Override
    public String schemaName() {
        return this.schemaName;
    }

    @Override
    public void schemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public SqlCommand parse(SqlLexer lex) {
        SqlQualifiedName viewQName = SqlParserUtils.parseQualifiedIdentifier(lex, new String[0]);
        this.schemaName = viewQName.schemaName();
        this.viewName = viewQName.name();
        SqlParserUtils.skipIfMatchesKeyword(lex, "AS");
        SqlParserUtils.skipIfMatchesKeyword(lex, "SELECT");
        int viewSqlPos = lex.tokenPosition();
        while (lex.shift() && lex.lookAhead().tokenType() != SqlLexerTokenType.SEMICOLON) {
        }
        this.viewSql = lex.eod() ? lex.sql().substring(viewSqlPos) : lex.sql().substring(viewSqlPos, lex.position());
        return this;
    }

    public String toString() {
        return S.toString(SqlCreateViewCommand.class, this);
    }
}

