/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexPlainRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexTree;
import org.apache.ignite.internal.cache.query.index.sorted.inline.SortedSegmentedIndexCursor;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InlineIO;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.transactions.TransactionChanges;
import org.apache.ignite.internal.processors.query.calcite.exec.AbstractCacheColumnsScan;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.KeyFilteringCursor;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.SortedListRangeCursor;
import org.apache.ignite.internal.processors.query.calcite.exec.TreeIndex;
import org.apache.ignite.internal.processors.query.calcite.exec.TreeIndexIterable;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.TransformRangeIterable;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilterImpl;
import org.jetbrains.annotations.Nullable;

public class IndexScan<Row>
extends AbstractCacheColumnsScan<Row> {
    private final GridKernalContext kctx;
    private final RangeIterable<Row> ranges;
    protected final InlineIndex idx;
    private final ImmutableIntList idxFieldMapping;
    private final int[] fieldIdxMapping;
    private final Type[] fieldsStoreTypes;
    private final TransactionChanges<IndexRow> txChanges;

    public IndexScan(ExecutionContext<Row> ectx, CacheTableDescriptor desc, InlineIndex idx, ImmutableIntList idxFieldMapping, int[] parts, RangeIterable<Row> ranges, @Nullable ImmutableBitSet requiredColumns) {
        super(ectx, desc, parts, requiredColumns);
        this.ranges = ranges;
        this.idx = idx;
        this.kctx = this.cctx.kernalContext();
        this.idxFieldMapping = idxFieldMapping;
        RelDataType srcRowType = desc.rowType(ectx.getTypeFactory(), null);
        IgniteTypeFactory typeFactory = ectx.getTypeFactory();
        this.fieldsStoreTypes = new Type[srcRowType.getFieldCount()];
        for (int i = 0; i < srcRowType.getFieldCount(); ++i) {
            this.fieldsStoreTypes[i] = typeFactory.getResultClass(((RelDataTypeField)srcRowType.getFieldList().get(i)).getType());
        }
        this.fieldIdxMapping = this.fieldToInlinedKeysMapping(srcRowType.getFieldCount());
        if (!F.isEmpty(ectx.getQryTxEntries())) {
            InlineIndexRowHandler rowHnd = idx.segment(0).rowHandler();
            this.txChanges = ectx.transactionChanges(this.cctx.cacheId(), parts, r -> new IndexRowImpl(rowHnd, r), this::compare);
        } else {
            this.txChanges = TransactionChanges.empty();
        }
    }

    private int[] fieldToInlinedKeysMapping(int srcFieldsCnt) {
        List inlinedKeys = this.idx.segment(0).rowHandler().inlineIndexKeyTypes();
        if (!this.cctx.config().isEagerTtl()) {
            return null;
        }
        if (inlinedKeys.size() < this.idx.segment(0).rowHandler().indexKeyDefinitions().size() || inlinedKeys.size() < (this.requiredColumns == null ? srcFieldsCnt : this.requiredColumns.cardinality())) {
            return null;
        }
        for (InlineIndexKeyType keyType : inlinedKeys) {
            if (keyType.keySize() >= 0 && keyType.type() != IndexKeyType.JAVA_OBJECT) continue;
            return null;
        }
        ImmutableBitSet reqCols = this.requiredColumns == null ? ImmutableBitSet.range((int)0, (int)srcFieldsCnt) : this.requiredColumns;
        int[] fieldIdxMapping = new int[this.rowType.getFieldCount()];
        int i = 0;
        int j = reqCols.nextSetBit(0);
        while (j != -1) {
            int keyIdx = this.idxFieldMapping.indexOf(j);
            if (keyIdx < 0 || keyIdx >= inlinedKeys.size()) {
                return null;
            }
            fieldIdxMapping[i] = keyIdx;
            j = reqCols.nextSetBit(j + 1);
            ++i;
        }
        return fieldIdxMapping;
    }

    @Override
    protected Iterator<Row> createIterator() {
        TransformRangeIterable<Object, IndexRow> ranges0 = this.ranges == null ? null : new TransformRangeIterable<Object, IndexRow>(this.ranges, this::row2indexRow);
        TxAwareTreeIndexWrapper treeIdx = this.treeIndex();
        if (!this.txChanges.changedKeysEmpty()) {
            treeIdx = new TxAwareTreeIndexWrapper(treeIdx);
        }
        return F.iterator(new TreeIndexIterable<IndexRow>(treeIdx, ranges0), this::indexRow2Row, (boolean)true, (IgnitePredicate[])new IgnitePredicate[0]);
    }

    protected TreeIndex<IndexRow> treeIndex() {
        return new TreeIndexWrapper(this.idx, this.indexQueryContext());
    }

    protected IndexRow row2indexRow(Row bound) {
        if (bound == null) {
            return null;
        }
        InlineIndexRowHandler idxRowHnd = this.idx.segment(0).rowHandler();
        RowHandler<Row> rowHnd = this.ectx.rowHandler();
        IndexKey[] keys = new IndexKey[idxRowHnd.indexKeyDefinitions().size()];
        assert (keys.length >= this.idxFieldMapping.size()) : "Unexpected index keys [keys.length=" + keys.length + ", idxFieldMapping.size()=" + this.idxFieldMapping.size() + "]";
        boolean nullSearchRow = true;
        for (int i = 0; i < this.idxFieldMapping.size(); ++i) {
            int fieldIdx = this.idxFieldMapping.getInt(i);
            Object key = rowHnd.get(fieldIdx, bound);
            if (key == this.ectx.unspecifiedValue()) continue;
            key = TypeUtils.fromInternal(this.ectx, key, this.fieldsStoreTypes[fieldIdx]);
            keys[i] = IndexKeyFactory.wrap((Object)key, (IndexKeyType)((IndexKeyDefinition)idxRowHnd.indexKeyDefinitions().get(i)).idxType(), (CacheObjectValueContext)this.cctx.cacheObjectContext(), (IndexKeyTypeSettings)idxRowHnd.indexKeyTypeSettings());
            nullSearchRow = false;
        }
        return nullSearchRow ? null : new IndexPlainRowImpl(keys, idxRowHnd);
    }

    protected Row indexRow2Row(IndexRow row) {
        try {
            if (row.indexPlainRow()) {
                return this.inlineIndexRow2Row(row);
            }
            return this.desc.toRow(this.ectx, row.cacheDataRow(), this.factory, this.requiredColumns);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private Row inlineIndexRow2Row(IndexRow row) {
        RowHandler hnd = this.ectx.rowHandler();
        Object res = this.factory.create();
        for (int i = 0; i < this.fieldIdxMapping.length; ++i) {
            hnd.set(i, res, TypeUtils.toInternal(this.ectx, row.key(this.fieldIdxMapping[i]).key()));
        }
        return res;
    }

    protected IndexQueryContext indexQueryContext() {
        IndexingQueryFilterImpl filter = new IndexingQueryFilterImpl(this.kctx, this.topVer, this.parts);
        InlineIndexRowHandler rowHnd = this.idx.segment(0).rowHandler();
        InlineIndexRowFactory rowFactory = this.isInlineScan() && this.txChanges.changedKeysEmpty() ? new InlineIndexRowFactory(rowHnd.inlineIndexKeyTypes().toArray(new InlineIndexKeyType[0]), rowHnd) : null;
        BPlusTree.TreeRowClosure<IndexRow, IndexRow> rowFilter = this.isInlineScan() ? null : IndexScan.createNotExpiredRowFilter();
        return new IndexQueryContext((IndexingQueryFilter)filter, rowFilter, (BPlusTree.TreeRowFactory)rowFactory);
    }

    public boolean isInlineScan() {
        return this.fieldIdxMapping != null;
    }

    public static BPlusTree.TreeRowClosure<IndexRow, IndexRow> createNotNullRowFilter(InlineIndex idx, final boolean checkExpired) {
        List inlineKeyTypes = idx.segment(0).rowHandler().inlineIndexKeyTypes();
        final InlineIndexKeyType keyType = F.isEmpty((Collection)inlineKeyTypes) ? null : (InlineIndexKeyType)inlineKeyTypes.get(0);
        return new BPlusTree.TreeRowClosure<IndexRow, IndexRow>(){
            private IndexRow idxRow;

            public boolean apply(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
                Boolean keyIsNull;
                if (!checkExpired && keyType != null && io instanceof InlineIO && (keyIsNull = keyType.isNull(pageAddr, io.offset(idx), ((InlineIO)io).inlineSize())) == Boolean.TRUE) {
                    this.idxRow = null;
                    return false;
                }
                this.idxRow = (IndexRow)io.getLookupRow(tree, pageAddr, idx);
                if (checkExpired && this.idxRow.cacheDataRow().expireTime() > 0L && this.idxRow.cacheDataRow().expireTime() <= U.currentTimeMillis()) {
                    return false;
                }
                return this.idxRow.key(0).type() != IndexKeyType.NULL;
            }

            public IndexRow lastRow() {
                return this.idxRow;
            }
        };
    }

    public static BPlusTree.TreeRowClosure<IndexRow, IndexRow> createNotExpiredRowFilter() {
        return new BPlusTree.TreeRowClosure<IndexRow, IndexRow>(){
            private IndexRow idxRow;

            public boolean apply(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
                this.idxRow = (IndexRow)io.getLookupRow(tree, pageAddr, idx);
                return this.idxRow.cacheDataRow().expireTime() <= 0L || this.idxRow.cacheDataRow().expireTime() > U.currentTimeMillis();
            }

            public IndexRow lastRow() {
                return this.idxRow;
            }
        };
    }

    private int compare(IndexRow o1, IndexRow o2) {
        try {
            return InlineIndexTree.compareFullRows((IndexRow)o1, (IndexRow)o2, (int)0, (InlineIndexRowHandler)this.idx.segment(0).rowHandler(), (IndexRowComparator)this.idx.indexDefinition().rowComparator());
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    protected static class TreeIndexWrapper
    implements TreeIndex<IndexRow> {
        protected final InlineIndex idx;
        protected final IndexQueryContext qctx;

        protected TreeIndexWrapper(InlineIndex idx, IndexQueryContext qctx) {
            this.idx = idx;
            this.qctx = qctx;
        }

        @Override
        public GridCursor<IndexRow> find(IndexRow lower, IndexRow upper, boolean lowerInclude, boolean upperInclude) {
            try {
                return this.idx.find(lower, upper, lowerInclude, upperInclude, this.qctx);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to find index rows", (Throwable)e);
            }
        }
    }

    protected class TxAwareTreeIndexWrapper
    implements TreeIndex<IndexRow> {
        private final TreeIndex<IndexRow> delegate;

        protected TxAwareTreeIndexWrapper(TreeIndex<IndexRow> delegate) {
            this.delegate = delegate;
        }

        @Override
        public GridCursor<IndexRow> find(IndexRow lower, IndexRow upper, boolean lowerInclude, boolean upperInclude) {
            GridCursor<IndexRow> idxCursor = this.delegate.find(lower, upper, lowerInclude, upperInclude);
            try {
                return new SortedSegmentedIndexCursor(new GridCursor[]{new KeyFilteringCursor<IndexRow>(idxCursor, IndexScan.this.txChanges, r -> r.cacheDataRow().key()), new SortedListRangeCursor<IndexRow>((x$0, x$1) -> IndexScan.this.compare((IndexRow)x$0, (IndexRow)x$1), IndexScan.this.txChanges.newAndUpdatedEntries(), lower, upper, lowerInclude, upperInclude)}, IndexScan.this.idx.indexDefinition());
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
        }
    }

    private static class InlineIndexRowFactory
    implements BPlusTree.TreeRowFactory<IndexRow, IndexRow> {
        private final InlineIndexKeyType[] keyTypes;
        private final InlineIndexRowHandler idxRowHnd;
        private boolean useCacheRow;

        private InlineIndexRowFactory(InlineIndexKeyType[] keyTypes, InlineIndexRowHandler idxRowHnd) {
            this.keyTypes = keyTypes;
            this.idxRowHnd = idxRowHnd;
        }

        public IndexRow create(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
            if (this.useCacheRow) {
                return (IndexRow)io.getLookupRow(tree, pageAddr, idx);
            }
            int inlineSize = ((InlineIO)io).inlineSize();
            int rowOffset = io.offset(idx);
            int keyOffset = 0;
            IndexKey[] keys = new IndexKey[this.keyTypes.length];
            for (int keyIdx = 0; keyIdx < this.keyTypes.length; ++keyIdx) {
                InlineIndexKeyType keyType = this.keyTypes[keyIdx];
                if (!keyType.inlinedFullValue(pageAddr, rowOffset + keyOffset, inlineSize - keyOffset)) {
                    this.useCacheRow = true;
                    return (IndexRow)io.getLookupRow(tree, pageAddr, idx);
                }
                keys[keyIdx] = keyType.get(pageAddr, rowOffset + keyOffset, inlineSize - keyOffset);
                keyOffset += keyType.inlineSize(pageAddr, rowOffset + keyOffset);
            }
            return new IndexPlainRowImpl(keys, this.idxRowHnd);
        }
    }
}

