/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.util.ColocationUtils;
import org.apache.ignite.internal.util.HashCalculator;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class PartitionCalculator {
    private final HashCalculator hashCalculator = new HashCalculator();
    private final NativeType[] types;
    private final int partitionCount;
    private int currentField = 0;

    public PartitionCalculator(int partitionCount, NativeType[] types) {
        this.partitionCount = partitionCount;
        this.types = types;
    }

    public void append(@Nullable Object value) {
        assert (this.currentField < this.types.length);
        ColocationUtils.append((HashCalculator)this.hashCalculator, (Object)value, (NativeType)this.types[this.currentField++]);
    }

    public int partition() {
        assert (this.currentField == this.types.length);
        try {
            int n = IgniteUtils.safeAbs((int)this.hashCalculator.hash()) % this.partitionCount;
            return n;
        }
        finally {
            this.hashCalculator.reset();
            this.currentField = 0;
        }
    }
}

