/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.SuperRootChange;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.validation.Validator;

public class CompoundModule
implements ConfigurationModule {
    private final ConfigurationType type;
    private final List<ConfigurationModule> modules;

    public CompoundModule(ConfigurationType type, Collection<ConfigurationModule> modules) {
        this.type = type;
        this.modules = List.copyOf(modules);
    }

    public ConfigurationType type() {
        return this.type;
    }

    public Collection<RootKey<?, ?>> rootKeys() {
        return this.unionFromModulesExtractedWith(ConfigurationModule::rootKeys);
    }

    private <T> List<T> unionFromModulesExtractedWith(Function<? super ConfigurationModule, ? extends Collection<T>> extractor) {
        return this.modules.stream().flatMap(module -> ((Collection)extractor.apply((ConfigurationModule)module)).stream()).collect(Collectors.toUnmodifiableList());
    }

    public Set<Validator<?, ?>> validators() {
        return this.modules.stream().flatMap(module -> module.validators().stream()).collect(Collectors.toUnmodifiableSet());
    }

    public Collection<Class<?>> schemaExtensions() {
        return this.unionFromModulesExtractedWith(ConfigurationModule::schemaExtensions);
    }

    public Collection<Class<?>> polymorphicSchemaExtensions() {
        return this.unionFromModulesExtractedWith(ConfigurationModule::polymorphicSchemaExtensions);
    }

    public void patchConfigurationWithDynamicDefaults(SuperRootChange rootChange) {
        this.modules.forEach(module -> module.patchConfigurationWithDynamicDefaults(rootChange));
    }
}

