/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema.marshaller.reflection;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite3.internal.marshaller.MarshallerReader;
import org.apache.ignite3.internal.schema.row.Row;
import org.jetbrains.annotations.Nullable;

class RowReader
implements MarshallerReader {
    private final Row row;
    private int index;
    private final int @Nullable [] positions;

    RowReader(Row row) {
        this(row, null);
    }

    RowReader(Row row, int @Nullable [] positions) {
        this.row = row;
        this.positions = positions;
    }

    @Override
    public void skipValue() {
        ++this.index;
    }

    @Override
    public boolean readBoolean() {
        int idx = this.nextSchemaIndex();
        return this.row.booleanValue(idx);
    }

    @Override
    public Boolean readBooleanBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.booleanValueBoxed(idx);
    }

    @Override
    public byte readByte() {
        int idx = this.nextSchemaIndex();
        return this.row.byteValue(idx);
    }

    @Override
    public Byte readByteBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.byteValueBoxed(idx);
    }

    @Override
    public short readShort() {
        int idx = this.nextSchemaIndex();
        return this.row.shortValue(idx);
    }

    @Override
    public Short readShortBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.shortValueBoxed(idx);
    }

    @Override
    public int readInt() {
        int idx = this.nextSchemaIndex();
        return this.row.intValue(idx);
    }

    @Override
    public Integer readIntBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.intValueBoxed(idx);
    }

    @Override
    public long readLong() {
        int idx = this.nextSchemaIndex();
        return this.row.longValue(idx);
    }

    @Override
    public Long readLongBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.longValueBoxed(idx);
    }

    @Override
    public float readFloat() {
        int idx = this.nextSchemaIndex();
        return this.row.floatValue(idx);
    }

    @Override
    public Float readFloatBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.floatValueBoxed(idx);
    }

    @Override
    public double readDouble() {
        int idx = this.nextSchemaIndex();
        return this.row.doubleValue(idx);
    }

    @Override
    public Double readDoubleBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.doubleValueBoxed(idx);
    }

    @Override
    public String readString() {
        int idx = this.nextSchemaIndex();
        return this.row.stringValue(idx);
    }

    @Override
    public UUID readUuid() {
        int idx = this.nextSchemaIndex();
        return this.row.uuidValue(idx);
    }

    @Override
    public byte[] readBytes() {
        int idx = this.nextSchemaIndex();
        return this.row.bytesValue(idx);
    }

    @Override
    public BigDecimal readBigDecimal(int scale) {
        int idx = this.nextSchemaIndex();
        return this.row.decimalValue(idx);
    }

    @Override
    public LocalDate readDate() {
        int idx = this.nextSchemaIndex();
        return this.row.dateValue(idx);
    }

    @Override
    public LocalTime readTime() {
        int idx = this.nextSchemaIndex();
        return this.row.timeValue(idx);
    }

    @Override
    public Instant readTimestamp() {
        int idx = this.nextSchemaIndex();
        return this.row.timestampValue(idx);
    }

    @Override
    public LocalDateTime readDateTime() {
        int idx = this.nextSchemaIndex();
        return this.row.dateTimeValue(idx);
    }

    private int nextSchemaIndex() {
        int i = this.index++;
        return this.positions == null ? i : this.positions[i];
    }
}

