/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.StagedTable;
import org.apache.spark.sql.connector.catalog.SupportsDelete;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class RollbackStagedTable
implements StagedTable,
SupportsRead,
SupportsWrite,
SupportsDelete {
    private final TableCatalog catalog;
    private final Identifier ident;
    private final Table table;

    public RollbackStagedTable(TableCatalog catalog, Identifier ident, Table table) {
        this.catalog = catalog;
        this.ident = ident;
        this.table = table;
    }

    public void commitStagedChanges() {
    }

    public void abortStagedChanges() {
        this.catalog.dropTable(this.ident);
    }

    public String name() {
        return this.table.name();
    }

    public StructType schema() {
        return this.table.schema();
    }

    public Transform[] partitioning() {
        return this.table.partitioning();
    }

    public Map<String, String> properties() {
        return this.table.properties();
    }

    public Set<TableCapability> capabilities() {
        return this.table.capabilities();
    }

    public void deleteWhere(Filter[] filters) {
        this.call(SupportsDelete.class, t -> t.deleteWhere(filters));
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        return this.callReturning(SupportsRead.class, t -> t.newScanBuilder(options));
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        return this.callReturning(SupportsWrite.class, t -> t.newWriteBuilder(info));
    }

    private <T> void call(Class<? extends T> requiredClass, Consumer<T> task) {
        this.callReturning(requiredClass, inst -> {
            task.accept(inst);
            return null;
        });
    }

    private <T, R> R callReturning(Class<? extends T> requiredClass, Function<T, R> task) {
        if (requiredClass.isInstance(this.table)) {
            return task.apply(requiredClass.cast(this.table));
        }
        throw new UnsupportedOperationException(String.format("Table does not implement %s: %s (%s)", requiredClass.getSimpleName(), this.table.name(), this.table.getClass().getName()));
    }
}

