/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

class InternalRowWrapper
implements StructLike {
    private final DataType[] types;
    private final BiFunction<InternalRow, Integer, ?>[] getters;
    private InternalRow row = null;

    InternalRowWrapper(StructType rowType, Types.StructType icebergSchema) {
        this.types = (DataType[])Stream.of(rowType.fields()).map(StructField::dataType).toArray(DataType[]::new);
        Preconditions.checkArgument((this.types.length == icebergSchema.fields().size() ? 1 : 0) != 0, (String)"Invalid length: Spark struct type (%s) != Iceberg struct type (%s)", (int)this.types.length, (int)icebergSchema.fields().size());
        this.getters = new BiFunction[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            this.getters[i] = InternalRowWrapper.getter(((Types.NestedField)icebergSchema.fields().get(i)).type(), this.types[i]);
        }
    }

    InternalRowWrapper wrap(InternalRow internalRow) {
        this.row = internalRow;
        return this;
    }

    public int size() {
        return this.types.length;
    }

    public <T> T get(int pos, Class<T> javaClass) {
        if (this.row.isNullAt(pos)) {
            return null;
        }
        if (this.getters[pos] != null) {
            return javaClass.cast(this.getters[pos].apply(this.row, pos));
        }
        return javaClass.cast(this.row.get(pos, this.types[pos]));
    }

    public <T> void set(int pos, T value) {
        this.row.update(pos, value);
    }

    private static BiFunction<InternalRow, Integer, ?> getter(Type icebergType, DataType type) {
        if (type instanceof StringType) {
            if (Type.TypeID.UUID == icebergType.typeId()) {
                return (row, pos) -> UUID.fromString(row.getUTF8String(pos.intValue()).toString());
            }
            return (row, pos) -> row.getUTF8String(pos.intValue()).toString();
        }
        if (type instanceof DecimalType) {
            DecimalType decimal = (DecimalType)type;
            return (row, pos) -> row.getDecimal(pos.intValue(), decimal.precision(), decimal.scale()).toJavaBigDecimal();
        }
        if (type instanceof BinaryType) {
            return (row, pos) -> ByteBuffer.wrap(row.getBinary(pos.intValue()));
        }
        if (type instanceof StructType) {
            StructType structType = (StructType)type;
            InternalRowWrapper nestedWrapper = new InternalRowWrapper(structType, icebergType.asStructType());
            return (row, pos) -> nestedWrapper.wrap(row.getStruct(pos.intValue(), structType.size()));
        }
        return null;
    }
}

