/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTypeManager;
import com.google.crypto.tink.PrivateKeyTypeManager;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.Ed25519KeyFormat;
import com.google.crypto.tink.proto.Ed25519PrivateKey;
import com.google.crypto.tink.proto.Ed25519PublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.signature.Ed25519PublicKeyManager;
import com.google.crypto.tink.subtle.Ed25519Sign;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Ed25519PrivateKeyManager
extends PrivateKeyTypeManager<Ed25519PrivateKey, Ed25519PublicKey> {
    Ed25519PrivateKeyManager() {
        super(Ed25519PrivateKey.class, Ed25519PublicKey.class, new KeyTypeManager.PrimitiveFactory<PublicKeySign, Ed25519PrivateKey>(PublicKeySign.class){

            @Override
            public PublicKeySign getPrimitive(Ed25519PrivateKey keyProto) throws GeneralSecurityException {
                return new Ed25519Sign(keyProto.getKeyValue().toByteArray());
            }
        });
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.Ed25519PrivateKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public Ed25519PublicKey getPublicKey(Ed25519PrivateKey key) throws GeneralSecurityException {
        return key.getPublicKey();
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE;
    }

    @Override
    public Ed25519PrivateKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return Ed25519PrivateKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public void validateKey(Ed25519PrivateKey keyProto) throws GeneralSecurityException {
        Validators.validateVersion(keyProto.getVersion(), this.getVersion());
        new Ed25519PublicKeyManager().validateKey(keyProto.getPublicKey());
        if (keyProto.getKeyValue().size() != 32) {
            throw new GeneralSecurityException("invalid Ed25519 private key: incorrect key length");
        }
    }

    @Override
    public KeyTypeManager.KeyFactory<Ed25519KeyFormat, Ed25519PrivateKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<Ed25519KeyFormat, Ed25519PrivateKey>(Ed25519KeyFormat.class){

            @Override
            public void validateKeyFormat(Ed25519KeyFormat format) throws GeneralSecurityException {
            }

            @Override
            public Ed25519KeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return Ed25519KeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public Ed25519PrivateKey createKey(Ed25519KeyFormat format) throws GeneralSecurityException {
                Ed25519Sign.KeyPair keyPair = Ed25519Sign.KeyPair.newKeyPair();
                Ed25519PublicKey publicKey = Ed25519PublicKey.newBuilder().setVersion(Ed25519PrivateKeyManager.this.getVersion()).setKeyValue(ByteString.copyFrom((byte[])keyPair.getPublicKey())).build();
                return Ed25519PrivateKey.newBuilder().setVersion(Ed25519PrivateKeyManager.this.getVersion()).setKeyValue(ByteString.copyFrom((byte[])keyPair.getPrivateKey())).setPublicKey(publicKey).build();
            }

            @Override
            public Ed25519PrivateKey deriveKey(Ed25519KeyFormat format, InputStream inputStream) throws GeneralSecurityException {
                Validators.validateVersion(format.getVersion(), Ed25519PrivateKeyManager.this.getVersion());
                byte[] pseudorandomness = new byte[32];
                try {
                    int read = inputStream.read(pseudorandomness);
                    if (read != 32) {
                        throw new GeneralSecurityException("Not enough pseudorandomness given");
                    }
                    Ed25519Sign.KeyPair keyPair = Ed25519Sign.KeyPair.newKeyPairFromSeed(pseudorandomness);
                    Ed25519PublicKey publicKey = Ed25519PublicKey.newBuilder().setVersion(Ed25519PrivateKeyManager.this.getVersion()).setKeyValue(ByteString.copyFrom((byte[])keyPair.getPublicKey())).build();
                    return Ed25519PrivateKey.newBuilder().setVersion(Ed25519PrivateKeyManager.this.getVersion()).setKeyValue(ByteString.copyFrom((byte[])keyPair.getPrivateKey())).setPublicKey(publicKey).build();
                }
                catch (IOException e) {
                    throw new GeneralSecurityException("Reading pseudorandomness failed", e);
                }
            }

            @Override
            public Map<String, KeyTypeManager.KeyFactory.KeyFormat<Ed25519KeyFormat>> keyFormats() throws GeneralSecurityException {
                HashMap<String, KeyTypeManager.KeyFactory.KeyFormat<Ed25519KeyFormat>> result = new HashMap<String, KeyTypeManager.KeyFactory.KeyFormat<Ed25519KeyFormat>>();
                result.put("ED25519", new KeyTypeManager.KeyFactory.KeyFormat<Ed25519KeyFormat>(Ed25519KeyFormat.getDefaultInstance(), KeyTemplate.OutputPrefixType.TINK));
                result.put("ED25519_RAW", new KeyTypeManager.KeyFactory.KeyFormat<Ed25519KeyFormat>(Ed25519KeyFormat.getDefaultInstance(), KeyTemplate.OutputPrefixType.RAW));
                result.put("ED25519WithRawOutput", new KeyTypeManager.KeyFactory.KeyFormat<Ed25519KeyFormat>(Ed25519KeyFormat.getDefaultInstance(), KeyTemplate.OutputPrefixType.RAW));
                return Collections.unmodifiableMap(result);
            }
        };
    }

    public static void registerPair(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerAsymmetricKeyManagers(new Ed25519PrivateKeyManager(), new Ed25519PublicKeyManager(), newKeyAllowed);
    }

    @Deprecated
    public static final KeyTemplate ed25519Template() {
        return KeyTemplate.create(new Ed25519PrivateKeyManager().getKeyType(), new byte[0], KeyTemplate.OutputPrefixType.TINK);
    }

    @Deprecated
    public static final KeyTemplate rawEd25519Template() {
        return KeyTemplate.create(new Ed25519PrivateKeyManager().getKeyType(), new byte[0], KeyTemplate.OutputPrefixType.RAW);
    }
}

