/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job.metrics;

import java.util.Locale;
import org.apache.flink.runtime.rest.messages.ConversionException;
import org.apache.flink.runtime.rest.messages.MessageParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.util.StringUtils;

public class MetricsAggregationParameter
extends MessageQueryParameter<AggregationMode> {
    protected MetricsAggregationParameter() {
        super("agg", MessageParameter.MessageParameterRequisiteness.OPTIONAL);
    }

    @Override
    public AggregationMode convertStringToValue(String value) throws ConversionException {
        try {
            return AggregationMode.valueOf(value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("Not a valid aggregation: " + value, iae);
        }
    }

    @Override
    public String convertValueToString(AggregationMode value) {
        return value.name().toLowerCase();
    }

    @Override
    public String getDescription() {
        return "Comma-separated list of aggregation modes which should be calculated. Available aggregations are: " + StringUtils.toQuotedListString((Object[])AggregationMode.values()) + '.';
    }

    public static enum AggregationMode {
        MIN,
        MAX,
        SUM,
        AVG,
        SKEW;

    }
}

