/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.scan;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.data.DefaultKeyedFile;
import org.apache.amoro.data.FileNameRules;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.amoro.scan.MixedFileScanTask;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;

public class BasicMixedFileScanTask
implements MixedFileScanTask {
    private final PrimaryKeyedFile baseFile;
    private final List<DeleteFile> posDeleteFiles;
    private final PartitionSpec spec;
    private final Expression expression;
    private FileScanTask fileScanTask;

    public BasicMixedFileScanTask(PrimaryKeyedFile baseFile, List<DeleteFile> posDeleteFiles, PartitionSpec spec) {
        this(baseFile, posDeleteFiles, spec, (Expression)Expressions.alwaysTrue());
    }

    public BasicMixedFileScanTask(PrimaryKeyedFile baseFile, List<DeleteFile> posDeleteFiles, PartitionSpec spec, Expression expression) {
        this.baseFile = baseFile;
        this.posDeleteFiles = posDeleteFiles == null ? Collections.emptyList() : posDeleteFiles.stream().filter(s -> {
            DataTreeNode node = FileNameRules.parseFileNodeFromFileName(s.path().toString());
            return baseFile.node().isSonOf(node) || baseFile.node().equals(node);
        }).collect(Collectors.toList());
        this.spec = spec;
        this.expression = expression;
    }

    public BasicMixedFileScanTask(FileScanTask fileScanTask) {
        this(DefaultKeyedFile.parseBase((DataFile)fileScanTask.file()), fileScanTask.deletes(), fileScanTask.spec(), fileScanTask.residual());
        this.fileScanTask = fileScanTask;
    }

    @Override
    public PrimaryKeyedFile file() {
        return this.baseFile;
    }

    public List<DeleteFile> deletes() {
        return this.posDeleteFiles;
    }

    public PartitionSpec spec() {
        return this.spec;
    }

    public long start() {
        if (this.fileScanTask != null) {
            return this.fileScanTask.start();
        }
        return 0L;
    }

    public long length() {
        if (this.fileScanTask != null) {
            return this.fileScanTask.length();
        }
        return this.baseFile.fileSizeInBytes();
    }

    public Expression residual() {
        return this.expression;
    }

    public Iterable<FileScanTask> split(long splitSize) {
        return ImmutableList.of((Object)this);
    }
}

