/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.io;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.util.ByteArrayWritableChannel;
import org.apache.spark.storage.StorageUtils$;
import org.apache.spark.util.io.ChunkedByteBuffer$;
import org.apache.spark.util.io.ChunkedByteBufferFileRegion;
import org.apache.spark.util.io.ChunkedByteBufferInputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mc!\u0002\u000e\u001c\u0001})\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0007I\u0011\u0001\u0018\t\u0011i\u0002!\u00111A\u0005\u0002mB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006Ka\f\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u0019a\u0005\u0001)A\u0005\u0013\"1Q\n\u0001Q!\n9Cq!\u0015\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004W\u0001\u0001\u0006Ia\u0015\u0005\u0006\u0005\u0002!\ta\u0016\u0005\u00065\u0002!\ta\u0017\u0005\u0006I\u0002!\t!\u001a\u0005\u0006S\u0002!\tA\u001b\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006c\u0002!\tA\u001d\u0005\bu\u0002\t\n\u0011\"\u0001|\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\u0005\u0001\t\u0003\t\u0019\u0002\u0003\u0004z\u0001\u0011\u0005\u0011qD\u0004\t\u0003CY\u0002\u0012A\u0010\u0002$\u00199!d\u0007E\u0001?\u0005\u0015\u0002B\u0002\"\u0016\t\u0003\t9\u0003C\u0004\u0002*U!\t!a\u000b\t\u000f\u0005\u0005S\u0003\"\u0001\u0002D!9\u0011\u0011I\u000b\u0005\n\u0005=#!E\"ik:\\W\r\u001a\"zi\u0016\u0014UO\u001a4fe*\u0011A$H\u0001\u0003S>T!AH\u0010\u0002\tU$\u0018\u000e\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sON\u0011\u0001A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\r\rDWO\\6t\u0007\u0001)\u0012a\f\t\u0004OA\u0012\u0014BA\u0019)\u0005\u0015\t%O]1z!\t\u0019\u0004(D\u00015\u0015\t)d'A\u0002oS>T\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:i\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\u0015\rDWO\\6t?\u0012*\u0017\u000f\u0006\u0002=\u007fA\u0011q%P\u0005\u0003}!\u0012A!\u00168ji\"9\u0001IAA\u0001\u0002\u0004y\u0013a\u0001=%c\u000591\r[;oWN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002E\rB\u0011Q\tA\u0007\u00027!)A\u0006\u0002a\u0001_\u0005!\"-\u001e4gKJ<&/\u001b;f\u0007\",hn[*ju\u0016,\u0012!\u0013\t\u0003O)K!a\u0013\u0015\u0003\u0007%sG/A\u000bck\u001a4WM],sSR,7\t[;oWNK'0\u001a\u0011\u0002\u0011\u0011L7\u000f]8tK\u0012\u0004\"aJ(\n\u0005AC#a\u0002\"p_2,\u0017M\\\u0001\u0005g&TX-F\u0001T!\t9C+\u0003\u0002VQ\t!Aj\u001c8h\u0003\u0015\u0019\u0018N_3!)\t!\u0005\fC\u0003Z\u0015\u0001\u0007!'\u0001\u0006csR,')\u001e4gKJ\f!b\u001e:ji\u00164U\u000f\u001c7z)\taD\fC\u0003^\u0017\u0001\u0007a,A\u0004dQ\u0006tg.\u001a7\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005$\u0014\u0001C2iC:tW\r\\:\n\u0005\r\u0004'aE,sSR\f'\r\\3CsR,7\t[1o]\u0016d\u0017a\u0002;p\u001d\u0016$H/_\u000b\u0002MB\u0011QiZ\u0005\u0003Qn\u00111d\u00115v].,GMQ=uK\n+hMZ3s\r&dWMU3hS>t\u0017a\u0002;p\u0003J\u0014\u0018-_\u000b\u0002WB\u0019q\u0005\r7\u0011\u0005\u001dj\u0017B\u00018)\u0005\u0011\u0011\u0015\u0010^3\u0002\u0019Q|')\u001f;f\u0005V4g-\u001a:\u0016\u0003I\nQ\u0002^8J]B,Ho\u0015;sK\u0006lGCA:y!\t!h/D\u0001v\u0015\tab'\u0003\u0002xk\nY\u0011J\u001c9viN#(/Z1n\u0011\u001dIx\u0002%AA\u00029\u000bq\u0001Z5ta>\u001cX-A\fu_&s\u0007/\u001e;TiJ,\u0017-\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\tAP\u000b\u0002O{.\na\u0010E\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0002)\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\t\tAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011bZ3u\u0007\",hn[:\u0015\u0003=\nAaY8qsR\u0019A)!\u0006\t\u000f\u0005]!\u00031\u0001\u0002\u001a\u0005I\u0011\r\u001c7pG\u0006$xN\u001d\t\u0006O\u0005m\u0011JM\u0005\u0004\u0003;A#!\u0003$v]\u000e$\u0018n\u001c82)\u0005a\u0014!E\"ik:\\W\r\u001a\"zi\u0016\u0014UO\u001a4feB\u0011Q)F\n\u0003+\u0019\"\"!a\t\u0002#\u0019\u0014x.\\'b]\u0006<W\r\u001a\"vM\u001a,'\u000fF\u0002E\u0003[Aq!a\f\u0018\u0001\u0004\t\t$\u0001\u0003eCR\f\u0007\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0007EV4g-\u001a:\u000b\u0007\u0005mr$A\u0004oKR<xN]6\n\t\u0005}\u0012Q\u0007\u0002\u000e\u001b\u0006t\u0017mZ3e\u0005V4g-\u001a:\u0002\u0011\u0019\u0014x.\u001c$jY\u0016$2\u0001RA#\u0011\u001d\t9\u0005\u0007a\u0001\u0003\u0013\nAAZ5mKB\u0019A/a\u0013\n\u0007\u00055SO\u0001\u0003GS2,Gc\u0002#\u0002R\u0005M\u0013q\u000b\u0005\b\u0003\u000fJ\u0002\u0019AA%\u0011\u0019\t)&\u0007a\u0001'\u00061qN\u001a4tKRDa!!\u0017\u001a\u0001\u0004\u0019\u0016A\u00027f]\u001e$\b\u000e")
public class ChunkedByteBuffer {
    private ByteBuffer[] chunks;
    private final int bufferWriteChunkSize;
    private boolean disposed;
    private final long size;

    public static ChunkedByteBuffer fromFile(File file) {
        return ChunkedByteBuffer$.MODULE$.fromFile(file);
    }

    public static ChunkedByteBuffer fromManagedBuffer(ManagedBuffer managedBuffer) {
        return ChunkedByteBuffer$.MODULE$.fromManagedBuffer(managedBuffer);
    }

    public ByteBuffer[] chunks() {
        return this.chunks;
    }

    public void chunks_$eq(ByteBuffer[] x$1) {
        this.chunks = x$1;
    }

    private int bufferWriteChunkSize() {
        return this.bufferWriteChunkSize;
    }

    public long size() {
        return this.size;
    }

    public void writeFully(WritableByteChannel channel) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getChunks())).foreach((Function1 & Serializable & scala.Serializable)bytes -> {
            ChunkedByteBuffer.$anonfun$writeFully$1(this, channel, bytes);
            return BoxedUnit.UNIT;
        });
    }

    public ChunkedByteBufferFileRegion toNetty() {
        return new ChunkedByteBufferFileRegion(this, this.bufferWriteChunkSize());
    }

    public byte[] toArray() {
        if (this.size() >= 0x7FFFFFF0L) {
            throw new UnsupportedOperationException(new StringBuilder(75).append("cannot call toArray because buffer size (").append(this.size()).append(" bytes) exceeds maximum array size").toString());
        }
        ByteArrayWritableChannel byteChannel = new ByteArrayWritableChannel((int)this.size());
        this.writeFully((WritableByteChannel)byteChannel);
        byteChannel.close();
        return byteChannel.getData();
    }

    public ByteBuffer toByteBuffer() {
        return this.chunks().length == 1 ? ((ByteBuffer)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).head()).duplicate() : ByteBuffer.wrap(this.toArray());
    }

    public InputStream toInputStream(boolean dispose) {
        return new ChunkedByteBufferInputStream(this, dispose);
    }

    public boolean toInputStream$default$1() {
        return false;
    }

    public ByteBuffer[] getChunks() {
        return (ByteBuffer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.duplicate(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ByteBuffer.class)));
    }

    public ChunkedByteBuffer copy(Function1<Object, ByteBuffer> allocator) {
        ByteBuffer[] copiedChunks = (ByteBuffer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getChunks())).map((Function1 & Serializable & scala.Serializable)chunk -> {
            void var2_2;
            ByteBuffer newChunk = (ByteBuffer)allocator.apply((Object)BoxesRunTime.boxToInteger((int)chunk.limit()));
            newChunk.put((ByteBuffer)chunk);
            newChunk.flip();
            return var2_2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ByteBuffer.class)));
        return new ChunkedByteBuffer(copiedChunks);
    }

    public void dispose() {
        block0: {
            if (this.disposed) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
                StorageUtils$.MODULE$.dispose(buffer);
                return BoxedUnit.UNIT;
            });
            this.disposed = true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$2(ByteBuffer x$1) {
        return x$1.position() == 0;
    }

    public static final /* synthetic */ long $anonfun$bufferWriteChunkSize$1(SparkEnv x$2) {
        return BoxesRunTime.unboxToLong((Object)x$2.conf().get(package$.MODULE$.BUFFER_WRITE_CHUNK_SIZE()));
    }

    public static final /* synthetic */ void $anonfun$writeFully$1(ChunkedByteBuffer $this, WritableByteChannel channel$1, ByteBuffer bytes) {
        int originalLimit = bytes.limit();
        while (bytes.hasRemaining()) {
            int ioSize = Math.min(bytes.remaining(), $this.bufferWriteChunkSize());
            bytes.limit(bytes.position() + ioSize);
            channel$1.write(bytes);
            bytes.limit(originalLimit);
        }
    }

    public ChunkedByteBuffer(ByteBuffer[] chunks) {
        this.chunks = chunks;
        Predef$.MODULE$.require(this.chunks() != null, (Function0 & Serializable & scala.Serializable)() -> "chunks must not be null");
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ChunkedByteBuffer.$anonfun$new$2(x$1))), (Function0 & Serializable & scala.Serializable)() -> "chunks' positions must be 0");
        this.bufferWriteChunkSize = (int)BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)ChunkedByteBuffer.$anonfun$bufferWriteChunkSize$1(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)package$.MODULE$.BUFFER_WRITE_CHUNK_SIZE().defaultValue().get())));
        this.disposed = false;
        this.size = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.limit()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public ChunkedByteBuffer(ByteBuffer byteBuffer) {
        this((ByteBuffer[])((Object[])new ByteBuffer[]{byteBuffer}));
    }
}

