/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.PutItemInputAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutItemRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, PutItemRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(PutItemRequest.getter(PutItemRequest::tableName)).setter(PutItemRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Item").getter(PutItemRequest.getter(PutItemRequest::item)).setter(PutItemRequest.setter(Builder::item)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ExpectedAttributeValue>> EXPECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Expected").getter(PutItemRequest.getter(PutItemRequest::expected)).setter(PutItemRequest.setter(Builder::expected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expected").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpectedAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnValues").getter(PutItemRequest.getter(PutItemRequest::returnValuesAsString)).setter(PutItemRequest.setter(Builder::returnValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnValues").build()}).build();
    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnConsumedCapacity").getter(PutItemRequest.getter(PutItemRequest::returnConsumedCapacityAsString)).setter(PutItemRequest.setter(Builder::returnConsumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build()}).build();
    private static final SdkField<String> RETURN_ITEM_COLLECTION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnItemCollectionMetrics").getter(PutItemRequest.getter(PutItemRequest::returnItemCollectionMetricsAsString)).setter(PutItemRequest.setter(Builder::returnItemCollectionMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnItemCollectionMetrics").build()}).build();
    private static final SdkField<String> CONDITIONAL_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionalOperator").getter(PutItemRequest.getter(PutItemRequest::conditionalOperatorAsString)).setter(PutItemRequest.setter(Builder::conditionalOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalOperator").build()}).build();
    private static final SdkField<String> CONDITION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionExpression").getter(PutItemRequest.getter(PutItemRequest::conditionExpression)).setter(PutItemRequest.setter(Builder::conditionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpression").build()}).build();
    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExpressionAttributeNames").getter(PutItemRequest.getter(PutItemRequest::expressionAttributeNames)).setter(PutItemRequest.setter(Builder::expressionAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AttributeValue>> EXPRESSION_ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExpressionAttributeValues").getter(PutItemRequest.getter(PutItemRequest::expressionAttributeValues)).setter(PutItemRequest.setter(Builder::expressionAttributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnValuesOnConditionCheckFailure").getter(PutItemRequest.getter(PutItemRequest::returnValuesOnConditionCheckFailureAsString)).setter(PutItemRequest.setter(Builder::returnValuesOnConditionCheckFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnValuesOnConditionCheckFailure").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, ITEM_FIELD, EXPECTED_FIELD, RETURN_VALUES_FIELD, RETURN_CONSUMED_CAPACITY_FIELD, RETURN_ITEM_COLLECTION_METRICS_FIELD, CONDITIONAL_OPERATOR_FIELD, CONDITION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD, EXPRESSION_ATTRIBUTE_VALUES_FIELD, RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD));
    private final String tableName;
    private final Map<String, AttributeValue> item;
    private final Map<String, ExpectedAttributeValue> expected;
    private final String returnValues;
    private final String returnConsumedCapacity;
    private final String returnItemCollectionMetrics;
    private final String conditionalOperator;
    private final String conditionExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;
    private final String returnValuesOnConditionCheckFailure;

    private PutItemRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.item = builder.item;
        this.expected = builder.expected;
        this.returnValues = builder.returnValues;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
        this.conditionalOperator = builder.conditionalOperator;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
        this.returnValuesOnConditionCheckFailure = builder.returnValuesOnConditionCheckFailure;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasItem() {
        return this.item != null && !(this.item instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> item() {
        return this.item;
    }

    public final boolean hasExpected() {
        return this.expected != null && !(this.expected instanceof SdkAutoConstructMap);
    }

    public final Map<String, ExpectedAttributeValue> expected() {
        return this.expected;
    }

    public final ReturnValue returnValues() {
        return ReturnValue.fromValue(this.returnValues);
    }

    public final String returnValuesAsString() {
        return this.returnValues;
    }

    public final ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public final String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public final ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue(this.returnItemCollectionMetrics);
    }

    public final String returnItemCollectionMetricsAsString() {
        return this.returnItemCollectionMetrics;
    }

    public final ConditionalOperator conditionalOperator() {
        return ConditionalOperator.fromValue(this.conditionalOperator);
    }

    public final String conditionalOperatorAsString() {
        return this.conditionalOperator;
    }

    public final String conditionExpression() {
        return this.conditionExpression;
    }

    public final boolean hasExpressionAttributeNames() {
        return this.expressionAttributeNames != null && !(this.expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public final boolean hasExpressionAttributeValues() {
        return this.expressionAttributeValues != null && !(this.expressionAttributeValues instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public final ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure() {
        return ReturnValuesOnConditionCheckFailure.fromValue(this.returnValuesOnConditionCheckFailure);
    }

    public final String returnValuesOnConditionCheckFailureAsString() {
        return this.returnValuesOnConditionCheckFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItem() ? this.item() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpected() ? this.expected() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValuesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnItemCollectionMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpressionAttributeNames() ? this.expressionAttributeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpressionAttributeValues() ? this.expressionAttributeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValuesOnConditionCheckFailureAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutItemRequest)) {
            return false;
        }
        PutItemRequest other = (PutItemRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && this.hasItem() == other.hasItem() && Objects.equals(this.item(), other.item()) && this.hasExpected() == other.hasExpected() && Objects.equals(this.expected(), other.expected()) && Objects.equals(this.returnValuesAsString(), other.returnValuesAsString()) && Objects.equals(this.returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString()) && Objects.equals(this.returnItemCollectionMetricsAsString(), other.returnItemCollectionMetricsAsString()) && Objects.equals(this.conditionalOperatorAsString(), other.conditionalOperatorAsString()) && Objects.equals(this.conditionExpression(), other.conditionExpression()) && this.hasExpressionAttributeNames() == other.hasExpressionAttributeNames() && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames()) && this.hasExpressionAttributeValues() == other.hasExpressionAttributeValues() && Objects.equals(this.expressionAttributeValues(), other.expressionAttributeValues()) && Objects.equals(this.returnValuesOnConditionCheckFailureAsString(), other.returnValuesOnConditionCheckFailureAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutItemRequest").add("TableName", (Object)this.tableName()).add("Item", this.hasItem() ? this.item() : null).add("Expected", this.hasExpected() ? this.expected() : null).add("ReturnValues", (Object)this.returnValuesAsString()).add("ReturnConsumedCapacity", (Object)this.returnConsumedCapacityAsString()).add("ReturnItemCollectionMetrics", (Object)this.returnItemCollectionMetricsAsString()).add("ConditionalOperator", (Object)this.conditionalOperatorAsString()).add("ConditionExpression", (Object)this.conditionExpression()).add("ExpressionAttributeNames", this.hasExpressionAttributeNames() ? this.expressionAttributeNames() : null).add("ExpressionAttributeValues", this.hasExpressionAttributeValues() ? this.expressionAttributeValues() : null).add("ReturnValuesOnConditionCheckFailure", (Object)this.returnValuesOnConditionCheckFailureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
            case "Expected": {
                return Optional.ofNullable(clazz.cast(this.expected()));
            }
            case "ReturnValues": {
                return Optional.ofNullable(clazz.cast(this.returnValuesAsString()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.returnConsumedCapacityAsString()));
            }
            case "ReturnItemCollectionMetrics": {
                return Optional.ofNullable(clazz.cast(this.returnItemCollectionMetricsAsString()));
            }
            case "ConditionalOperator": {
                return Optional.ofNullable(clazz.cast(this.conditionalOperatorAsString()));
            }
            case "ConditionExpression": {
                return Optional.ofNullable(clazz.cast(this.conditionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeNames()));
            }
            case "ExpressionAttributeValues": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeValues()));
            }
            case "ReturnValuesOnConditionCheckFailure": {
                return Optional.ofNullable(clazz.cast(this.returnValuesOnConditionCheckFailureAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutItemRequest, T> g) {
        return obj -> g.apply((PutItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private Map<String, AttributeValue> item = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ExpectedAttributeValue> expected = DefaultSdkAutoConstructMap.getInstance();
        private String returnValues;
        private String returnConsumedCapacity;
        private String returnItemCollectionMetrics;
        private String conditionalOperator;
        private String conditionExpression;
        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AttributeValue> expressionAttributeValues = DefaultSdkAutoConstructMap.getInstance();
        private String returnValuesOnConditionCheckFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(PutItemRequest model) {
            super(model);
            this.tableName(model.tableName);
            this.item(model.item);
            this.expected(model.expected);
            this.returnValues(model.returnValues);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
            this.returnItemCollectionMetrics(model.returnItemCollectionMetrics);
            this.conditionalOperator(model.conditionalOperator);
            this.conditionExpression(model.conditionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
            this.expressionAttributeValues(model.expressionAttributeValues);
            this.returnValuesOnConditionCheckFailure(model.returnValuesOnConditionCheckFailure);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            Map<String, AttributeValue.Builder> result = PutItemInputAttributeMapCopier.copyToBuilder(this.item);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = PutItemInputAttributeMapCopier.copyFromBuilder(item);
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
            return this;
        }

        public final Map<String, ExpectedAttributeValue.Builder> getExpected() {
            Map<String, ExpectedAttributeValue.Builder> result = ExpectedAttributeMapCopier.copyToBuilder(this.expected);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExpected(Map<String, ExpectedAttributeValue.BuilderImpl> expected) {
            this.expected = ExpectedAttributeMapCopier.copyFromBuilder(expected);
        }

        @Override
        public final Builder expected(Map<String, ExpectedAttributeValue> expected) {
            this.expected = ExpectedAttributeMapCopier.copy(expected);
            return this;
        }

        public final String getReturnValues() {
            return this.returnValues;
        }

        public final void setReturnValues(String returnValues) {
            this.returnValues = returnValues;
        }

        @Override
        public final Builder returnValues(String returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        @Override
        public final Builder returnValues(ReturnValue returnValues) {
            this.returnValues(returnValues == null ? null : returnValues.toString());
            return this;
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        public final String getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics == null ? null : returnItemCollectionMetrics.toString());
            return this;
        }

        public final String getConditionalOperator() {
            return this.conditionalOperator;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator == null ? null : conditionalOperator.toString());
            return this;
        }

        public final String getConditionExpression() {
            return this.conditionExpression;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            if (this.expressionAttributeNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.expressionAttributeNames;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            Map<String, AttributeValue.Builder> result = ExpressionAttributeValueMapCopier.copyToBuilder(this.expressionAttributeValues);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final String getReturnValuesOnConditionCheckFailure() {
            return this.returnValuesOnConditionCheckFailure;
        }

        public final void setReturnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
            return this;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure == null ? null : returnValuesOnConditionCheckFailure.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutItemRequest build() {
            return new PutItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutItemRequest> {
        public Builder tableName(String var1);

        public Builder item(Map<String, AttributeValue> var1);

        public Builder expected(Map<String, ExpectedAttributeValue> var1);

        public Builder returnValues(String var1);

        public Builder returnValues(ReturnValue var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder returnItemCollectionMetrics(String var1);

        public Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics var1);

        public Builder conditionalOperator(String var1);

        public Builder conditionalOperator(ConditionalOperator var1);

        public Builder conditionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);

        public Builder returnValuesOnConditionCheckFailure(String var1);

        public Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

