/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.core.state.StateFutureImpl;
import org.apache.flink.runtime.asyncprocessing.AsyncExecutionController;
import org.apache.flink.runtime.asyncprocessing.ContextStateFutureImpl;
import org.apache.flink.runtime.asyncprocessing.RecordContext;

public class StateFutureFactory<K> {
    private final AsyncExecutionController<K> asyncExecutionController;
    private final MailboxExecutor mailboxExecutor;
    private final StateFutureImpl.AsyncFrameworkExceptionHandler exceptionHandler;

    StateFutureFactory(AsyncExecutionController<K> asyncExecutionController, MailboxExecutor mailboxExecutor, StateFutureImpl.AsyncFrameworkExceptionHandler exceptionHandler) {
        this.asyncExecutionController = asyncExecutionController;
        this.mailboxExecutor = mailboxExecutor;
        this.exceptionHandler = exceptionHandler;
    }

    public <OUT> InternalStateFuture<OUT> create(RecordContext<K> context) {
        return new ContextStateFutureImpl(runnable -> this.mailboxExecutor.execute(() -> {
            this.asyncExecutionController.setCurrentContext(context);
            runnable.run();
        }, "State callback."), this.exceptionHandler, context);
    }
}

