/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.AbstractChannelStateHandle;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StateObject;

@Internal
public class PrioritizedOperatorSubtaskState {
    private static final OperatorSubtaskState EMPTY_JM_STATE_STATE = OperatorSubtaskState.builder().build();
    private static final PrioritizedOperatorSubtaskState EMPTY_NON_RESTORED_INSTANCE = new Builder(EMPTY_JM_STATE_STATE, Collections.emptyList(), null).build();
    private final List<StateObjectCollection<OperatorStateHandle>> prioritizedManagedOperatorState;
    private final List<StateObjectCollection<OperatorStateHandle>> prioritizedRawOperatorState;
    private final List<StateObjectCollection<KeyedStateHandle>> prioritizedManagedKeyedState;
    private final List<StateObjectCollection<KeyedStateHandle>> prioritizedRawKeyedState;
    private final List<StateObjectCollection<InputChannelStateHandle>> prioritizedInputChannelState;
    private final List<StateObjectCollection<ResultSubpartitionStateHandle>> prioritizedResultSubpartitionState;
    @Nullable
    private final Long restoredCheckpointId;

    PrioritizedOperatorSubtaskState(@Nonnull List<StateObjectCollection<KeyedStateHandle>> prioritizedManagedKeyedState, @Nonnull List<StateObjectCollection<KeyedStateHandle>> prioritizedRawKeyedState, @Nonnull List<StateObjectCollection<OperatorStateHandle>> prioritizedManagedOperatorState, @Nonnull List<StateObjectCollection<OperatorStateHandle>> prioritizedRawOperatorState, @Nonnull List<StateObjectCollection<InputChannelStateHandle>> prioritizedInputChannelState, @Nonnull List<StateObjectCollection<ResultSubpartitionStateHandle>> prioritizedResultSubpartitionState, @Nullable Long restoredCheckpointId) {
        this.prioritizedManagedOperatorState = prioritizedManagedOperatorState;
        this.prioritizedRawOperatorState = prioritizedRawOperatorState;
        this.prioritizedManagedKeyedState = prioritizedManagedKeyedState;
        this.prioritizedRawKeyedState = prioritizedRawKeyedState;
        this.prioritizedInputChannelState = prioritizedInputChannelState;
        this.prioritizedResultSubpartitionState = prioritizedResultSubpartitionState;
        this.restoredCheckpointId = restoredCheckpointId;
    }

    @Nonnull
    public List<StateObjectCollection<OperatorStateHandle>> getPrioritizedManagedOperatorState() {
        return this.prioritizedManagedOperatorState;
    }

    @Nonnull
    public List<StateObjectCollection<OperatorStateHandle>> getPrioritizedRawOperatorState() {
        return this.prioritizedRawOperatorState;
    }

    @Nonnull
    public List<StateObjectCollection<KeyedStateHandle>> getPrioritizedManagedKeyedState() {
        return this.prioritizedManagedKeyedState;
    }

    @Nonnull
    public List<StateObjectCollection<KeyedStateHandle>> getPrioritizedRawKeyedState() {
        return this.prioritizedRawKeyedState;
    }

    @Nonnull
    public StateObjectCollection<OperatorStateHandle> getJobManagerManagedOperatorState() {
        return PrioritizedOperatorSubtaskState.lastElement(this.prioritizedManagedOperatorState);
    }

    @Nonnull
    public StateObjectCollection<OperatorStateHandle> getJobManagerRawOperatorState() {
        return PrioritizedOperatorSubtaskState.lastElement(this.prioritizedRawOperatorState);
    }

    @Nonnull
    public StateObjectCollection<KeyedStateHandle> getJobManagerManagedKeyedState() {
        return PrioritizedOperatorSubtaskState.lastElement(this.prioritizedManagedKeyedState);
    }

    @Nonnull
    public StateObjectCollection<KeyedStateHandle> getJobManagerRawKeyedState() {
        return PrioritizedOperatorSubtaskState.lastElement(this.prioritizedRawKeyedState);
    }

    @Nonnull
    public StateObjectCollection<InputChannelStateHandle> getPrioritizedInputChannelState() {
        return PrioritizedOperatorSubtaskState.lastElement(this.prioritizedInputChannelState);
    }

    @Nonnull
    public StateObjectCollection<ResultSubpartitionStateHandle> getPrioritizedResultSubpartitionState() {
        return PrioritizedOperatorSubtaskState.lastElement(this.prioritizedResultSubpartitionState);
    }

    public boolean isRestored() {
        return this.restoredCheckpointId != null;
    }

    @Nullable
    public Long getRestoredCheckpointId() {
        return this.restoredCheckpointId;
    }

    private static <T extends StateObject> StateObjectCollection<T> lastElement(List<StateObjectCollection<T>> list) {
        return list.get(list.size() - 1);
    }

    public static PrioritizedOperatorSubtaskState emptyNotRestored() {
        return EMPTY_NON_RESTORED_INSTANCE;
    }

    public static PrioritizedOperatorSubtaskState empty(long restoredCheckpointId) {
        return new Builder(EMPTY_JM_STATE_STATE, Collections.emptyList(), restoredCheckpointId).build();
    }

    private static <T, E> BiFunction<T, T, Boolean> eqStateApprover(Function<T, E> identityExtractor) {
        return (ref, alt) -> identityExtractor.apply(ref).equals(identityExtractor.apply(alt));
    }

    @Internal
    public static class Builder {
        @Nonnull
        private final OperatorSubtaskState jobManagerState;
        @Nonnull
        private final List<OperatorSubtaskState> alternativesByPriority;
        @Nullable
        private final Long restoredCheckpointId;

        public Builder(@Nonnull OperatorSubtaskState jobManagerState, @Nonnull List<OperatorSubtaskState> alternativesByPriority) {
            this(jobManagerState, alternativesByPriority, null);
        }

        public Builder(@Nonnull OperatorSubtaskState jobManagerState, @Nonnull List<OperatorSubtaskState> alternativesByPriority, @Nullable Long restoredCheckpointId) {
            this.jobManagerState = jobManagerState;
            this.alternativesByPriority = alternativesByPriority;
            this.restoredCheckpointId = restoredCheckpointId;
        }

        public PrioritizedOperatorSubtaskState build() {
            int size = this.alternativesByPriority.size();
            ArrayList managedOperatorAlternatives = new ArrayList(size);
            ArrayList managedKeyedAlternatives = new ArrayList(size);
            ArrayList rawOperatorAlternatives = new ArrayList(size);
            ArrayList rawKeyedAlternatives = new ArrayList(size);
            ArrayList inputChannelStateAlternatives = new ArrayList(size);
            ArrayList resultSubpartitionStateAlternatives = new ArrayList(size);
            for (OperatorSubtaskState subtaskState : this.alternativesByPriority) {
                if (subtaskState == null) continue;
                managedKeyedAlternatives.add(subtaskState.getManagedKeyedState());
                rawKeyedAlternatives.add(subtaskState.getRawKeyedState());
                managedOperatorAlternatives.add(subtaskState.getManagedOperatorState());
                rawOperatorAlternatives.add(subtaskState.getRawOperatorState());
                inputChannelStateAlternatives.add(subtaskState.getInputChannelState());
                resultSubpartitionStateAlternatives.add(subtaskState.getResultSubpartitionState());
            }
            return new PrioritizedOperatorSubtaskState(this.computePrioritizedAlternatives(this.jobManagerState.getManagedKeyedState(), managedKeyedAlternatives, KeyedStateHandle::getKeyGroupRange), this.computePrioritizedAlternatives(this.jobManagerState.getRawKeyedState(), rawKeyedAlternatives, KeyedStateHandle::getKeyGroupRange), this.resolvePrioritizedAlternatives(this.jobManagerState.getManagedOperatorState(), managedOperatorAlternatives, PrioritizedOperatorSubtaskState.eqStateApprover(OperatorStateHandle::getStateNameToPartitionOffsets)), this.resolvePrioritizedAlternatives(this.jobManagerState.getRawOperatorState(), rawOperatorAlternatives, PrioritizedOperatorSubtaskState.eqStateApprover(OperatorStateHandle::getStateNameToPartitionOffsets)), this.resolvePrioritizedAlternatives(this.jobManagerState.getInputChannelState(), inputChannelStateAlternatives, PrioritizedOperatorSubtaskState.eqStateApprover(AbstractChannelStateHandle::getInfo)), this.resolvePrioritizedAlternatives(this.jobManagerState.getResultSubpartitionState(), resultSubpartitionStateAlternatives, PrioritizedOperatorSubtaskState.eqStateApprover(AbstractChannelStateHandle::getInfo)), this.restoredCheckpointId);
        }

        <STATE_OBJ_TYPE extends StateObject, ID_TYPE> List<StateObjectCollection<STATE_OBJ_TYPE>> computePrioritizedAlternatives(StateObjectCollection<STATE_OBJ_TYPE> jobManagerState, List<StateObjectCollection<STATE_OBJ_TYPE>> alternativesByPriority, Function<STATE_OBJ_TYPE, ID_TYPE> identityExtractor) {
            Optional<StateObjectCollection<STATE_OBJ_TYPE>> mergedAlternative;
            if (alternativesByPriority != null && !alternativesByPriority.isEmpty() && jobManagerState.hasState() && (mergedAlternative = Builder.tryComputeMixedLocalAndRemoteAlternative(jobManagerState, alternativesByPriority, identityExtractor)).isPresent()) {
                return Arrays.asList(mergedAlternative.get(), jobManagerState);
            }
            return Collections.singletonList(jobManagerState);
        }

        static <STATE_OBJ_TYPE extends StateObject, ID_TYPE> Optional<StateObjectCollection<STATE_OBJ_TYPE>> tryComputeMixedLocalAndRemoteAlternative(StateObjectCollection<STATE_OBJ_TYPE> jobManagerState, List<StateObjectCollection<STATE_OBJ_TYPE>> alternativesByPriority, Function<STATE_OBJ_TYPE, ID_TYPE> identityExtractor) {
            List result = Collections.emptyList();
            Map indexById = jobManagerState.stream().collect(Collectors.toMap(identityExtractor, Function.identity()));
            for (StateObjectCollection<STATE_OBJ_TYPE> alternative : alternativesByPriority) {
                for (StateObject stateHandle : alternative) {
                    if (indexById.remove(identityExtractor.apply(stateHandle)) == null) continue;
                    if (result.isEmpty()) {
                        result = new ArrayList(jobManagerState.size());
                    }
                    result.add(stateHandle);
                    if (!indexById.isEmpty()) continue;
                    return Optional.of(new StateObjectCollection(result));
                }
            }
            if (result.isEmpty()) {
                return Optional.empty();
            }
            result.addAll(indexById.values());
            return Optional.of(new StateObjectCollection(result));
        }

        <T extends StateObject> List<StateObjectCollection<T>> resolvePrioritizedAlternatives(StateObjectCollection<T> jobManagerState, List<StateObjectCollection<T>> alternativesByPriority, BiFunction<T, T, Boolean> approveFun) {
            if (alternativesByPriority == null || alternativesByPriority.isEmpty() || !jobManagerState.hasState() || jobManagerState.size() != 1) {
                return Collections.singletonList(jobManagerState);
            }
            StateObject reference = (StateObject)jobManagerState.iterator().next();
            ArrayList<StateObjectCollection<T>> approved = new ArrayList<StateObjectCollection<T>>(1 + alternativesByPriority.size());
            for (StateObjectCollection<T> alternative : alternativesByPriority) {
                if (alternative == null || !alternative.hasState() || alternative.size() != 1 || !BooleanUtils.isTrue((Boolean)approveFun.apply(reference, (StateObject)alternative.iterator().next()))) continue;
                approved.add(alternative);
            }
            approved.add(jobManagerState);
            return Collections.unmodifiableList(approved);
        }
    }
}

