/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.execution.RestoreMode;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DefaultCompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DefaultCompletedCheckpointStoreUtils;
import org.apache.flink.runtime.checkpoint.DefaultLastStateConnectionStateListener;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointStoreUtil;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.DefaultJobGraphStore;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.ZooKeeperJobGraphStoreUtil;
import org.apache.flink.runtime.jobmanager.ZooKeeperJobGraphStoreWatcher;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderretrieval.DefaultLeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.ZooKeeperLeaderRetrievalDriver;
import org.apache.flink.runtime.leaderretrieval.ZooKeeperLeaderRetrievalDriverFactory;
import org.apache.flink.runtime.persistence.RetrievableStateStorageHelper;
import org.apache.flink.runtime.persistence.filesystem.FileSystemStateStorageHelper;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.state.SharedStateRegistryFactory;
import org.apache.flink.runtime.zookeeper.ZooKeeperStateHandleStore;
import org.apache.flink.shaded.curator5.org.apache.curator.RetryPolicy;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.AuthInfo;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.api.ACLProvider;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.api.DeleteBuilderMain;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.TreeCacheSelector;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.state.ConnectionStateErrorPolicy;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.state.SessionConnectionStateErrorPolicy;
import org.apache.flink.shaded.curator5.org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.CreateMode;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.ZooDefs;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.data.ACL;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.data.Stat;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.function.RunnableWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperUtils.class);
    public static final String HA_STORAGE_SUBMITTED_JOBGRAPH_PREFIX = "submittedJobGraph";
    public static final String HA_STORAGE_COMPLETED_CHECKPOINT = "completedCheckpoint";
    public static final String RESOURCE_MANAGER_NODE = "resource_manager";
    private static final String DISPATCHER_NODE = "dispatcher";
    private static final String LEADER_NODE = "leader";
    private static final String REST_SERVER_NODE = "rest_server";
    private static final String LEADER_LATCH_NODE = "latch";
    private static final String CONNECTION_INFO_NODE = "connection_info";

    public static String getLeaderPathForJob(JobID jobId) {
        return ZooKeeperUtils.generateZookeeperPath(ZooKeeperUtils.getJobsPath(), ZooKeeperUtils.getPathForJob(jobId));
    }

    public static String getJobsPath() {
        return "/jobs";
    }

    private static String getCheckpointsPath() {
        return "/checkpoints";
    }

    public static String getCheckpointIdCounterPath() {
        return "/checkpoint_id_counter";
    }

    public static String getLeaderPath() {
        return ZooKeeperUtils.generateZookeeperPath(LEADER_NODE);
    }

    public static String getDispatcherNode() {
        return DISPATCHER_NODE;
    }

    public static String getResourceManagerNode() {
        return RESOURCE_MANAGER_NODE;
    }

    public static String getRestServerNode() {
        return REST_SERVER_NODE;
    }

    public static String getLeaderLatchPath() {
        return ZooKeeperUtils.generateZookeeperPath(LEADER_LATCH_NODE);
    }

    public static String getLeaderPath(String suffix) {
        return ZooKeeperUtils.generateZookeeperPath(LEADER_NODE, suffix);
    }

    public static String generateConnectionInformationPath(String path) {
        return ZooKeeperUtils.generateZookeeperPath(path, CONNECTION_INFO_NODE);
    }

    public static boolean isConnectionInfoPath(String path) {
        return path.endsWith(CONNECTION_INFO_NODE);
    }

    public static String generateLeaderLatchPath(String path) {
        return ZooKeeperUtils.generateZookeeperPath(path, LEADER_LATCH_NODE);
    }

    public static CuratorFrameworkWithUnhandledErrorListener startCuratorFramework(Configuration configuration, FatalErrorHandler fatalErrorHandler) {
        SecureAclProvider aclProvider;
        Preconditions.checkNotNull((Object)configuration, (String)"configuration");
        String zkQuorum = configuration.getValue(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM);
        if (zkQuorum == null || StringUtils.isBlank((CharSequence)zkQuorum)) {
            throw new RuntimeException("No valid ZooKeeper quorum has been specified. You can specify the quorum via the configuration key '" + HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM.key() + "'.");
        }
        int sessionTimeout = Math.toIntExact(((Duration)configuration.get(HighAvailabilityOptions.ZOOKEEPER_SESSION_TIMEOUT)).toMillis());
        int connectionTimeout = Math.toIntExact(((Duration)configuration.get(HighAvailabilityOptions.ZOOKEEPER_CONNECTION_TIMEOUT)).toMillis());
        int retryWait = Math.toIntExact(((Duration)configuration.get(HighAvailabilityOptions.ZOOKEEPER_RETRY_WAIT)).toMillis());
        int maxRetryAttempts = (Integer)configuration.get(HighAvailabilityOptions.ZOOKEEPER_MAX_RETRY_ATTEMPTS);
        String root = configuration.getValue(HighAvailabilityOptions.HA_ZOOKEEPER_ROOT);
        String namespace = configuration.getValue(HighAvailabilityOptions.HA_CLUSTER_ID);
        boolean disableSaslClient = (Boolean)configuration.get(SecurityOptions.ZOOKEEPER_SASL_DISABLE);
        ZkClientACLMode aclMode = ZkClientACLMode.fromConfig(configuration);
        if (disableSaslClient && aclMode == ZkClientACLMode.CREATOR) {
            String errorMessage = "Cannot set ACL role to " + (Object)((Object)ZkClientACLMode.CREATOR) + "  since SASL authentication is disabled through the " + SecurityOptions.ZOOKEEPER_SASL_DISABLE.key() + " property";
            LOG.warn(errorMessage);
            throw new IllegalConfigurationException(errorMessage);
        }
        if (aclMode == ZkClientACLMode.CREATOR) {
            LOG.info("Enforcing creator for ZK connections");
            aclProvider = new SecureAclProvider();
        } else {
            LOG.info("Enforcing default ACL for ZK connections");
            aclProvider = new DefaultACLProvider();
        }
        String rootWithNamespace = ZooKeeperUtils.generateZookeeperPath(root, namespace);
        LOG.info("Using '{}' as Zookeeper namespace.", (Object)rootWithNamespace);
        boolean ensembleTracking = (Boolean)configuration.get(HighAvailabilityOptions.ZOOKEEPER_ENSEMBLE_TRACKING);
        CuratorFrameworkFactory.Builder curatorFrameworkBuilder = CuratorFrameworkFactory.builder().connectString(zkQuorum).sessionTimeoutMs(sessionTimeout).connectionTimeoutMs(connectionTimeout).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(retryWait, maxRetryAttempts)).namespace(ZooKeeperUtils.trimStartingSlash(rootWithNamespace)).ensembleTracker(ensembleTracking).aclProvider((ACLProvider)aclProvider);
        if (configuration.contains(HighAvailabilityOptions.ZOOKEEPER_CLIENT_AUTHORIZATION)) {
            Map authMap = (Map)configuration.get(HighAvailabilityOptions.ZOOKEEPER_CLIENT_AUTHORIZATION);
            List authInfos = authMap.entrySet().stream().map(entry -> new AuthInfo((String)entry.getKey(), ((String)entry.getValue()).getBytes(ConfigConstants.DEFAULT_CHARSET))).collect(Collectors.toList());
            curatorFrameworkBuilder.authorization(authInfos);
        }
        if (configuration.contains(HighAvailabilityOptions.ZOOKEEPER_MAX_CLOSE_WAIT)) {
            long maxCloseWait = ((Duration)configuration.get(HighAvailabilityOptions.ZOOKEEPER_MAX_CLOSE_WAIT)).toMillis();
            if (maxCloseWait < 0L || maxCloseWait > Integer.MAX_VALUE) {
                throw new IllegalConfigurationException("The value (%d ms) is out-of-range for %s. The milliseconds timeout is expected to be between 0 and %d ms.", new Object[]{maxCloseWait, HighAvailabilityOptions.ZOOKEEPER_MAX_CLOSE_WAIT.key(), Integer.MAX_VALUE});
            }
            curatorFrameworkBuilder.maxCloseWaitMs((int)maxCloseWait);
        }
        if (configuration.contains(HighAvailabilityOptions.ZOOKEEPER_SIMULATED_SESSION_EXP_PERCENT)) {
            curatorFrameworkBuilder.simulatedSessionExpirationPercent(((Integer)configuration.get(HighAvailabilityOptions.ZOOKEEPER_SIMULATED_SESSION_EXP_PERCENT)).intValue());
        }
        if (((Boolean)configuration.get(HighAvailabilityOptions.ZOOKEEPER_TOLERATE_SUSPENDED_CONNECTIONS)).booleanValue()) {
            curatorFrameworkBuilder.connectionStateErrorPolicy((ConnectionStateErrorPolicy)new SessionConnectionStateErrorPolicy());
        }
        return ZooKeeperUtils.startCuratorFramework(curatorFrameworkBuilder, fatalErrorHandler);
    }

    @VisibleForTesting
    public static CuratorFrameworkWithUnhandledErrorListener startCuratorFramework(CuratorFrameworkFactory.Builder builder, FatalErrorHandler fatalErrorHandler) {
        CuratorFramework cf = builder.build();
        UnhandledErrorListener unhandledErrorListener = (message, throwable) -> {
            LOG.error("Unhandled error in curator framework, error message: {}", (Object)message, (Object)throwable);
            fatalErrorHandler.onFatalError(throwable);
        };
        cf.getUnhandledErrorListenable().addListener((Object)unhandledErrorListener);
        cf.start();
        return new CuratorFrameworkWithUnhandledErrorListener(cf, unhandledErrorListener);
    }

    public static boolean isZooKeeperRecoveryMode(Configuration flinkConf) {
        return HighAvailabilityMode.fromConfig(flinkConf).equals((Object)HighAvailabilityMode.ZOOKEEPER);
    }

    public static String getZooKeeperEnsemble(Configuration flinkConf) throws IllegalConfigurationException {
        String zkQuorum = flinkConf.getValue(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM);
        if (zkQuorum == null || StringUtils.isBlank((CharSequence)zkQuorum)) {
            throw new IllegalConfigurationException("No ZooKeeper quorum specified in config.");
        }
        zkQuorum = zkQuorum.replaceAll("\\s+", "");
        return zkQuorum;
    }

    public static DefaultLeaderRetrievalService createLeaderRetrievalService(CuratorFramework client) {
        return ZooKeeperUtils.createLeaderRetrievalService(client, "", new Configuration());
    }

    public static DefaultLeaderRetrievalService createLeaderRetrievalService(CuratorFramework client, String path, Configuration configuration) {
        return new DefaultLeaderRetrievalService(ZooKeeperUtils.createLeaderRetrievalDriverFactory(client, path, configuration));
    }

    public static ZooKeeperLeaderRetrievalDriverFactory createLeaderRetrievalDriverFactory(CuratorFramework client) {
        return ZooKeeperUtils.createLeaderRetrievalDriverFactory(client, "");
    }

    public static ZooKeeperLeaderRetrievalDriverFactory createLeaderRetrievalDriverFactory(CuratorFramework client, String path) {
        return ZooKeeperUtils.createLeaderRetrievalDriverFactory(client, path, new Configuration());
    }

    public static ZooKeeperLeaderRetrievalDriverFactory createLeaderRetrievalDriverFactory(CuratorFramework client, String path, Configuration configuration) {
        ZooKeeperLeaderRetrievalDriver.LeaderInformationClearancePolicy leaderInformationClearancePolicy = (Boolean)configuration.get(HighAvailabilityOptions.ZOOKEEPER_TOLERATE_SUSPENDED_CONNECTIONS) != false ? ZooKeeperLeaderRetrievalDriver.LeaderInformationClearancePolicy.ON_LOST_CONNECTION : ZooKeeperLeaderRetrievalDriver.LeaderInformationClearancePolicy.ON_SUSPENDED_CONNECTION;
        return new ZooKeeperLeaderRetrievalDriverFactory(client, path, leaderInformationClearancePolicy);
    }

    public static void writeLeaderInformationToZooKeeper(LeaderInformation leaderInformation, CuratorFramework curatorFramework, BooleanSupplier hasLeadershipCheck, String connectionInformationPath) throws Exception {
        byte[] data;
        if (leaderInformation.isEmpty()) {
            data = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeUTF(leaderInformation.getLeaderAddress());
            oos.writeObject(leaderInformation.getLeaderSessionID());
            oos.close();
            data = baos.toByteArray();
        }
        boolean dataWritten = false;
        while (!dataWritten && hasLeadershipCheck.getAsBoolean()) {
            Stat stat = (Stat)curatorFramework.checkExists().forPath(connectionInformationPath);
            if (stat != null) {
                long sessionID;
                long owner = stat.getEphemeralOwner();
                if (owner == (sessionID = curatorFramework.getZookeeperClient().getZooKeeper().getSessionId())) {
                    try {
                        curatorFramework.setData().forPath(connectionInformationPath, data);
                        dataWritten = true;
                    }
                    catch (KeeperException.NoNodeException noNodeException) {}
                    continue;
                }
                try {
                    curatorFramework.delete().forPath(connectionInformationPath);
                }
                catch (KeeperException.NoNodeException noNodeException) {}
                continue;
            }
            try {
                ((ACLBackgroundPathAndBytesable)curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(connectionInformationPath, data);
                dataWritten = true;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {}
        }
    }

    public static LeaderInformation readLeaderInformation(byte[] data) throws IOException, ClassNotFoundException {
        if (data != null && data.length > 0) {
            UUID leaderSessionID;
            String leaderAddress;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                leaderAddress = ois.readUTF();
                leaderSessionID = (UUID)ois.readObject();
            }
            return LeaderInformation.known(leaderSessionID, leaderAddress);
        }
        return LeaderInformation.empty();
    }

    public static JobGraphStore createJobGraphs(CuratorFramework client, Configuration configuration) throws Exception {
        Preconditions.checkNotNull((Object)configuration, (String)"Configuration");
        FileSystemStateStorageHelper stateStorage = ZooKeeperUtils.createFileSystemStateStorage(configuration, HA_STORAGE_SUBMITTED_JOBGRAPH_PREFIX);
        String zooKeeperJobsPath = (String)configuration.get(HighAvailabilityOptions.HA_ZOOKEEPER_JOBGRAPHS_PATH);
        client.newNamespaceAwareEnsurePath(zooKeeperJobsPath).ensure(client.getZookeeperClient());
        CuratorFramework facade = client.usingNamespace(client.getNamespace() + zooKeeperJobsPath);
        String zooKeeperFullJobsPath = client.getNamespace() + zooKeeperJobsPath;
        ZooKeeperStateHandleStore<JobGraph> zooKeeperStateHandleStore = new ZooKeeperStateHandleStore<JobGraph>(facade, stateStorage);
        PathChildrenCache pathCache = new PathChildrenCache(facade, "/", false);
        return new DefaultJobGraphStore(zooKeeperStateHandleStore, new ZooKeeperJobGraphStoreWatcher(pathCache), ZooKeeperJobGraphStoreUtil.INSTANCE);
    }

    public static CompletedCheckpointStore createCompletedCheckpoints(CuratorFramework client, Configuration configuration, int maxNumberOfCheckpointsToRetain, SharedStateRegistryFactory sharedStateRegistryFactory, Executor ioExecutor, Executor executor, RestoreMode restoreMode) throws Exception {
        Preconditions.checkNotNull((Object)configuration, (String)"Configuration");
        FileSystemStateStorageHelper stateStorage = ZooKeeperUtils.createFileSystemStateStorage(configuration, HA_STORAGE_COMPLETED_CHECKPOINT);
        ZooKeeperStateHandleStore<CompletedCheckpoint> completedCheckpointStateHandleStore = ZooKeeperUtils.createZooKeeperStateHandleStore(client, ZooKeeperUtils.getCheckpointsPath(), stateStorage);
        Collection<CompletedCheckpoint> completedCheckpoints = DefaultCompletedCheckpointStoreUtils.retrieveCompletedCheckpoints(completedCheckpointStateHandleStore, ZooKeeperCheckpointStoreUtil.INSTANCE);
        DefaultCompletedCheckpointStore zooKeeperCompletedCheckpointStore = new DefaultCompletedCheckpointStore(maxNumberOfCheckpointsToRetain, completedCheckpointStateHandleStore, ZooKeeperCheckpointStoreUtil.INSTANCE, completedCheckpoints, sharedStateRegistryFactory.create(ioExecutor, completedCheckpoints, restoreMode), executor);
        LOG.info("Initialized {} in '{}' with {}.", new Object[]{DefaultCompletedCheckpointStore.class.getSimpleName(), completedCheckpointStateHandleStore, ZooKeeperUtils.getCheckpointsPath()});
        return zooKeeperCompletedCheckpointStore;
    }

    public static String getPathForJob(JobID jobId) {
        Preconditions.checkNotNull((Object)jobId, (String)"Job ID");
        return String.format("/%s", jobId);
    }

    public static <T extends Serializable> ZooKeeperStateHandleStore<T> createZooKeeperStateHandleStore(CuratorFramework client, String path, RetrievableStateStorageHelper<T> stateStorage) throws Exception {
        return new ZooKeeperStateHandleStore<T>(ZooKeeperUtils.useNamespaceAndEnsurePath(client, path), stateStorage);
    }

    public static ZooKeeperCheckpointIDCounter createCheckpointIDCounter(CuratorFramework client) {
        return new ZooKeeperCheckpointIDCounter(client, new DefaultLastStateConnectionStateListener());
    }

    public static <T extends Serializable> FileSystemStateStorageHelper<T> createFileSystemStateStorage(Configuration configuration, String prefix) throws IOException {
        return new FileSystemStateStorageHelper(HighAvailabilityServicesUtils.getClusterHighAvailableStoragePath(configuration), prefix);
    }

    public static String generateZookeeperPath(String ... paths) {
        return Arrays.stream(paths).map(ZooKeeperUtils::trimSlashes).filter(s -> !s.isEmpty()).collect(Collectors.joining("/", "/", ""));
    }

    public static String[] splitZooKeeperPath(String path) {
        return path.split("/");
    }

    public static String trimStartingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    private static String trimSlashes(String input) {
        int left;
        int right = input.length() - 1;
        for (left = 0; left <= right && input.charAt(left) == '/'; ++left) {
        }
        while (right >= left && input.charAt(right) == '/') {
            --right;
        }
        if (left <= right) {
            return input.substring(left, right + 1);
        }
        return "";
    }

    public static CuratorFramework useNamespaceAndEnsurePath(CuratorFramework client, String path) throws Exception {
        Preconditions.checkNotNull((Object)client, (String)"client must not be null");
        Preconditions.checkNotNull((Object)path, (String)"path must not be null");
        client.newNamespaceAwareEnsurePath(path).ensure(client.getZookeeperClient());
        String newNamespace = ZooKeeperUtils.generateZookeeperPath(client.getNamespace(), path);
        return client.usingNamespace(ZooKeeperUtils.trimStartingSlash(newNamespace));
    }

    public static TreeCache createTreeCache(CuratorFramework client, String pathToNode, RunnableWithException nodeChangeCallback) {
        TreeCache cache = ZooKeeperUtils.createTreeCache(client, pathToNode, ZooKeeperUtils.treeCacheSelectorForPath(pathToNode));
        cache.getListenable().addListener((Object)ZooKeeperUtils.createTreeCacheListener(nodeChangeCallback));
        return cache;
    }

    public static TreeCache createTreeCache(CuratorFramework client, String pathToNode, TreeCacheSelector selector) {
        return TreeCache.newBuilder((CuratorFramework)client, (String)pathToNode).setCacheData(true).setCreateParentNodes(false).setSelector(selector).setExecutor(Executors.newDirectExecutorServiceWithNoOpShutdown()).build();
    }

    @VisibleForTesting
    static TreeCacheListener createTreeCacheListener(RunnableWithException nodeChangeCallback) {
        return (ignored, event) -> {
            switch (event.getType()) {
                case NODE_ADDED: 
                case NODE_UPDATED: 
                case NODE_REMOVED: {
                    nodeChangeCallback.run();
                }
            }
        };
    }

    private static TreeCacheSelector treeCacheSelectorForPath(final String fullPath) {
        return new TreeCacheSelector(){

            public boolean traverseChildren(String childPath) {
                return false;
            }

            public boolean acceptChild(String childPath) {
                return fullPath.equals(childPath);
            }
        };
    }

    public static void deleteZNode(CuratorFramework curatorFramework, String path) throws Exception {
        ((DeleteBuilderMain)curatorFramework.delete().idempotent()).deletingChildrenIfNeeded().forPath(path);
    }

    private ZooKeeperUtils() {
        throw new RuntimeException();
    }

    public static enum ZkClientACLMode {
        CREATOR,
        OPEN;


        public static ZkClientACLMode fromConfig(Configuration config) {
            String aclMode = (String)config.get(HighAvailabilityOptions.ZOOKEEPER_CLIENT_ACL);
            if (aclMode == null || aclMode.equalsIgnoreCase(OPEN.name())) {
                return OPEN;
            }
            if (aclMode.equalsIgnoreCase(CREATOR.name())) {
                return CREATOR;
            }
            String message = "Unsupported ACL option: [" + aclMode + "] provided";
            LOG.error(message);
            throw new IllegalConfigurationException(message);
        }
    }

    public static class SecureAclProvider
    implements ACLProvider {
        public List<ACL> getDefaultAcl() {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }

        public List<ACL> getAclForPath(String path) {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }
    }
}

