/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.mixed;

import java.util.Map;
import java.util.Set;
import org.apache.amoro.PooledAmsClient;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.NoSuchObjectException;
import org.apache.amoro.client.AmsThriftUrl;
import org.apache.amoro.mixed.BasicMixedIcebergCatalog;
import org.apache.amoro.mixed.InternalMixedIcebergCatalog;
import org.apache.amoro.mixed.MixedFormatCatalog;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.CatalogUtil;
import org.apache.amoro.utils.MixedFormatCatalogUtil;
import org.apache.iceberg.common.DynConstructors;

public class CatalogLoader {
    public static final String INTERNAL_CATALOG_IMPL = InternalMixedIcebergCatalog.class.getName();
    public static final String HIVE_CATALOG_IMPL = "org.apache.amoro.hive.catalog.MixedHiveCatalog";
    public static final String MIXED_ICEBERG_CATALOG_IMP = BasicMixedIcebergCatalog.class.getName();

    public static MixedFormatCatalog load(String catalogUrl, Map<String, String> properties) {
        AmsThriftUrl url = AmsThriftUrl.parse((String)catalogUrl, (String)"TableMetastore");
        if (url.catalogName() == null || url.catalogName().contains("/")) {
            throw new IllegalArgumentException("invalid catalog name " + url.catalogName());
        }
        return CatalogLoader.loadCatalog(catalogUrl, url.catalogName(), properties);
    }

    public static MixedFormatCatalog load(String catalogUrl) {
        return CatalogLoader.load(catalogUrl, Maps.newHashMap());
    }

    private static String catalogImpl(String metastoreType, Map<String, String> catalogProperties) {
        String catalogImpl;
        switch (metastoreType) {
            case "hadoop": 
            case "glue": 
            case "custom": {
                catalogImpl = MIXED_ICEBERG_CATALOG_IMP;
                break;
            }
            case "hive": {
                Set tableFormats = CatalogUtil.tableFormats((String)metastoreType, catalogProperties);
                if (tableFormats.contains(TableFormat.MIXED_HIVE)) {
                    catalogImpl = HIVE_CATALOG_IMPL;
                    break;
                }
                catalogImpl = MIXED_ICEBERG_CATALOG_IMP;
                break;
            }
            case "ams": {
                catalogImpl = INTERNAL_CATALOG_IMPL;
                break;
            }
            default: {
                throw new IllegalStateException("unsupported metastore type:" + metastoreType);
            }
        }
        return catalogImpl;
    }

    public static CatalogMeta loadMeta(String catalogUrl) {
        AmsThriftUrl url = AmsThriftUrl.parse((String)catalogUrl, (String)"TableMetastore");
        if (url.catalogName() == null || url.catalogName().contains("/")) {
            throw new IllegalArgumentException("invalid catalog name " + url.catalogName());
        }
        PooledAmsClient client = new PooledAmsClient(catalogUrl);
        try {
            return client.getCatalog(url.catalogName());
        }
        catch (TException e) {
            throw new IllegalStateException("failed when load catalog " + url.catalogName(), e);
        }
    }

    private static MixedFormatCatalog loadCatalog(String metaStoreUrl, String catalogName, Map<String, String> properties) {
        PooledAmsClient client = new PooledAmsClient(metaStoreUrl);
        try {
            CatalogMeta catalogMeta = client.getCatalog(catalogName);
            String type = catalogMeta.getCatalogType();
            catalogMeta.putToCatalogProperties("ams.uri", metaStoreUrl);
            MixedFormatCatalogUtil.mergeCatalogProperties(catalogMeta, properties);
            return CatalogLoader.createCatalog(catalogName, type, catalogMeta.getCatalogProperties(), CatalogUtil.buildMetaStore((CatalogMeta)catalogMeta));
        }
        catch (NoSuchObjectException e1) {
            throw new IllegalArgumentException("catalog not found, please check catalog name", e1);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed when load catalog " + catalogName, e);
        }
    }

    public static MixedFormatCatalog createCatalog(String catalogName, String metastoreType, Map<String, String> properties, TableMetaStore metaStore) {
        String catalogImpl = CatalogLoader.catalogImpl(metastoreType, properties);
        MixedFormatCatalog catalog = CatalogLoader.buildCatalog(catalogImpl);
        if (!properties.containsKey("type")) {
            properties.put("type", metastoreType);
        }
        catalog.initialize(catalogName, properties, metaStore);
        return catalog;
    }

    private static MixedFormatCatalog buildCatalog(String impl) {
        DynConstructors.Ctor ctor;
        try {
            ctor = DynConstructors.builder(MixedFormatCatalog.class).impl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize Catalog implementation %s: %s", impl, e.getMessage()), e);
        }
        try {
            return (MixedFormatCatalog)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize Catalog, %s does not implement Catalog.", impl), e);
        }
    }
}

