/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;

public class MixedTableOperations
implements TableOperations {
    private final TableOperations ops;
    private final AuthenticatedFileIO authenticatedFileIO;

    public MixedTableOperations(TableOperations ops, AuthenticatedFileIO authenticatedFileIO) {
        this.ops = ops;
        this.authenticatedFileIO = authenticatedFileIO;
    }

    public TableMetadata current() {
        return this.authenticatedFileIO.doAs(() -> ((TableOperations)this.ops).current());
    }

    public TableMetadata refresh() {
        return this.authenticatedFileIO.doAs(() -> ((TableOperations)this.ops).refresh());
    }

    public void commit(TableMetadata base, TableMetadata metadata) {
        this.authenticatedFileIO.doAs(() -> {
            this.ops.commit(base, metadata);
            return null;
        });
    }

    public FileIO io() {
        return this.authenticatedFileIO;
    }

    public String metadataFileLocation(String fileName) {
        return this.ops.metadataFileLocation(fileName);
    }

    public LocationProvider locationProvider() {
        return this.ops.locationProvider();
    }

    public TableOperations temp(TableMetadata uncommittedMetadata) {
        final TableOperations temp = this.ops.temp(uncommittedMetadata);
        return new TableOperations(){

            public TableMetadata current() {
                return MixedTableOperations.this.authenticatedFileIO.doAs(() -> ((TableOperations)temp).current());
            }

            public TableMetadata refresh() {
                return MixedTableOperations.this.authenticatedFileIO.doAs(() -> ((TableOperations)temp).refresh());
            }

            public void commit(TableMetadata base, TableMetadata metadata) {
                MixedTableOperations.this.authenticatedFileIO.doAs(() -> {
                    temp.commit(base, metadata);
                    return null;
                });
            }

            public FileIO io() {
                return MixedTableOperations.this.authenticatedFileIO;
            }

            public String metadataFileLocation(String fileName) {
                return MixedTableOperations.this.authenticatedFileIO.doAs(() -> temp.metadataFileLocation(fileName));
            }

            public LocationProvider locationProvider() {
                return MixedTableOperations.this.authenticatedFileIO.doAs(() -> ((TableOperations)temp).locationProvider());
            }
        };
    }
}

