/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.process;

import java.util.Map;
import org.apache.amoro.api.OptimizingTask;
import org.apache.amoro.api.OptimizingTaskId;
import org.apache.amoro.utils.SerializationUtil;

public abstract class StagedTaskDescriptor<I, O, S> {
    protected long tableId;
    protected I input;
    protected volatile O output;
    protected volatile S summary;
    protected Map<String, String> properties;

    protected StagedTaskDescriptor() {
    }

    public StagedTaskDescriptor(long tableId, I input, Map<String, String> properties) {
        this.tableId = tableId;
        this.input = input;
        this.properties = properties;
        this.calculateSummary();
    }

    public void reset() {
        this.output = null;
        this.calculateSummary();
    }

    protected abstract void calculateSummary();

    protected abstract O deserializeOutput(byte[] var1);

    public long getTableId() {
        return this.tableId;
    }

    public void setOutputBytes(byte[] outputBytes) {
        this.output = this.deserializeOutput(outputBytes);
        this.calculateSummary();
    }

    public void setInput(I input) {
        this.input = input;
        this.calculateSummary();
    }

    public I getInput() {
        return this.input;
    }

    public O getOutput() {
        return this.output;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public S getSummary() {
        return this.summary;
    }

    public OptimizingTask extractProtocolTask(OptimizingTaskId taskId) {
        OptimizingTask optimizingTask = new OptimizingTask(taskId);
        optimizingTask.setTaskInput(SerializationUtil.simpleSerialize(this.input));
        optimizingTask.setProperties(this.properties);
        return optimizingTask;
    }
}

