/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.io.Serializable;
import java.util.Date;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.ui.PagedDataSource;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.jobs.StageTableRowData;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u4QAD\b\u0001#eA\u0001B\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A\u0011\t\u0001B\u0001B\u0003%!\tC\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0015\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u001d\t\u0007A1A\u0005\n\tDa\u0001\u001b\u0001!\u0002\u0013\u0019\u0007\"B5\u0001\t\u0003R\u0007\"B6\u0001\t\u0003b\u0007\"\u0002:\u0001\t\u0013\u0019\b\"\u0002<\u0001\t\u00139(aD*uC\u001e,G)\u0019;b'>,(oY3\u000b\u0005A\t\u0012\u0001\u00026pENT!AE\n\u0002\u0005UL'B\u0001\u000b\u0016\u0003\u0015\u0019\b/\u0019:l\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0014\u0005\u0001Q\u0002cA\u000e\u001d=5\t\u0011#\u0003\u0002\u001e#\ty\u0001+Y4fI\u0012\u000bG/Y*pkJ\u001cW\r\u0005\u0002 A5\tq\"\u0003\u0002\"\u001f\t\t2\u000b^1hKR\u000b'\r\\3S_^$\u0015\r^1\u0002\u000bM$xN]3\u0004\u0001A\u0011Q\u0005K\u0007\u0002M)\u0011qeE\u0001\u0007gR\fG/^:\n\u0005%2#AD!qaN#\u0018\r^;t'R|'/Z\u0001\u0007gR\fw-Z:\u0011\u000712\u0014H\u0004\u0002.g9\u0011a&M\u0007\u0002_)\u0011\u0001gI\u0001\u0007yI|w\u000e\u001e \n\u0003I\nQa]2bY\u0006L!\u0001N\u001b\u0002\u000fA\f7m[1hK*\t!'\u0003\u00028q\t\u00191+Z9\u000b\u0005Q*\u0004C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\t1\u0018G\u0003\u0002?M\u0005\u0019\u0011\r]5\n\u0005\u0001[$!C*uC\u001e,G)\u0019;b\u0003-\u0019WO\u001d:f]R$\u0016.\\3\u0011\u0005\r#U\"A\u001b\n\u0005\u0015+$\u0001\u0002'p]\u001e\f\u0001\u0002]1hKNK'0\u001a\t\u0003\u0007\"K!!S\u001b\u0003\u0007%sG/\u0003\u0002G9\u0005Q1o\u001c:u\u0007>dW/\u001c8\u0011\u00055\u000bfB\u0001(P!\tqS'\u0003\u0002Qk\u00051\u0001K]3eK\u001aL!AU*\u0003\rM#(/\u001b8h\u0015\t\u0001V'\u0001\u0003eKN\u001c\u0007CA\"W\u0013\t9VGA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u001dQ6\fX/_?\u0002\u0004\"a\b\u0001\t\u000b\t:\u0001\u0019\u0001\u0013\t\u000b):\u0001\u0019A\u0016\t\u000b\u0005;\u0001\u0019\u0001\"\t\u000b\u0019;\u0001\u0019A$\t\u000b-;\u0001\u0019\u0001'\t\u000bQ;\u0001\u0019A+\u0002\t\u0011\fG/Y\u000b\u0002GB\u0019Am\u001a\u0010\u000e\u0003\u0015T!AZ\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00028K\u0006)A-\u0019;bA\u0005AA-\u0019;b'&TX-F\u0001H\u0003%\u0019H.[2f\t\u0006$\u0018\rF\u0002n]B\u00042\u0001\f\u001c\u001f\u0011\u0015y7\u00021\u0001H\u0003\u00111'o\\7\t\u000bE\\\u0001\u0019A$\u0002\u0005Q|\u0017\u0001C:uC\u001e,'k\\<\u0015\u0005y!\b\"B;\r\u0001\u0004I\u0014!C:uC\u001e,G)\u0019;b\u0003!y'\u000fZ3sS:<Gc\u0001=|yB\u0019A&\u001f\u0010\n\u0005iD$\u0001C(sI\u0016\u0014\u0018N\\4\t\u000b-k\u0001\u0019\u0001'\t\u000bQk\u0001\u0019A+")
public class StageDataSource
extends PagedDataSource<StageTableRowData> {
    private final long currentTime;
    private final Seq<StageTableRowData> data;

    private Seq<StageTableRowData> data() {
        return this.data;
    }

    @Override
    public int dataSize() {
        return this.data().size();
    }

    @Override
    public Seq<StageTableRowData> sliceData(int from, int to) {
        return (Seq)this.data().slice(from, to);
    }

    private StageTableRowData stageRow(StageData stageData) {
        String string;
        Option<Date> option = stageData.submissionTime();
        if (option instanceof Some) {
            Some some = (Some)option;
            Date t = (Date)some.value();
            string = UIUtils$.MODULE$.formatDate(t);
        } else if (None$.MODULE$.equals(option)) {
            string = "Unknown";
        } else {
            throw new MatchError(option);
        }
        String formattedSubmissionTime = string;
        long finishTime = BoxesRunTime.unboxToLong((Object)stageData.completionTime().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.currentTime));
        Option duration = stageData.firstTaskLaunchedTime().map((Function1 & Serializable & scala.Serializable)date -> BoxesRunTime.boxToLong((long)StageDataSource.$anonfun$stageRow$3(this, finishTime, date)));
        String formattedDuration = (String)duration.map((Function1 & Serializable & scala.Serializable)d -> UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)d))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unknown");
        long inputRead = stageData.inputBytes();
        String inputReadWithUnit = inputRead > 0L ? Utils$.MODULE$.bytesToString(inputRead) : "";
        long outputWrite = stageData.outputBytes();
        String outputWriteWithUnit = outputWrite > 0L ? Utils$.MODULE$.bytesToString(outputWrite) : "";
        long shuffleRead = stageData.shuffleReadBytes();
        String shuffleReadWithUnit = shuffleRead > 0L ? Utils$.MODULE$.bytesToString(shuffleRead) : "";
        long shuffleWrite = stageData.shuffleWriteBytes();
        String shuffleWriteWithUnit = shuffleWrite > 0L ? Utils$.MODULE$.bytesToString(shuffleWrite) : "";
        return new StageTableRowData(stageData, (Option<StageData>)new Some((Object)stageData), stageData.stageId(), stageData.attemptId(), stageData.schedulingPool(), stageData.description(), (Date)stageData.submissionTime().getOrElse((Function0 & Serializable & scala.Serializable)() -> new Date(0L)), formattedSubmissionTime, BoxesRunTime.unboxToLong((Object)duration.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)), formattedDuration, inputRead, inputReadWithUnit, outputWrite, outputWriteWithUnit, shuffleRead, shuffleReadWithUnit, shuffleWrite, shuffleWriteWithUnit);
    }

    private Ordering<StageTableRowData> ordering(String sortColumn, boolean desc) {
        Ordering ordering;
        String string = sortColumn;
        if ("Stage Id".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.stageId()), (Ordering)Ordering.Int$.MODULE$);
        } else if ("Pool Name".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$6 -> x$6.schedulingPool(), (Ordering)Ordering.String$.MODULE$);
        } else if ("Description".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x.descriptionOption(), (Object)x.stage().name()), Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.Option((Ordering)Ordering.String$.MODULE$), (Ordering)Ordering.String$.MODULE$));
        } else if ("Submitted".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$7 -> x$7.submissionTime(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        } else if ("Duration".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.duration()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Input".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.inputRead()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Output".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.outputWrite()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Shuffle Read".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.shuffleRead()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Shuffle Write".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.shuffleWrite()), (Ordering)Ordering.Long$.MODULE$);
        } else {
            if ("Tasks: Succeeded/Total".equals(string)) {
                throw new IllegalArgumentException(new StringBuilder(19).append("Unsortable column: ").append(sortColumn).toString());
            }
            throw new IllegalArgumentException(new StringBuilder(16).append("Unknown column: ").append(string).toString());
        }
        Ordering ordering2 = ordering;
        return desc ? ordering2.reverse() : ordering2;
    }

    public static final /* synthetic */ long $anonfun$stageRow$3(StageDataSource $this, long finishTime$1, Date date) {
        long time = date.getTime();
        return finishTime$1 > time ? finishTime$1 - time : $this.currentTime - time;
    }

    public StageDataSource(AppStatusStore store, Seq<StageData> stages, long currentTime, int pageSize, String sortColumn, boolean desc) {
        this.currentTime = currentTime;
        super(pageSize);
        this.data = (Seq)((SeqLike)stages.map((Function1 & Serializable & scala.Serializable)stageData -> this.stageRow((StageData)stageData), Seq$.MODULE$.canBuildFrom())).sorted(this.ordering(sortColumn, desc));
    }
}

